/*
 * Decompiled with CFR 0.152.
 */
package com.github.cropbitmap;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.github.cropbitmap.CropViewUtils;
import com.github.cropbitmap.R;
import java.io.FileDescriptor;
import java.io.InputStream;

public class LikeQQCropView
extends View {
    private float centerX;
    private float centerY;
    private Bitmap showBitmap;
    private RectF showBitmapRectF;
    private Matrix showBitmapMatrix;
    private Paint showBitmapPaint;
    private float maxScale = 3.0f;
    protected float doubleClickScale = 1.8f;
    protected float doubleClickX;
    protected float doubleClickY;
    private float minCircleScale = 1.0f;
    private float initScale = 1.0f;
    private float initTranslateX;
    private float initTranslateY;
    private RectF circleRectF;
    private RectF initCircleRectF;
    private Matrix circleRectFMatrix;
    private RectF bigCircleRectF;
    private Path circlePath;
    private Path circleBorderPath;
    private Paint circleBorderPaint;
    private Path outsidePath;
    private Paint paint;
    private Paint bgPaint;
    private Region touchRegion;
    private int touchArea;
    private int touchLength = 10;
    private Path bigCirclePath;
    private boolean canZoomCircle;
    private boolean canMoveBitmap;
    private GestureDetector gestureDetector;
    private ScaleGestureDetector scaleGestureDetector;
    private ValueAnimator valueAnimator;
    private float radius = -1.0f;
    private int bgColor = -1;
    private int maskColor;
    private int borderColor;
    private boolean sizeChanged;

    public float getRadius() {
        return this.radius;
    }

    public float getClipWidth() {
        return this.getRectLength(this.circleRectF);
    }

    public LikeQQCropView setRadius(float radius) {
        this.radius = radius;
        this.post(new Runnable(){

            @Override
            public void run() {
                LikeQQCropView.this.refreshPath();
                LikeQQCropView.this.invalidate();
            }
        });
        return this;
    }

    public int getMaskColor() {
        return this.maskColor;
    }

    public LikeQQCropView setMaskColor(@ColorInt int maskColor) {
        this.maskColor = maskColor;
        if (this.sizeChanged) {
            this.refreshPaint();
            this.invalidate();
        }
        return this;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public LikeQQCropView setBgColor(int bgColor) {
        this.bgColor = bgColor;
        return this;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public LikeQQCropView setBorderColor(@ColorInt int borderColor) {
        this.borderColor = borderColor;
        if (this.sizeChanged) {
            this.refreshPaint();
            this.invalidate();
        }
        return this;
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    public LikeQQCropView setMaxScale(float maxScale) {
        if (maxScale < 1.0f) {
            maxScale = 1.0f;
        }
        if (this.doubleClickScale > maxScale) {
            this.doubleClickScale = maxScale;
        }
        this.maxScale = maxScale;
        return this;
    }

    public float getDoubleClickScale() {
        return this.doubleClickScale;
    }

    public LikeQQCropView setDoubleClickScale(float doubleClickScale) {
        if (doubleClickScale < 1.0f) {
            doubleClickScale = 1.0f;
        }
        if (doubleClickScale > this.maxScale) {
            doubleClickScale = this.maxScale;
        }
        this.doubleClickScale = doubleClickScale;
        return this;
    }

    public LikeQQCropView(Context context) {
        super(context);
        this.initGesture();
        this.initAttr(null);
    }

    public LikeQQCropView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initGesture();
        this.initAttr(attrs);
    }

    public LikeQQCropView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initGesture();
        this.initAttr(attrs);
    }

    private void initAttr(AttributeSet attrs) {
        this.maskColor = Color.parseColor((String)"#60000000");
        this.borderColor = ContextCompat.getColor((Context)this.getContext(), (int)17170443);
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.LikeQQCropView);
        this.maskColor = typedArray.getColor(R.styleable.LikeQQCropView_maskColor, Color.parseColor((String)"#60000000"));
        this.bgColor = typedArray.getColor(R.styleable.LikeQQCropView_bgColor, -1);
        this.borderColor = typedArray.getColor(R.styleable.LikeQQCropView_borderColor, ContextCompat.getColor((Context)this.getContext(), (int)17170443));
        this.radius = typedArray.getDimension(R.styleable.LikeQQCropView_radius, -1.0f);
        this.maxScale = typedArray.getFloat(R.styleable.LikeQQCropView_maxScale, 3.0f);
        this.doubleClickScale = typedArray.getFloat(R.styleable.LikeQQCropView_doubleClickScale, 1.8f);
        if (this.maxScale < 1.0f) {
            this.maxScale = 1.0f;
        }
        if (this.doubleClickScale < 1.0f) {
            this.doubleClickScale = 1.0f;
        }
        if (this.doubleClickScale > this.maxScale) {
            this.doubleClickScale = this.maxScale;
        }
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = this.getScreenWidth() / 2;
        int height = this.getScreenWidth() / 2;
        if (-2 == this.getLayoutParams().width && -2 == this.getLayoutParams().height) {
            this.setMeasuredDimension(width, height);
        } else if (-2 == this.getLayoutParams().width) {
            this.setMeasuredDimension(width, heightSize);
        } else if (-2 == this.getLayoutParams().height) {
            this.setMeasuredDimension(widthSize, height);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private int getScreenWidth() {
        return this.getContext().getResources().getDisplayMetrics().widthPixels;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.touchRegion = new Region();
        this.paint = new Paint(1);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(2.0f);
        this.circleBorderPaint = new Paint(1);
        this.circleBorderPaint.setColor(this.borderColor);
        this.circleBorderPaint.setStyle(Paint.Style.STROKE);
        this.circleBorderPaint.setStrokeWidth((float)this.dip2px(this.getContext(), 1.0f));
        this.bgPaint = new Paint(1);
        this.bgPaint.setColor(this.maskColor);
        this.showBitmapPaint = new Paint(1);
        this.showBitmapPaint.setStyle(Paint.Style.STROKE);
        this.showBitmapPaint.setStrokeWidth(2.0f);
        this.init();
        this.sizeChanged = true;
    }

    private void init() {
        this.centerX = this.getWidth() / 2;
        this.centerY = this.getHeight() / 2;
        this.circleBorderPath = new Path();
        this.circlePath = new Path();
        this.outsidePath = new Path();
        this.bigCirclePath = new Path();
        if (this.showBitmap == null) {
            return;
        }
        if (this.showBitmap.getHeight() < this.getHeight() && this.showBitmap.getWidth() < this.getWidth()) {
            this.initScale = 1.0f;
            this.initTranslateX = (this.getWidth() - this.showBitmap.getWidth()) / 2;
            this.initTranslateY = (this.getHeight() - this.showBitmap.getHeight()) / 2;
        } else if ((float)this.showBitmap.getWidth() * 1.0f / (float)this.showBitmap.getHeight() > (float)this.getWidth() * 1.0f / (float)this.getHeight()) {
            this.initScale = (float)this.getWidth() * 1.0f / (float)this.showBitmap.getWidth();
            this.initTranslateX = 0.0f;
            this.initTranslateY = ((float)this.getHeight() - (float)this.showBitmap.getHeight() * this.initScale) / 2.0f;
        } else {
            this.initScale = (float)this.getHeight() * 1.0f / (float)this.showBitmap.getHeight();
            this.initTranslateX = ((float)this.getWidth() - (float)this.showBitmap.getWidth() * this.initScale) / 2.0f;
            this.initTranslateY = 0.0f;
        }
        this.circleRectFMatrix = new Matrix();
        this.showBitmapRectF = new RectF(0.0f, 0.0f, (float)this.showBitmap.getWidth(), (float)this.showBitmap.getHeight());
        this.showBitmapMatrix = new Matrix();
        this.showBitmapMatrix.postScale(this.initScale, this.initScale);
        this.showBitmapMatrix.postTranslate(this.initTranslateX, this.initTranslateY);
        this.showBitmapMatrix.mapRect(this.showBitmapRectF);
        this.initCircleRectF = this.circleRectF = this.getCircleRectFByBitmapRectF(this.showBitmapRectF);
        this.refreshPath();
    }

    private void refreshPaint() {
        this.circleBorderPaint.setColor(this.borderColor);
        this.bgPaint.setColor(this.maskColor);
    }

    private void refreshPath() {
        if (!this.outsidePath.isEmpty()) {
            this.outsidePath.reset();
        }
        this.outsidePath.addRect(new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight()), Path.Direction.CW);
        if (!this.circlePath.isEmpty()) {
            this.circlePath.reset();
        }
        if (this.radius > this.getRectLength(this.circleRectF) / 2.0f || this.radius < 0.0f) {
            this.radius = this.getRectLength(this.circleRectF) / 2.0f;
        }
        this.circlePath.addRoundRect(this.circleRectF, this.radius, this.radius, Path.Direction.CW);
        if (!this.circleBorderPath.isEmpty()) {
            this.circleBorderPath.reset();
        }
        RectF circleBorderRectF = new RectF(this.circleRectF.left + this.getPathInterval(), this.circleRectF.top + this.getPathInterval(), this.circleRectF.right - this.getPathInterval(), this.circleRectF.bottom - this.getPathInterval());
        this.circleBorderPath.addRoundRect(circleBorderRectF, this.radius * this.getRectLength(circleBorderRectF) / this.getRectLength(this.circleRectF), this.radius * this.getRectLength(circleBorderRectF) / this.getRectLength(this.circleRectF), Path.Direction.CW);
        this.outsidePath.op(this.circlePath, Path.Op.XOR);
        this.bigCircleRectF = this.getBigCircleRectF(this.circleRectF);
        if (!this.bigCirclePath.isEmpty()) {
            this.bigCirclePath.reset();
        }
        this.bigCirclePath.addRoundRect(this.bigCircleRectF, (this.bigCircleRectF.right - this.bigCircleRectF.left) / 2.0f, (this.bigCircleRectF.right - this.bigCircleRectF.left) / 2.0f, Path.Direction.CW);
        this.bigCirclePath.op(this.circlePath, Path.Op.XOR);
    }

    public Bitmap clip() {
        if (!this.sizeChanged) {
            return null;
        }
        Paint paint = new Paint(1);
        Matrix matrix = new Matrix();
        this.showBitmapMatrix.invert(matrix);
        RectF rectF = new RectF();
        rectF.set(this.circleRectF);
        matrix.mapRect(rectF);
        Bitmap needCropBitmap = Bitmap.createBitmap((Bitmap)this.showBitmap, (int)((int)rectF.left), (int)((int)rectF.top), (int)((int)(rectF.right - rectF.left)), (int)((int)(rectF.bottom - rectF.top)));
        Bitmap newBitmap = Bitmap.createBitmap((int)((int)this.getRectLength(this.circleRectF)), (int)((int)this.getRectLength(this.circleRectF)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(newBitmap);
        if (this.bgColor != -1) {
            canvas.drawColor(this.bgColor);
        }
        int saveCount = canvas.saveLayer(null, null, 31);
        Path path = new Path();
        path.addRoundRect(new RectF(0.0f, 0.0f, this.getRectLength(this.circleRectF), this.getRectLength(this.circleRectF)), this.radius, this.radius, Path.Direction.CW);
        path.moveTo(0.0f, 0.0f);
        path.moveTo(this.getRectLength(this.circleRectF), this.getRectLength(this.circleRectF));
        canvas.drawPath(path, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(needCropBitmap, new Rect(0, 0, needCropBitmap.getWidth(), needCropBitmap.getHeight()), new RectF(0.0f, 0.0f, this.getRectLength(this.circleRectF), this.getRectLength(this.circleRectF)), paint);
        paint.setXfermode(null);
        canvas.restoreToCount(saveCount);
        float[] temp = new float[9];
        this.showBitmapMatrix.getValues(temp);
        if (temp[0] < 0.0f && temp[4] < 0.0f) {
            newBitmap = this.getFlipBitmap(newBitmap, -1, -1);
        } else if (temp[0] < 0.0f) {
            newBitmap = this.getFlipBitmap(newBitmap, -1, 1);
        } else if (temp[4] < 0.0f) {
            newBitmap = this.getFlipBitmap(newBitmap, 1, -1);
        }
        needCropBitmap.recycle();
        needCropBitmap = null;
        return newBitmap;
    }

    private Bitmap getFlipBitmap(Bitmap newBitmap, int MSCALE_X, int MSCALE_Y) {
        Matrix flipMatrix = new Matrix();
        flipMatrix.postScale((float)MSCALE_X, (float)MSCALE_Y, (float)(newBitmap.getWidth() / 2), (float)(newBitmap.getWidth() / 2));
        newBitmap = Bitmap.createBitmap((Bitmap)newBitmap, (int)0, (int)0, (int)newBitmap.getWidth(), (int)newBitmap.getHeight(), (Matrix)flipMatrix, (boolean)true);
        return newBitmap;
    }

    public void horizontalFlip() {
        this.post(new Runnable(){

            @Override
            public void run() {
                LikeQQCropView.this.showBitmapMatrix.postScale(-1.0f, 1.0f, LikeQQCropView.this.centerX, LikeQQCropView.this.centerY);
                LikeQQCropView.this.showBitmapRectF = new RectF(0.0f, 0.0f, (float)LikeQQCropView.this.showBitmap.getWidth(), (float)LikeQQCropView.this.showBitmap.getHeight());
                LikeQQCropView.this.showBitmapMatrix.mapRect(LikeQQCropView.this.showBitmapRectF);
                LikeQQCropView.this.invalidate();
            }
        });
    }

    public void verticalFlip() {
        this.post(new Runnable(){

            @Override
            public void run() {
                LikeQQCropView.this.showBitmapMatrix.postScale(1.0f, -1.0f, LikeQQCropView.this.centerX, LikeQQCropView.this.centerY);
                LikeQQCropView.this.showBitmapRectF = new RectF(0.0f, 0.0f, (float)LikeQQCropView.this.showBitmap.getWidth(), (float)LikeQQCropView.this.showBitmap.getHeight());
                LikeQQCropView.this.showBitmapMatrix.mapRect(LikeQQCropView.this.showBitmapRectF);
                LikeQQCropView.this.invalidate();
            }
        });
    }

    public void verticalAndHorizontalFlip() {
        this.post(new Runnable(){

            @Override
            public void run() {
                LikeQQCropView.this.showBitmapMatrix.postScale(-1.0f, -1.0f, LikeQQCropView.this.centerX, LikeQQCropView.this.centerY);
                LikeQQCropView.this.showBitmapRectF = new RectF(0.0f, 0.0f, (float)LikeQQCropView.this.showBitmap.getWidth(), (float)LikeQQCropView.this.showBitmap.getHeight());
                LikeQQCropView.this.showBitmapMatrix.mapRect(LikeQQCropView.this.showBitmapRectF);
                LikeQQCropView.this.invalidate();
            }
        });
    }

    public void reset() {
        if (this.sizeChanged) {
            this.init();
            this.invalidate();
        } else {
            this.post(new Runnable(){

                @Override
                public void run() {
                    LikeQQCropView.this.init();
                    LikeQQCropView.this.invalidate();
                }
            });
        }
    }

    private float getPathInterval() {
        return this.dip2px(this.getContext(), 0.5f);
    }

    private RectF getCircleRectFByBitmapRectF(RectF showBitmapRectF) {
        float rectFW = showBitmapRectF.right - showBitmapRectF.left;
        float rectFH = showBitmapRectF.bottom - showBitmapRectF.top;
        float circleRectFLength = rectFW > rectFH ? rectFH : rectFW;
        float circleRectFLeft = this.centerX - circleRectFLength / 2.0f;
        float circleRectFTop = this.centerY - circleRectFLength / 2.0f;
        return new RectF(circleRectFLeft, circleRectFTop, circleRectFLength + circleRectFLeft, circleRectFLength + circleRectFTop);
    }

    private float getRectLength(RectF rectF) {
        return Math.abs(rectF.right - rectF.left);
    }

    private RectF getBigCircleRectF(RectF circleRectF) {
        RectF rectF = new RectF();
        rectF.set(circleRectF);
        rectF.left -= (float)this.getTouchAreaWidth();
        rectF.top -= (float)this.getTouchAreaWidth();
        rectF.right += (float)this.getTouchAreaWidth();
        rectF.bottom += (float)this.getTouchAreaWidth();
        return rectF;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.showBitmap == null) {
            return;
        }
        canvas.drawBitmap(this.showBitmap, this.showBitmapMatrix, null);
        canvas.drawPath(this.outsidePath, this.bgPaint);
        canvas.drawPath(this.circleBorderPath, this.circleBorderPaint);
    }

    private int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    private int getTouchAreaWidth() {
        return this.dip2px(this.getContext(), 10.0f);
    }

    private float getCurrentScale() {
        float[] temp = new float[9];
        this.showBitmapMatrix.getValues(temp);
        return Math.abs(temp[0]);
    }

    private void initGesture() {
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                if (LikeQQCropView.this.canZoomCircle) {
                    float distance = Math.abs(distanceX) > Math.abs(distanceY) ? distanceX : distanceY;
                    float rectHeight = ((LikeQQCropView)LikeQQCropView.this).circleRectF.bottom - ((LikeQQCropView)LikeQQCropView.this).circleRectF.top;
                    float scaleFactory = (-distance * 2.0f + rectHeight) / rectHeight;
                    LikeQQCropView.this.showBitmapMatrix.postScale(scaleFactory, scaleFactory, LikeQQCropView.this.centerX, LikeQQCropView.this.centerY);
                    LikeQQCropView.this.showBitmapRectF = new RectF(0.0f, 0.0f, (float)LikeQQCropView.this.showBitmap.getWidth(), (float)LikeQQCropView.this.showBitmap.getHeight());
                    LikeQQCropView.this.showBitmapMatrix.mapRect(LikeQQCropView.this.showBitmapRectF);
                    LikeQQCropView.this.circleRectF = new RectF();
                    LikeQQCropView.this.circleRectF.set(LikeQQCropView.this.getCircleRectFByBitmapRectF(LikeQQCropView.this.showBitmapRectF));
                    LikeQQCropView.this.bigCircleRectF = LikeQQCropView.this.getBigCircleRectF(LikeQQCropView.this.circleRectF);
                    LikeQQCropView.this.refreshPath();
                    LikeQQCropView.this.invalidate();
                }
                if (LikeQQCropView.this.canMoveBitmap && !LikeQQCropView.this.canZoomCircle) {
                    float rectDistance;
                    if (distanceX < 0.0f && (rectDistance = ((LikeQQCropView)LikeQQCropView.this).circleRectF.left - ((LikeQQCropView)LikeQQCropView.this).showBitmapRectF.left) < Math.abs(distanceX)) {
                        distanceX = -rectDistance;
                    }
                    if (distanceX > 0.0f && (rectDistance = ((LikeQQCropView)LikeQQCropView.this).showBitmapRectF.right - ((LikeQQCropView)LikeQQCropView.this).circleRectF.right) < Math.abs(distanceX)) {
                        distanceX = rectDistance;
                    }
                    if (distanceY < 0.0f && (rectDistance = ((LikeQQCropView)LikeQQCropView.this).circleRectF.top - ((LikeQQCropView)LikeQQCropView.this).showBitmapRectF.top) < Math.abs(distanceY)) {
                        distanceY = -rectDistance;
                    }
                    if (distanceY > 0.0f && (rectDistance = ((LikeQQCropView)LikeQQCropView.this).showBitmapRectF.bottom - ((LikeQQCropView)LikeQQCropView.this).circleRectF.bottom) < Math.abs(distanceY)) {
                        distanceY = rectDistance;
                    }
                    LikeQQCropView.this.showBitmapRectF = new RectF(0.0f, 0.0f, (float)LikeQQCropView.this.showBitmap.getWidth(), (float)LikeQQCropView.this.showBitmap.getHeight());
                    LikeQQCropView.this.showBitmapMatrix.postTranslate(-distanceX, -distanceY);
                    LikeQQCropView.this.showBitmapMatrix.mapRect(LikeQQCropView.this.showBitmapRectF);
                    LikeQQCropView.this.invalidate();
                }
                return true;
            }

            public boolean onDoubleTapEvent(MotionEvent e) {
                switch (e.getAction()) {
                    case 1: {
                        if (!LikeQQCropView.this.showBitmapRectF.contains(e.getX(), e.getY())) break;
                        if (LikeQQCropView.this.getCurrentScale() > LikeQQCropView.this.initScale) {
                            final SparseArray sparseArray = new SparseArray();
                            sparseArray.put(0, (Object)Float.valueOf(-1.0f));
                            sparseArray.put(1, (Object)Float.valueOf(-1.0f));
                            LikeQQCropView.this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{LikeQQCropView.this.getCurrentScale(), LikeQQCropView.this.initScale});
                            LikeQQCropView.this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                                public void onAnimationUpdate(ValueAnimator animation) {
                                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                                    float tempScale = 1.0f;
                                    if (((Float)sparseArray.get(0)).floatValue() == -1.0f && ((Float)sparseArray.get(1)).floatValue() == -1.0f) {
                                        sparseArray.put(0, (Object)Float.valueOf(value));
                                    } else if (((Float)sparseArray.get(1)).floatValue() == -1.0f) {
                                        sparseArray.put(1, (Object)Float.valueOf(value));
                                        tempScale = ((Float)sparseArray.get(1)).floatValue() / ((Float)sparseArray.get(0)).floatValue();
                                    } else {
                                        sparseArray.put(0, sparseArray.get(1));
                                        sparseArray.put(1, (Object)Float.valueOf(value));
                                        tempScale = ((Float)sparseArray.get(1)).floatValue() / ((Float)sparseArray.get(0)).floatValue();
                                    }
                                    LikeQQCropView.this.zoomBitmap(tempScale, LikeQQCropView.this.centerX, LikeQQCropView.this.centerX);
                                    LikeQQCropView.this.invalidate();
                                }
                            });
                            LikeQQCropView.this.valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                            LikeQQCropView.this.valueAnimator.setDuration(300L);
                            LikeQQCropView.this.valueAnimator.start();
                            break;
                        }
                        LikeQQCropView.this.doubleClickX = e.getX();
                        LikeQQCropView.this.doubleClickY = e.getY();
                        final SparseArray sparseArray = new SparseArray();
                        sparseArray.put(0, (Object)Float.valueOf(-1.0f));
                        sparseArray.put(1, (Object)Float.valueOf(-1.0f));
                        LikeQQCropView.this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{LikeQQCropView.this.getCurrentScale(), LikeQQCropView.this.doubleClickScale});
                        LikeQQCropView.this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                float value = ((Float)animation.getAnimatedValue()).floatValue();
                                float tempScale = 1.0f;
                                if (((Float)sparseArray.get(0)).floatValue() == -1.0f && ((Float)sparseArray.get(1)).floatValue() == -1.0f) {
                                    sparseArray.put(0, (Object)Float.valueOf(value));
                                } else if (((Float)sparseArray.get(1)).floatValue() == -1.0f) {
                                    sparseArray.put(1, (Object)Float.valueOf(value));
                                    tempScale = ((Float)sparseArray.get(1)).floatValue() / ((Float)sparseArray.get(0)).floatValue();
                                } else {
                                    sparseArray.put(0, sparseArray.get(1));
                                    sparseArray.put(1, (Object)Float.valueOf(value));
                                    tempScale = ((Float)sparseArray.get(1)).floatValue() / ((Float)sparseArray.get(0)).floatValue();
                                }
                                LikeQQCropView.this.showBitmapMatrix.postScale(tempScale, tempScale, LikeQQCropView.this.doubleClickX, LikeQQCropView.this.doubleClickY);
                                LikeQQCropView.this.showBitmapRectF = new RectF(0.0f, 0.0f, (float)LikeQQCropView.this.showBitmap.getWidth(), (float)LikeQQCropView.this.showBitmap.getHeight());
                                LikeQQCropView.this.showBitmapMatrix.mapRect(LikeQQCropView.this.showBitmapRectF);
                                LikeQQCropView.this.invalidate();
                            }
                        });
                        LikeQQCropView.this.valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                        LikeQQCropView.this.valueAnimator.setDuration(300L);
                        LikeQQCropView.this.valueAnimator.start();
                    }
                }
                return super.onDoubleTapEvent(e);
            }
        });
        this.scaleGestureDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureDetector.SimpleOnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector detector) {
                float scaleFactor;
                float currentScale = LikeQQCropView.this.getCurrentScale();
                if (currentScale * (scaleFactor = detector.getScaleFactor()) < LikeQQCropView.this.initScale) {
                    scaleFactor = LikeQQCropView.this.initScale / currentScale;
                }
                LikeQQCropView.this.zoomBitmap(scaleFactor, detector.getFocusX(), detector.getFocusY());
                LikeQQCropView.this.invalidate();
                return true;
            }

            public boolean onScaleBegin(ScaleGestureDetector detector) {
                return LikeQQCropView.this.showBitmapRectF.contains(detector.getFocusX(), detector.getFocusY());
            }
        });
    }

    private void zoomBitmap(float scaleFactor, float focusX, float focusY) {
        if (scaleFactor > 1.0f && this.getCurrentScale() * scaleFactor > this.maxScale) {
            scaleFactor = this.maxScale / this.getCurrentScale();
        }
        this.showBitmapMatrix.postScale(scaleFactor, scaleFactor, focusX, focusY);
        this.showBitmapRectF = new RectF(0.0f, 0.0f, (float)this.showBitmap.getWidth(), (float)this.showBitmap.getHeight());
        this.showBitmapMatrix.mapRect(this.showBitmapRectF);
        if (scaleFactor < 1.0f) {
            float bottomLength;
            float rightLength;
            float topLength;
            float leftLength = this.showBitmapRectF.left - this.circleRectF.left;
            if (leftLength > 0.0f) {
                this.showBitmapMatrix.postTranslate(-leftLength, 0.0f);
            }
            if ((topLength = this.showBitmapRectF.top - this.circleRectF.top) > 0.0f) {
                this.showBitmapMatrix.postTranslate(0.0f, -topLength);
            }
            if ((rightLength = this.circleRectF.right - this.showBitmapRectF.right) > 0.0f) {
                this.showBitmapMatrix.postTranslate(rightLength, 0.0f);
            }
            if ((bottomLength = this.circleRectF.bottom - this.showBitmapRectF.bottom) > 0.0f) {
                this.showBitmapMatrix.postTranslate(0.0f, bottomLength);
            }
            this.showBitmapRectF = new RectF(0.0f, 0.0f, (float)this.showBitmap.getWidth(), (float)this.showBitmap.getHeight());
            this.showBitmapMatrix.mapRect(this.showBitmapRectF);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.scaleGestureDetector.onTouchEvent(event);
        this.gestureDetector.onTouchEvent(event);
        switch (event.getAction()) {
            case 0: {
                if (!this.showBitmapRectF.contains(event.getX(), event.getY())) break;
                this.canMoveBitmap = true;
                break;
            }
            case 1: {
                this.canMoveBitmap = false;
                this.canZoomCircle = false;
            }
        }
        return true;
    }

    private void resetBitmap() {
        this.reset();
    }

    public Bitmap getBitmap() {
        return this.showBitmap;
    }

    @Deprecated
    public LikeQQCropView setBitmap(Bitmap bitmap) {
        this.showBitmap = bitmap;
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmap(int resId, int reqWidth, int reqHeight) {
        this.showBitmap = CropViewUtils.compressBitmap(this.getContext(), resId, reqWidth, reqHeight);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmap(String pathName, int reqWidth, int reqHeight) {
        this.showBitmap = CropViewUtils.compressBitmap(pathName, reqWidth, reqHeight);
        this.resetBitmap();
        return this;
    }

    @Deprecated
    public LikeQQCropView setBitmapToRotate(String pathName, int reqWidth, int reqHeight) {
        this.showBitmap = CropViewUtils.compressBitmap(pathName, reqWidth, reqHeight);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmap(byte[] data, int offset, int length, int reqWidth, int reqHeight) {
        this.showBitmap = CropViewUtils.compressBitmap(data, offset, length, reqWidth, reqHeight);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmap(FileDescriptor fd, Rect outPadding, int reqWidth, int reqHeight) {
        this.showBitmap = CropViewUtils.compressBitmap(fd, outPadding, reqWidth, reqHeight);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmap(Resources res, TypedValue value, InputStream is, Rect pad, int reqWidth, int reqHeight) {
        this.showBitmap = CropViewUtils.compressBitmap(res, value, is, pad, reqWidth, reqHeight);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmap(InputStream is, Rect outPadding, int reqWidth, int reqHeight) {
        this.showBitmap = CropViewUtils.compressBitmap(is, outPadding, reqWidth, reqHeight);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForHeight(int resId, int reqHeight) {
        this.showBitmap = CropViewUtils.compressBitmapForHeight(this.getContext(), resId, reqHeight);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForHeight(String pathName, int reqHeight) {
        this.showBitmap = CropViewUtils.compressBitmapForHeight(pathName, reqHeight);
        this.resetBitmap();
        return this;
    }

    @Deprecated
    public LikeQQCropView setBitmapForHeightToRotate(String pathName, int reqHeight) {
        this.showBitmap = CropViewUtils.compressBitmapForHeight(pathName, reqHeight);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForHeight(byte[] data, int offset, int length, int reqHeight) {
        this.showBitmap = CropViewUtils.compressBitmapForHeight(data, offset, length, reqHeight);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForHeight(FileDescriptor fd, Rect outPadding, int reqHeight) {
        this.showBitmap = CropViewUtils.compressBitmapForHeight(fd, outPadding, reqHeight);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForHeight(Resources res, TypedValue value, InputStream is, Rect pad, int reqHeight) {
        this.showBitmap = CropViewUtils.compressBitmapForHeight(res, value, is, pad, reqHeight);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForHeight(InputStream is, Rect outPadding, int reqHeight) {
        this.showBitmap = CropViewUtils.compressBitmapForHeight(is, outPadding, reqHeight);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForWidth(int resId, int reqWidth) {
        this.showBitmap = CropViewUtils.compressBitmapForWidth(this.getContext(), resId, reqWidth);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForWidth(String pathName, int reqWidth) {
        this.showBitmap = CropViewUtils.compressBitmapForWidth(pathName, reqWidth);
        this.resetBitmap();
        return this;
    }

    @Deprecated
    public LikeQQCropView setBitmapForWidthToRotate(String pathName, int reqWidth) {
        this.showBitmap = CropViewUtils.compressBitmapForWidth(pathName, reqWidth);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForWidth(byte[] data, int offset, int length, int reqWidth) {
        this.showBitmap = CropViewUtils.compressBitmapForWidth(data, offset, length, reqWidth);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForWidth(FileDescriptor fd, Rect outPadding, int reqWidth) {
        this.showBitmap = CropViewUtils.compressBitmapForWidth(fd, outPadding, reqWidth);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForWidth(Resources res, TypedValue value, InputStream is, Rect pad, int reqWidth) {
        this.showBitmap = CropViewUtils.compressBitmapForWidth(res, value, is, pad, reqWidth);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForWidth(InputStream is, Rect outPadding, int reqWidth) {
        this.showBitmap = CropViewUtils.compressBitmapForWidth(is, outPadding, reqWidth);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForScale(int resId, int scaleSize) {
        this.showBitmap = CropViewUtils.compressBitmapForScale(this.getContext(), resId, scaleSize);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForScale(String pathName, int scaleSize) {
        this.showBitmap = CropViewUtils.compressBitmapForScale(pathName, scaleSize);
        this.resetBitmap();
        return this;
    }

    @Deprecated
    public LikeQQCropView setBitmapForScaleToRotate(String pathName, int scaleSize) {
        this.showBitmap = CropViewUtils.compressBitmapForScale(pathName, scaleSize);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForScale(byte[] data, int offset, int length, int scaleSize) {
        this.showBitmap = CropViewUtils.compressBitmapForScale(data, offset, length, scaleSize);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForScale(FileDescriptor fd, Rect outPadding, int scaleSize) {
        this.showBitmap = CropViewUtils.compressBitmapForScale(fd, outPadding, scaleSize);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForScale(Resources res, TypedValue value, InputStream is, Rect pad, int scaleSize) {
        this.showBitmap = CropViewUtils.compressBitmapForScale(res, value, is, pad, scaleSize);
        this.resetBitmap();
        return this;
    }

    public LikeQQCropView setBitmapForScale(InputStream is, Rect outPadding, int scaleSize) {
        this.showBitmap = CropViewUtils.compressBitmapForScale(is, outPadding, scaleSize);
        this.resetBitmap();
        return this;
    }

    public Bitmap rotateBitmap(int angle, Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }
}

