/*
 * Decompiled with CFR 0.152.
 */
package com.github.cropbitmap;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.Log;

public class LikeXMCropViewUtils {
    public float needMoveX;
    public float needMoveY;
    public float initScale = 1.0f;
    public float borderDistance;
    public int centerX;
    public int centerY;
    public Bitmap showBitmap;
    public Matrix showBitmapMatrix;
    public RectF showBitmapRect;
    private RectF initialShowBitmapRect;
    public Paint cropPaint;
    public Path cropPath;
    public RectF cropRect;
    public Matrix cropMatrix;
    public int cropColor;
    public float cropWidth = 2.0f;
    public float widthRatio = 0.0f;
    public float heightRatio = 0.0f;
    public Paint maskLayerPaint;
    public Path maskLayerPath;
    public Matrix maskMatrix;
    public int maskLayerColor;
    public Paint borderAnglePaint;
    public Path borderAnglePath;
    public Paint borderTouchPaint;
    public Paint linePaint;
    public Path linePath;
    public float viewWidth;
    public float viewHeight;
    public float touchWidth = 30.0f;
    public RectF leftBorderTouchRect;
    public RectF topBorderTouchRect;
    public RectF rightBorderTouchRect;
    public RectF bottomBorderTouchRect;
    public RectF leftTopTouchRect;
    public RectF rightTopTouchRect;
    public RectF leftBottomTouchRect;
    public RectF rightBottomTouchRect;
    public float touchOffsetX;
    public float touchOffsetY;
    public float maxScale = 8.0f;

    public void prepare() {
        this.showBitmapMatrix = new Matrix();
        this.showBitmapRect = new RectF();
        this.cropMatrix = new Matrix();
        this.cropPaint = new Paint(1);
        this.cropPaint.setColor(-16776961);
        this.cropPaint.setStrokeWidth(2.0f);
        this.cropPaint.setStyle(Paint.Style.STROKE);
        this.cropRect = new RectF();
        this.cropPath = new Path();
        this.maskMatrix = new Matrix();
        this.maskLayerPaint = new Paint(1);
        this.maskLayerPaint.setColor(Color.parseColor((String)"#30000000"));
        this.maskLayerPaint.setStyle(Paint.Style.FILL);
        this.maskLayerPath = new Path();
        this.borderAnglePaint = new Paint(1);
        this.borderAnglePath = new Path();
        this.borderTouchPaint = new Paint(1);
        this.linePaint = new Paint(1);
        this.linePath = new Path();
        int width = this.showBitmap.getWidth();
        int height = this.showBitmap.getHeight();
        this.leftBorderTouchRect = new RectF();
        this.topBorderTouchRect = new RectF();
        this.rightBorderTouchRect = new RectF();
        this.bottomBorderTouchRect = new RectF();
        this.leftTopTouchRect = new RectF();
        this.rightTopTouchRect = new RectF();
        this.leftBottomTouchRect = new RectF();
        this.rightBottomTouchRect = new RectF();
        this.initRect();
        this.initPath();
        this.refreshTouchBorder(this.cropRect);
    }

    public RectF getBitmapRect() {
        if (this.showBitmapRect != null) {
            this.showBitmapRect.setEmpty();
        } else {
            this.showBitmapRect = new RectF();
        }
        this.showBitmapRect.set(0.0f, 0.0f, (float)this.showBitmap.getWidth(), (float)this.showBitmap.getHeight());
        this.showBitmapMatrix.mapRect(this.showBitmapRect);
        return this.showBitmapRect;
    }

    public void refreshTouchBorder(RectF cropRect) {
        this.leftBorderTouchRect.set(cropRect.left, cropRect.top + this.touchWidth, cropRect.left + this.touchWidth, cropRect.bottom - this.touchWidth);
        this.topBorderTouchRect.set(cropRect.left + this.touchWidth, cropRect.top, cropRect.right - this.touchWidth, cropRect.top + this.touchWidth);
        this.rightBorderTouchRect.set(cropRect.right - this.touchWidth, cropRect.top + this.touchWidth, cropRect.right, cropRect.bottom - this.touchWidth);
        this.bottomBorderTouchRect.set(cropRect.left + this.touchWidth, cropRect.bottom - this.touchWidth, cropRect.right - this.touchWidth, cropRect.bottom);
        this.leftTopTouchRect.set(cropRect.left, cropRect.top, cropRect.left + this.touchWidth, cropRect.top + this.touchWidth);
        this.rightTopTouchRect.set(cropRect.right - this.touchWidth, cropRect.top, cropRect.right, cropRect.top + this.touchWidth);
        this.leftBottomTouchRect.set(cropRect.left, cropRect.bottom - this.touchWidth, cropRect.left + this.touchWidth, cropRect.bottom);
        this.rightBottomTouchRect.set(cropRect.right - this.touchWidth, cropRect.bottom - this.touchWidth, cropRect.right, cropRect.bottom);
    }

    private void Log(String str) {
        Log.i((String)"===", (String)("@@===" + str));
    }

    public void initRect() {
        this.cropRect.set(this.needMoveX, this.needMoveY, this.viewWidth - 1.0f * this.needMoveX, this.viewHeight - 1.0f * this.needMoveY);
        if (this.widthRatio > 0.0f && this.heightRatio > 0.0f) {
            float cropWidth = this.cropRect.right - this.cropRect.left;
            float cropHeight = this.cropRect.bottom - this.cropRect.top;
            if (this.widthRatio * 1.0f / this.heightRatio > cropWidth * 1.0f / cropHeight) {
                float newHeight = cropWidth * this.heightRatio / this.widthRatio;
                float temp = (cropHeight - newHeight) * 1.0f / 2.0f;
                this.cropRect.set(this.needMoveX, this.needMoveY + temp, this.viewWidth - 1.0f * this.needMoveX, this.viewHeight - 1.0f * this.needMoveY - temp);
            } else {
                float newWidth = cropHeight * this.widthRatio / this.heightRatio;
                float temp = (cropWidth - newWidth) * 1.0f / 2.0f;
                this.cropRect.set(this.needMoveX + temp, this.needMoveY, this.viewWidth - 1.0f * this.needMoveX - temp, this.viewHeight - 1.0f * this.needMoveY);
            }
        }
        this.Log(this.cropRect.toString());
    }

    public void initPath() {
        if (!this.cropPath.isEmpty()) {
            this.cropPath.reset();
        }
        this.cropPath.addRect(this.cropRect, Path.Direction.CW);
        if (!this.maskLayerPath.isEmpty()) {
            this.maskLayerPath.reset();
        }
        this.maskLayerPath.addRect(new RectF(0.0f, 0.0f, this.viewWidth, this.viewHeight), Path.Direction.CW);
        this.maskLayerPath.op(this.cropPath, Path.Op.XOR);
    }

    public void refreshCropPath() {
        if (!this.cropPath.isEmpty()) {
            this.cropPath.reset();
        }
        this.cropPath.addRect(this.cropRect, Path.Direction.CW);
        if (!this.maskLayerPath.isEmpty()) {
            this.maskLayerPath.reset();
        }
        this.maskLayerPath.addRect(new RectF(0.0f, 0.0f, this.viewWidth, this.viewHeight), Path.Direction.CW);
        this.maskLayerPath.op(this.cropPath, Path.Op.XOR);
    }

    private void refreshPaint() {
    }

    public void refreshShowBitmapRect() {
        this.showBitmapRect.set(0.0f, 0.0f, (float)this.showBitmap.getWidth(), (float)this.showBitmap.getHeight());
        this.showBitmapMatrix.mapRect(this.showBitmapRect);
    }

    public float getMinCropWidth() {
        RectF rectF = new RectF(0.0f, 0.0f, (float)this.showBitmap.getWidth(), (float)this.showBitmap.getHeight());
        this.showBitmapMatrix.mapRect(rectF);
        float length = (float)this.showBitmap.getWidth() * 1.0f / (float)this.showBitmap.getHeight() > this.viewWidth * 1.0f / this.viewHeight ? (rectF.bottom - rectF.top) / this.maxScale : (rectF.right - rectF.left) / this.maxScale;
        return length;
    }
}

