/*
 * Decompiled with CFR 0.152.
 */
package com.github.banner;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.github.banner.BannerHolder;
import com.github.banner.BannerItem;
import com.github.banner.BannerItemManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class MyBannerAdapter<T>
extends RecyclerView.Adapter<BannerHolder> {
    private long click_interval = 800L;
    private long lastClickTime;
    private List<T> list = new ArrayList<T>();
    private BannerItemManager<T> bannerItemManager = new BannerItemManager();

    public void setList(List<T> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        this.list = list;
    }

    public void addBannerItem(BannerItem item) {
        this.bannerItemManager.addBannerItem(item);
    }

    public boolean hasMultiItem() {
        return this.bannerItemManager.hasMultiItem();
    }

    public BannerHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        final BannerItem bannerItem = this.bannerItemManager.getBannerItem(viewType);
        final BannerHolder holder = new BannerHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(bannerItem.getItemLayoutId(), viewGroup, false));
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                long currentTime = Calendar.getInstance().getTimeInMillis();
                if (currentTime - MyBannerAdapter.this.lastClickTime >= MyBannerAdapter.this.click_interval) {
                    MyBannerAdapter.this.lastClickTime = currentTime;
                    int adapterPosition = holder.getAdapterPosition();
                    bannerItem.onItemClick(MyBannerAdapter.this.getItem(adapterPosition), MyBannerAdapter.this.getRealDataPosition(adapterPosition), MyBannerAdapter.this.getRealCount());
                }
            }
        });
        return holder;
    }

    public void onBindViewHolder(@NonNull BannerHolder holder, int position) {
        this.bannerItemManager.bindData(holder, this.getItem(position), this.getRealDataPosition(position), this.getRealCount());
    }

    public int getItemViewType(int position) {
        return this.bannerItemManager.getItemViewType(this.getItem(position), this.getRealDataPosition(position), this.getRealCount());
    }

    public int getItemCount() {
        if (this.getRealCount() == 0) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    public int getRealCount() {
        return this.list == null ? 0 : this.list.size();
    }

    public int getRealDataPosition(int position) {
        if (this.getRealCount() == 0) {
            return 0;
        }
        return position % this.getRealCount();
    }

    public T getItem(int position) {
        if (this.list == null) {
            return null;
        }
        return this.list.get(this.getRealDataPosition(position));
    }
}

