/*
 * Decompiled with CFR 0.152.
 */
package com.github.banner;

import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

public class BannerHolder
extends RecyclerView.ViewHolder {
    private SparseArray<View> viewSparseArray = new SparseArray();

    public BannerHolder(@NonNull View itemView) {
        super(itemView);
    }

    public <T extends View> T getView(int resId) {
        View view = (View)this.viewSparseArray.get(resId);
        if (view == null) {
            view = this.itemView.findViewById(resId);
            this.viewSparseArray.put(resId, (Object)view);
        }
        return (T)view;
    }

    public BannerHolder setText(int viewId, String value) {
        TextView view = (TextView)this.getView(viewId);
        view.setText((CharSequence)value);
        return this;
    }

    public BannerHolder setText(int viewId, CharSequence value) {
        TextView view = (TextView)this.getView(viewId);
        view.setText(value);
        return this;
    }

    public BannerHolder setText(int viewId, CharSequence value, TextView.BufferType bufferType) {
        TextView view = (TextView)this.getView(viewId);
        view.setText(value, bufferType);
        return this;
    }

    public BannerHolder setText(int viewId, @StringRes int value) {
        TextView view = (TextView)this.getView(viewId);
        view.setText(value);
        return this;
    }

    public BannerHolder setText(int viewId, @StringRes int value, TextView.BufferType bufferType) {
        TextView view = (TextView)this.getView(viewId);
        view.setText(value, bufferType);
        return this;
    }

    public BannerHolder setText(int viewId, char[] value, int start, int len) {
        TextView view = (TextView)this.getView(viewId);
        view.setText(value, start, len);
        return this;
    }

    public ImageView getImageView(int viewId) {
        return (ImageView)this.getView(viewId);
    }
}

