/*
 * Decompiled with CFR 0.152.
 */
package com.github.banner;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v7.widget.PagerSnapHelper;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.github.banner.BannerItem;
import com.github.banner.BannerRecyclerView;
import com.github.banner.LayoutManager;
import com.github.banner.MyBannerAdapter;
import com.github.banner.R;
import com.github.banner.listener.OnPagerListener;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class MyBannerView
extends RelativeLayout {
    private OnPagerListener pagerListener;
    private LayoutManager layoutManager;
    private int direction = 0;
    private int timeInterval = 6000;
    private int timeScroll = 600;
    private boolean autoPlay = true;
    private boolean reverse = false;
    private boolean useGesture = true;
    private boolean indicatorHidden = false;
    private int indicatorDistance;
    public Drawable indicatorSelectDrawable;
    public Drawable indicatorUnSelectDrawable;
    private int indicatorSelectDrawableColor = -1;
    private int indicatorUnSelectDrawableColor = -1;
    private int indicatorDrawableWidth = -1;
    private int indicatorDrawableHeight = -1;
    private int indicatorDrawableRadius;
    private List<ImageView> indicatorList = new ArrayList<ImageView>();
    private ImageView preImageView;
    private Drawable selectDrawable;
    private Drawable unSelectDrawable;
    private LinearLayout indicatorParent;
    private BannerRecyclerView recyclerView;
    private MyBannerAdapter adapter;
    private List list = new ArrayList();
    private int beforeItemPosition;
    private Handler handler;
    private final int playBanner = 1000;
    private Runnable runnable;
    private Message message;

    public MyBannerView(Context context) {
        super(context);
        this.init(null);
    }

    public MyBannerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public MyBannerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.MyBannerView);
        this.direction = typedArray.getInt(R.styleable.MyBannerView_direction, 0);
        this.timeScroll = typedArray.getInt(R.styleable.MyBannerView_timeScroll, this.timeScroll);
        this.timeInterval = typedArray.getInt(R.styleable.MyBannerView_timeInterval, this.timeInterval);
        this.timeInterval += this.timeScroll;
        this.autoPlay = typedArray.getBoolean(R.styleable.MyBannerView_autoPlay, true);
        this.reverse = typedArray.getBoolean(R.styleable.MyBannerView_reverse, false);
        this.useGesture = typedArray.getBoolean(R.styleable.MyBannerView_useGesture, true);
        this.indicatorHidden = typedArray.getBoolean(R.styleable.MyBannerView_indicatorHidden, false);
        this.indicatorDistance = (int)typedArray.getDimension(R.styleable.MyBannerView_indicatorDistance, (float)this.dp2Px(6.0f));
        this.indicatorSelectDrawable = typedArray.getDrawable(R.styleable.MyBannerView_indicatorSelectDrawable);
        this.indicatorUnSelectDrawable = typedArray.getDrawable(R.styleable.MyBannerView_indicatorUnSelectDrawable);
        this.indicatorSelectDrawableColor = typedArray.getColor(R.styleable.MyBannerView_indicatorSelectDrawableColor, -1);
        this.indicatorUnSelectDrawableColor = typedArray.getColor(R.styleable.MyBannerView_indicatorUnSelectDrawableColor, -1);
        this.indicatorDrawableWidth = (int)typedArray.getDimension(R.styleable.MyBannerView_indicatorDrawableWidth, -1.0f);
        this.indicatorDrawableHeight = (int)typedArray.getDimension(R.styleable.MyBannerView_indicatorDrawableHeight, -1.0f);
        this.indicatorDrawableRadius = (int)typedArray.getDimension(R.styleable.MyBannerView_indicatorDrawableRadius, 0.0f);
        typedArray.recycle();
        this.runnable = new Runnable(){

            @Override
            public void run() {
                MyBannerView.this.bannerRunnable();
            }
        };
        this.handler = new Handler(Looper.myLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                switch (msg.what) {
                    case 1000: {
                        MyBannerView.this.handler.post(MyBannerView.this.runnable);
                        MyBannerView.this.message = MyBannerView.this.handler.obtainMessage();
                        ((MyBannerView)MyBannerView.this).message.what = 1000;
                        MyBannerView.this.handler.sendMessageDelayed(MyBannerView.this.message, (long)MyBannerView.this.timeInterval);
                    }
                }
            }
        };
        this.adapter = new MyBannerAdapter();
        this.recyclerView = new BannerRecyclerView(this.getContext());
        this.recyclerView.setUseGesture(this.useGesture);
        this.recyclerView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.addView((View)this.recyclerView);
    }

    public List getList() {
        return this.list;
    }

    public void setList(List list) {
        if (list == null || list.size() == 0) {
            return;
        }
        this.list = list;
    }

    public void start() {
        this.post(new Runnable(){

            @Override
            public void run() {
                MyBannerView.this.beforeItemPosition = 0;
                MyBannerView.this.initIndicator();
                MyBannerView.this.startPlay();
            }
        });
    }

    private void initIndicator() {
        if (this.indicatorParent != null) {
            this.indicatorParent.removeAllViews();
        }
        this.indicatorList.clear();
        if (this.indicatorHidden) {
            return;
        }
        int childCount = this.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            LinearLayout indicatorViewGroup;
            View childAt = this.getChildAt(i);
            if (!(childAt instanceof LinearLayout)) continue;
            if (this.indicatorParent == null) {
                this.indicatorParent = (LinearLayout)childAt;
                this.indicatorParent.setTag(R.id.indicatorId, (Object)"banner");
            }
            if ((indicatorViewGroup = (LinearLayout)childAt).getTag(R.id.indicatorId) == null) continue;
            this.indicatorParent = indicatorViewGroup;
            break;
        }
        if (this.indicatorParent == null) {
            this.indicatorParent = new LinearLayout(this.getContext());
            this.indicatorParent.setTag(R.id.indicatorId, (Object)"banner");
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.bottomMargin = this.dp2Px(6.0f);
            layoutParams.addRule(14);
            layoutParams.addRule(12);
            this.indicatorParent.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.addView((View)this.indicatorParent);
        }
        this.addIndicatorToView(this.indicatorParent);
    }

    private void addIndicatorToView(LinearLayout linearLayout) {
        if (this.indicatorSelectDrawable != null) {
            if (this.indicatorSelectDrawableColor != -1) {
                this.indicatorSelectDrawable.mutate().setColorFilter(this.indicatorSelectDrawableColor, PorterDuff.Mode.SRC_ATOP);
            }
            this.selectDrawable = this.indicatorSelectDrawable;
        } else {
            if (this.indicatorSelectDrawableColor == -1) {
                this.indicatorSelectDrawableColor = -7829368;
            }
            this.selectDrawable = this.indicatorDrawableWidth > 0 && this.indicatorDrawableHeight > 0 ? this.createDrawable(this.indicatorDrawableWidth, this.indicatorDrawableHeight, this.indicatorDrawableRadius, this.indicatorSelectDrawableColor) : this.createDrawable(this.dp2Px(6.0f), this.dp2Px(6.0f), this.dp2Px(3.0f), this.indicatorSelectDrawableColor);
        }
        if (this.indicatorUnSelectDrawable != null) {
            if (this.indicatorUnSelectDrawableColor != -1) {
                this.indicatorUnSelectDrawable.mutate().setColorFilter(this.indicatorUnSelectDrawableColor, PorterDuff.Mode.SRC_ATOP);
            }
            this.unSelectDrawable = this.indicatorUnSelectDrawable;
        } else {
            if (this.indicatorUnSelectDrawableColor == -1) {
                this.indicatorUnSelectDrawableColor = -1;
            }
            this.unSelectDrawable = this.indicatorDrawableWidth > 0 && this.indicatorDrawableHeight > 0 ? this.createDrawable(this.indicatorDrawableWidth, this.indicatorDrawableHeight, this.indicatorDrawableRadius, this.indicatorUnSelectDrawableColor) : this.createDrawable(this.dp2Px(6.0f), this.dp2Px(6.0f), this.dp2Px(3.0f), this.indicatorUnSelectDrawableColor);
        }
        int size = this.list == null ? 0 : this.list.size();
        for (int i = 0; i < size; ++i) {
            ImageView imageView = new ImageView(this.getContext());
            if (i == 0) {
                imageView.setImageDrawable(this.selectDrawable);
            } else {
                imageView.setImageDrawable(this.unSelectDrawable);
            }
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
            if (this.indicatorDrawableWidth > 0 && this.indicatorDrawableHeight > 0) {
                layoutParams = new LinearLayout.LayoutParams(this.indicatorDrawableWidth, this.indicatorDrawableHeight);
            }
            int mg = this.indicatorDistance / 2;
            layoutParams.setMargins(mg, mg, mg, mg);
            imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.indicatorList.add(imageView);
            linearLayout.addView((View)imageView);
        }
    }

    private void startPlay() {
        if (!this.adapter.hasMultiItem()) {
            return;
        }
        this.adapter.setList(this.list);
        if (this.recyclerView == null) {
            return;
        }
        if (this.recyclerView.getOnFlingListener() == null) {
            new PagerSnapHelper().attachToRecyclerView((RecyclerView)this.recyclerView);
        }
        this.layoutManager = new LayoutManager(this.getContext(), this.direction, this.reverse);
        this.layoutManager.setCalculateSpeedPerPixel(this.timeScroll, this.getWidth());
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.recyclerView.setAdapter(this.adapter);
        this.recyclerView.scrollToPosition(this.list.size() * 1000);
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == 0 && MyBannerView.this.pagerListener != null) {
                    int nowPosition = MyBannerView.this.layoutManager.findFirstCompletelyVisibleItemPosition();
                    if (nowPosition == -1) {
                        return;
                    }
                    int realBeforePosition = MyBannerView.this.adapter.getRealDataPosition(MyBannerView.this.beforeItemPosition);
                    int realNowPosition = MyBannerView.this.adapter.getRealDataPosition(nowPosition);
                    if (MyBannerView.this.indicatorParent != null) {
                        if (MyBannerView.this.preImageView != null) {
                            MyBannerView.this.preImageView.setImageDrawable(MyBannerView.this.unSelectDrawable);
                        }
                        if (MyBannerView.this.indicatorList != null && realBeforePosition < MyBannerView.this.indicatorList.size() && realNowPosition < MyBannerView.this.indicatorList.size()) {
                            ((ImageView)MyBannerView.this.indicatorList.get(realBeforePosition)).setImageDrawable(MyBannerView.this.unSelectDrawable);
                            ((ImageView)MyBannerView.this.indicatorList.get(realNowPosition)).setImageDrawable(MyBannerView.this.selectDrawable);
                        }
                    }
                    if (realBeforePosition != realNowPosition) {
                        MyBannerView.this.pagerListener.onPageSelected(MyBannerView.this.list.get(realNowPosition), realNowPosition, realBeforePosition);
                        MyBannerView.this.beforeItemPosition = realNowPosition;
                    }
                }
            }
        });
        this.startAutoPlay();
    }

    private void bannerRunnable() {
        if (this.recyclerView != null && this.layoutManager != null) {
            int position = this.layoutManager.findFirstVisibleItemPosition();
            this.recyclerView.smoothScrollToPosition(position + 1);
            int realPosition = this.adapter.getRealDataPosition(position);
            int realNextPosition = this.adapter.getRealDataPosition(position + 1);
            if (realPosition < 0 || realNextPosition < 0) {
                return;
            }
            if (this.indicatorParent != null && this.indicatorList != null) {
                ImageView imageView = this.indicatorList.get(realPosition);
                if (imageView != null) {
                    imageView.setImageDrawable(this.unSelectDrawable);
                }
                this.preImageView = this.indicatorList.get(realNextPosition);
                if (this.preImageView != null) {
                    this.preImageView.setImageDrawable(this.selectDrawable);
                }
            }
        }
    }

    public void startAutoPlay() {
        if (!this.autoPlay || this.layoutManager == null) {
            return;
        }
        this.handler.removeMessages(1000);
        this.message = this.handler.obtainMessage();
        this.message.what = 1000;
        this.handler.sendMessageDelayed(this.message, (long)this.timeInterval);
    }

    public void stopAutoPlay() {
        if (!this.autoPlay) {
            return;
        }
        this.handler.removeMessages(1000);
    }

    public <T> void addBannerItem(BannerItem<T> item) {
        this.adapter.addBannerItem(item);
    }

    public void setPagerListener(OnPagerListener pagerListener) {
        this.pagerListener = pagerListener;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.useGesture) {
            switch (event.getAction()) {
                case 0: {
                    this.stopAutoPlay();
                    break;
                }
                case 1: {
                    this.startAutoPlay();
                    break;
                }
                case 3: {
                    this.startAutoPlay();
                }
            }
        }
        return super.dispatchTouchEvent(event);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
        if (this.layoutManager != null) {
            this.layoutManager.setOrientation(direction);
        }
    }

    public int getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(int timeInterval) {
        this.timeInterval = timeInterval;
    }

    public int getTimeScroll() {
        return this.timeScroll;
    }

    public void setTimeScroll(int timeScroll) {
        this.timeScroll = timeScroll;
    }

    public boolean isAutoPlay() {
        return this.autoPlay;
    }

    public void setAutoPlay(boolean autoPlay) {
        this.autoPlay = autoPlay;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
        if (this.layoutManager != null) {
            this.layoutManager.setReverseLayout(reverse);
        }
    }

    public boolean isUseGesture() {
        return this.useGesture;
    }

    public void setUseGesture(boolean useGesture) {
        this.useGesture = useGesture;
        if (this.recyclerView != null) {
            this.recyclerView.setUseGesture(useGesture);
        }
    }

    public boolean isIndicatorHidden() {
        return this.indicatorHidden;
    }

    public void setIndicatorHidden(boolean indicatorHidden) {
        this.indicatorHidden = indicatorHidden;
    }

    public int getIndicatorDistance() {
        return this.indicatorDistance;
    }

    public void setIndicatorDistance(int indicatorDistance) {
        this.indicatorDistance = indicatorDistance;
    }

    public Drawable getIndicatorSelectDrawable() {
        return this.indicatorSelectDrawable;
    }

    public void setIndicatorSelectDrawable(Drawable indicatorSelectDrawable) {
        this.indicatorSelectDrawable = indicatorSelectDrawable;
    }

    public Drawable getIndicatorUnSelectDrawable() {
        return this.indicatorUnSelectDrawable;
    }

    public void setIndicatorUnSelectDrawable(Drawable indicatorUnSelectDrawable) {
        this.indicatorUnSelectDrawable = indicatorUnSelectDrawable;
    }

    public int getIndicatorDrawableWidth() {
        return this.indicatorDrawableWidth;
    }

    public void setIndicatorDrawableWidth(int indicatorDrawableWidth) {
        this.indicatorDrawableWidth = indicatorDrawableWidth;
    }

    public int getIndicatorDrawableHeight() {
        return this.indicatorDrawableHeight;
    }

    public void setIndicatorDrawableHeight(int indicatorDrawableHeight) {
        this.indicatorDrawableHeight = indicatorDrawableHeight;
    }

    public int dp2Px(float dp) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    public LinearLayout getIndicatorParent() {
        return this.indicatorParent;
    }

    private BitmapDrawable createDrawable(int width, int height, int cornerRadius, @ColorInt int filledColor) {
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        if (filledColor == 0) {
            filledColor = 0;
        }
        if (cornerRadius > 0) {
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setStyle(Paint.Style.FILL);
            paint.setColor(filledColor);
            canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)width, (float)height), (float)cornerRadius, (float)cornerRadius, paint);
        } else {
            canvas.drawColor(filledColor);
        }
        return new BitmapDrawable(this.getResources(), output);
    }

    public int getIndicatorSelectDrawableColor() {
        return this.indicatorSelectDrawableColor;
    }

    public void setIndicatorSelectDrawableColor(int indicatorSelectDrawableColor) {
        this.indicatorSelectDrawableColor = indicatorSelectDrawableColor;
    }

    public int getIndicatorUnSelectDrawableColor() {
        return this.indicatorUnSelectDrawableColor;
    }

    public void setIndicatorUnSelectDrawableColor(int indicatorUnSelectDrawableColor) {
        this.indicatorUnSelectDrawableColor = indicatorUnSelectDrawableColor;
    }

    public int getIndicatorDrawableRadius() {
        return this.indicatorDrawableRadius;
    }

    public void setIndicatorDrawableRadius(int indicatorDrawableRadius) {
        this.indicatorDrawableRadius = indicatorDrawableRadius;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.handler != null) {
            this.handler.removeMessages(1000);
            this.handler = null;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface orientation {
    }
}

