/*
 * Decompiled with CFR 0.152.
 */
package com.github.ring;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.github.ring.AndroidUtils;
import com.github.ring.R;

public class CircleProgress
extends View {
    public boolean isDebug = true;
    private OnCircleProgressInter onCircleProgressInter;
    private int centerX;
    private int centerY;
    private Paint mPaint;
    private Shader progressShader;
    private int neiYuanColor;
    private int ringRadius;
    private int ringWidth;
    private int ringColor;
    private int ringProgressColor;
    private int startAngle = -90;
    private boolean isClockwise = true;
    private float progress;
    private float scaleProgress = this.progress = 10.0f;
    private float maxProgress = 100.0f;
    private final int viewMax = 3600;
    private float viewProgress = this.progress * 3600.0f / this.maxProgress;
    private int disableAngle = 0;
    private boolean isRound = true;
    private boolean useAnimation = true;
    private int duration = 1000;
    private double progressPercent;
    private boolean isDecimal = true;
    private int decimalPointLength = 1;
    private boolean isShowPercentText = true;
    private int textColor;
    private int textSize;

    public CircleProgress(Context context) {
        super(context);
        this.initAttr(null);
    }

    public CircleProgress(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initAttr(attrs);
    }

    public CircleProgress(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttr(attrs);
    }

    private void initAttr(AttributeSet attrs) {
        this.initData();
        this.initPaint();
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.CircleProgress);
        this.neiYuanColor = typedArray.getColor(R.styleable.CircleProgress_neiYuanColor, this.getTransparentColor());
        this.ringRadius = (int)typedArray.getDimension(R.styleable.CircleProgress_ringRadius, -1.0f);
        this.ringWidth = (int)typedArray.getDimension(R.styleable.CircleProgress_ringWidth, 30.0f);
        this.ringColor = typedArray.getColor(R.styleable.CircleProgress_ringColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.top_color2));
        this.ringProgressColor = typedArray.getColor(R.styleable.CircleProgress_ringProgressColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.green1));
        this.startAngle = typedArray.getInteger(R.styleable.CircleProgress_startAngle, -90);
        this.isClockwise = typedArray.getBoolean(R.styleable.CircleProgress_isClockwise, true);
        this.progress = typedArray.getFloat(R.styleable.CircleProgress_progress, 10.0f);
        this.maxProgress = typedArray.getFloat(R.styleable.CircleProgress_maxProgress, 100.0f);
        if (this.maxProgress <= 0.0f) {
            this.maxProgress = 0.0f;
        }
        if (this.progress > this.maxProgress) {
            this.progress = this.maxProgress;
        } else if (this.progress < 0.0f) {
            this.progress = 0.0f;
        }
        this.scaleProgress = this.progress;
        this.viewProgress = this.progress * 3600.0f / this.maxProgress;
        this.disableAngle = typedArray.getInteger(R.styleable.CircleProgress_disableAngle, 0);
        this.isRound = typedArray.getBoolean(R.styleable.CircleProgress_isRound, true);
        this.useAnimation = typedArray.getBoolean(R.styleable.CircleProgress_useAnimation, true);
        this.duration = typedArray.getInteger(R.styleable.CircleProgress_duration, 1000);
        this.isDecimal = typedArray.getBoolean(R.styleable.CircleProgress_isDecimal, true);
        this.decimalPointLength = typedArray.getInteger(R.styleable.CircleProgress_decimalPointLength, 1);
        this.isShowPercentText = typedArray.getBoolean(R.styleable.CircleProgress_isShowPercentText, true);
        this.textColor = typedArray.getColor(R.styleable.CircleProgress_textColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.green1));
        this.textSize = (int)typedArray.getDimension(R.styleable.CircleProgress_textSize, (float)this.getDef_TextSize());
        typedArray.recycle();
    }

    private int getTransparentColor() {
        return ContextCompat.getColor((Context)this.getContext(), (int)R.color.transparent);
    }

    private int getDef_TextSize() {
        return this.dip2px(this.getContext(), 17.0f);
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setColor(-1);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    private void initData() {
        this.neiYuanColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.transparent);
        this.ringRadius = -1;
        this.ringWidth = 30;
        this.ringColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.top_color2);
        this.ringProgressColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.green1);
        this.textSize = this.dip2px(this.getContext(), 17.0f);
        this.textColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.green1);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int mWidth = 200;
        int mHeight = 200;
        if (this.getLayoutParams().width == -2 && this.getLayoutParams().height == -2) {
            this.setMeasuredDimension(mWidth, mHeight);
        } else if (this.getLayoutParams().width == -2) {
            this.setMeasuredDimension(mWidth, heightSize);
        } else if (this.getLayoutParams().height == -2) {
            this.setMeasuredDimension(widthSize, mHeight);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int WH = Math.min(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight(), this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
        if (this.ringRadius < 0) {
            this.ringRadius = (WH - this.ringWidth) / 2;
        }
        this.centerX = this.getWidth() / 2;
        this.centerY = this.getHeight() / 2;
        this.drawRing2(canvas);
        this.drawNeiYuan(canvas);
        this.drawProgressRing(canvas);
        if (this.isShowPercentText) {
            this.drawProgressText(canvas);
        }
    }

    private void drawProgressText(Canvas canvas) {
        this.mPaint.reset();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.progressPercent = AndroidUtils.chuFa(this.progress * 100.0f, this.maxProgress, this.decimalPointLength);
        String percentStr = this.progressPercent + "%";
        if (!this.isDecimal) {
            percentStr = (int)this.progressPercent + "%";
        }
        Rect rect = new Rect();
        this.mPaint.setTextSize((float)this.textSize);
        this.mPaint.setColor(this.textColor);
        this.mPaint.getTextBounds(percentStr, 0, percentStr.length(), rect);
        float baseLineHeight = Math.abs(this.mPaint.getFontMetrics().ascent);
        canvas.drawText(percentStr + "", (float)(this.centerX - rect.width() / 2), (float)this.centerY + baseLineHeight / 2.0f, this.mPaint);
    }

    private void drawNeiYuan(Canvas canvas) {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setColor(this.neiYuanColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawCircle((float)this.centerX, (float)this.centerY, (float)(this.ringRadius - this.ringWidth / 2), this.mPaint);
    }

    private void drawProgressRing(Canvas canvas) {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setColor(this.ringProgressColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.ringWidth);
        this.mPaint.setShader(null);
        RectF rectF = new RectF((float)(this.centerX - this.ringRadius), (float)(this.centerY - this.ringRadius), (float)(this.centerX + this.ringRadius), (float)(this.centerY + this.ringRadius));
        if (this.progressShader != null) {
            this.mPaint.setShader(this.progressShader);
        } else {
            this.mPaint.setShader(null);
        }
        if (this.isRound) {
            this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        }
        float angle = (float)AndroidUtils.chuFa(this.viewProgress * (float)this.getEffectiveDegree(), 3600.0, 2);
        if (!this.isClockwise) {
            angle = -1.0f * angle;
        }
        canvas.drawArc(rectF, (float)this.startAngle, angle, false, this.mPaint);
        this.mPaint.reset();
    }

    private void drawRing2(Canvas canvas) {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.ringWidth);
        this.mPaint.setColor(this.ringColor);
        RectF rectF = new RectF((float)(this.centerX - this.ringRadius), (float)(this.centerY - this.ringRadius), (float)(this.centerX + this.ringRadius), (float)(this.centerY + this.ringRadius));
        if (this.isRound) {
            this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        }
        float angle = this.getEffectiveDegree();
        if (!this.isClockwise) {
            angle = -1.0f * angle;
        }
        canvas.drawArc(rectF, (float)this.startAngle, angle, false, this.mPaint);
    }

    private void drawRing(Canvas canvas) {
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.ringWidth);
        this.mPaint.setColor(this.ringColor);
        canvas.drawCircle((float)this.centerX, (float)this.centerY, (float)this.ringRadius, this.mPaint);
    }

    public int getEffectiveDegree() {
        return 360 - this.disableAngle;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.setProgress(progress, this.useAnimation);
    }

    public int getDisableAngle() {
        return this.disableAngle;
    }

    public void setDisableAngle(int disableAngle) {
        int beforeDisableAngle = this.disableAngle;
        this.disableAngle = disableAngle > 360 ? 360 : (disableAngle < 0 ? 0 : disableAngle);
        if (this.useAnimation) {
            ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{beforeDisableAngle, disableAngle});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    CircleProgress.this.disableAngle = (Integer)animation.getAnimatedValue();
                    CircleProgress.this.invalidate();
                }
            });
            valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            valueAnimator.setDuration((long)this.duration);
            valueAnimator.start();
        } else {
            this.invalidate();
        }
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public CircleProgress setStartAngle(int startAngle) {
        this.startAngle = startAngle;
        this.invalidateCircleProgress();
        return this;
    }

    public void setProgress(float progress, boolean useAnimation) {
        float beforeProgress = this.viewProgress;
        this.progress = progress > this.maxProgress ? this.maxProgress : (progress < 0.0f ? 0.0f : progress);
        this.viewProgress = progress * 3600.0f / this.maxProgress;
        if (useAnimation) {
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{beforeProgress, this.viewProgress});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    CircleProgress.this.viewProgress = ((Float)animation.getAnimatedValue()).floatValue();
                    CircleProgress.this.scaleProgress = CircleProgress.this.viewProgress * CircleProgress.this.maxProgress / 3600.0f;
                    CircleProgress.this.invalidate();
                    CircleProgress.this.setCircleProgress(CircleProgress.this.scaleProgress, CircleProgress.this.progress, CircleProgress.this.maxProgress);
                }
            });
            valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            valueAnimator.setDuration((long)this.duration);
            valueAnimator.start();
        } else {
            this.scaleProgress = this.progress;
            this.invalidate();
            this.setCircleProgress(this.scaleProgress, this.progress, this.maxProgress);
        }
    }

    public int getNeiYuanColor() {
        return this.neiYuanColor;
    }

    public CircleProgress setNeiYuanColor(@ColorInt int neiYuanColor) {
        this.neiYuanColor = neiYuanColor;
        this.invalidateCircleProgress();
        return this;
    }

    public int getRingRadius() {
        return this.ringRadius;
    }

    public CircleProgress setRingRadius(int ringRadius) {
        this.ringRadius = ringRadius;
        this.invalidateCircleProgress();
        return this;
    }

    public int getRingWidth() {
        return this.ringWidth;
    }

    public CircleProgress setRingWidth(int ringWidth) {
        this.ringWidth = ringWidth;
        this.invalidateCircleProgress();
        return this;
    }

    public int getRingColor() {
        return this.ringColor;
    }

    public CircleProgress setRingColor(@ColorInt int ringColor) {
        this.ringColor = ringColor;
        this.invalidateCircleProgress();
        return this;
    }

    public int getRingProgressColor() {
        return this.ringProgressColor;
    }

    public CircleProgress setRingProgressColor(@ColorInt int ringProgressColor) {
        this.ringProgressColor = ringProgressColor;
        this.invalidateCircleProgress();
        return this;
    }

    public boolean isClockwise() {
        return this.isClockwise;
    }

    public CircleProgress setClockwise(boolean clockwise) {
        this.isClockwise = clockwise;
        this.invalidateCircleProgress();
        return this;
    }

    public Shader getProgressShader() {
        return this.progressShader;
    }

    public CircleProgress setProgressShader(Shader progressShader) {
        this.progressShader = progressShader;
        this.invalidateCircleProgress();
        return this;
    }

    public float getMaxProgress() {
        return this.maxProgress;
    }

    public CircleProgress setMaxProgress(float maxProgress) {
        this.maxProgress = maxProgress;
        this.invalidateCircleProgress();
        return this;
    }

    public boolean isRound() {
        return this.isRound;
    }

    public CircleProgress setRound(boolean round) {
        this.isRound = round;
        this.invalidateCircleProgress();
        return this;
    }

    public boolean isUseAnimation() {
        return this.useAnimation;
    }

    public CircleProgress setUseAnimation(boolean useAnimation) {
        this.useAnimation = useAnimation;
        this.invalidateCircleProgress();
        return this;
    }

    public int getDuration() {
        return this.duration;
    }

    public CircleProgress setDuration(int duration) {
        this.duration = duration;
        this.invalidateCircleProgress();
        return this;
    }

    public double getProgressPercent() {
        return this.progressPercent;
    }

    public boolean isDecimal() {
        return this.isDecimal;
    }

    public CircleProgress setDecimal(boolean decimal) {
        this.isDecimal = decimal;
        this.invalidateCircleProgress();
        return this;
    }

    public int getDecimalPointLength() {
        return this.decimalPointLength;
    }

    public CircleProgress setDecimalPointLength(int decimalPointLength) {
        this.decimalPointLength = decimalPointLength;
        this.invalidateCircleProgress();
        return this;
    }

    public boolean isShowPercentText() {
        return this.isShowPercentText;
    }

    public CircleProgress setShowPercentText(boolean showPercentText) {
        this.isShowPercentText = showPercentText;
        this.invalidateCircleProgress();
        return this;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public CircleProgress setTextColor(@ColorInt int textColor) {
        this.textColor = textColor;
        this.invalidateCircleProgress();
        return this;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public CircleProgress setTextSize(int textSize) {
        this.textSize = textSize;
        this.invalidateCircleProgress();
        return this;
    }

    public OnCircleProgressInter getOnCircleProgressInter() {
        return this.onCircleProgressInter;
    }

    public CircleProgress setOnCircleProgressInter(OnCircleProgressInter onCircleProgressInter) {
        this.onCircleProgressInter = onCircleProgressInter;
        return this;
    }

    private void setCircleProgress(float scaleProgress, float progress, float max) {
        if (this.onCircleProgressInter != null) {
            this.onCircleProgressInter.progress(scaleProgress, progress, max);
        }
    }

    private void invalidateCircleProgress() {
        this.invalidate();
    }

    private int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    private int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static interface OnCircleProgressInter {
        public void progress(float var1, float var2, float var3);
    }
}

