/*
 * Decompiled with CFR 0.152.
 */
package com.github.ring;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AndroidUtils {
    AndroidUtils() {
    }

    public static String getLocalIpAddress2() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return "192.168.1.1";
    }

    private static String intToIp(int i) {
        return (i & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 24 & 0xFF);
    }

    public static double round(double value, int scale, int roundingMode) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(scale, roundingMode);
        double d = bd.doubleValue();
        bd = null;
        return d;
    }

    public static double round(double value) {
        return AndroidUtils.round(value, 2, 4);
    }

    public static double jiaFa(double d1, double d2) {
        BigDecimal bd1 = new BigDecimal(d1);
        BigDecimal bd2 = new BigDecimal(d2);
        return AndroidUtils.round(bd1.add(bd2).doubleValue());
    }

    public static double jianFa(double d1, double d2) {
        BigDecimal bd1 = new BigDecimal(Double.toString(d1));
        BigDecimal bd2 = new BigDecimal(Double.toString(d2));
        return AndroidUtils.round(bd1.subtract(bd2).doubleValue());
    }

    public static double chengFa(double d1, double d2) {
        BigDecimal bd1 = new BigDecimal(d1);
        BigDecimal bd2 = new BigDecimal(d2);
        return AndroidUtils.round(bd1.multiply(bd2).doubleValue());
    }

    public static double chuFa(double d1, double d2, int scale) {
        try {
            if (d2 == 0.0) {
                throw new Exception("\u5206\u6bcd\u4e0d\u80fd\u4e3a0");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BigDecimal bd1 = new BigDecimal(Double.toString(d1));
        BigDecimal bd2 = new BigDecimal(Double.toString(d2));
        return bd1.divide(bd2, scale, 4).doubleValue();
    }

    public static double chuFa(double d1, double d2) {
        return AndroidUtils.chuFa(d1, d2, 2);
    }

    public static String double2String(double d) {
        BigDecimal bg = new BigDecimal(d * 100.0);
        double doubleValue = bg.setScale(2, 4).doubleValue();
        return String.valueOf((int)doubleValue);
    }

    public static boolean personIdValidation(String text) {
        String regx = "[0-9]{17}x";
        String reg1 = "[0-9]{15}";
        String regex = "[0-9]{18}";
        return text.matches(regx) || text.matches(reg1) || text.matches(regex);
    }

    public static boolean isIDcard(String str) {
        String regex = "(^\\d{18}$)|(^\\d{15}$)";
        return AndroidUtils.match(regex, str);
    }

    private static boolean match(String regex, String str) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }
}

