/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.test.espresso.idling.CountingIdlingResource;
import com.getbouncer.cardscan.CreditCard;
import com.getbouncer.cardscan.TestingImageBridge;
import com.getbouncer.cardscan.TestingImageReader;
import com.getbouncer.cardscan.base.IdleResourceManager;
import com.getbouncer.cardscan.base.ScanActivityImpl;
import com.getbouncer.cardscan.base.ScanBaseActivity;

public class ScanActivity {
    private static final String TAG = "ScanActivity";
    private static final int REQUEST_CODE = 51234;
    public static final int RESULT_CANCELED = 0;
    public static final int RESULT_OK = -1;
    public static String RESULT_FATAL_ERROR = ScanBaseActivity.RESULT_FATAL_ERROR;
    public static TestingImageReader testingImageReader = null;
    public static String apiKey;
    public static String cameraPermissionTitle;
    public static String cameraPermissionMessage;

    public static void start(@NonNull Activity activity) {
        ScanBaseActivity.warmUp((Context)activity.getApplicationContext());
        Intent intent = new Intent((Context)activity, ScanActivityImpl.class);
        intent.putExtra("apiKey", apiKey);
        intent.putExtra("cameraPermissionTitle", cameraPermissionTitle);
        intent.putExtra("cameraPermissionMessage", cameraPermissionMessage);
        activity.startActivityForResult(intent, 51234);
    }

    public static void start(@NonNull Fragment fragment) {
        ScanBaseActivity.warmUp((Context)fragment.getContext());
        Intent intent = new Intent(fragment.getContext(), ScanActivityImpl.class);
        intent.putExtra("apiKey", apiKey);
        intent.putExtra("cameraPermissionTitle", cameraPermissionTitle);
        intent.putExtra("cameraPermissionMessage", cameraPermissionMessage);
        fragment.startActivityForResult(intent, 51234);
    }

    public static void start(@NonNull Activity activity, boolean delayShowingExpiration) {
        ScanBaseActivity.warmUp((Context)activity.getApplicationContext());
        Intent intent = new Intent((Context)activity, ScanActivityImpl.class);
        intent.putExtra("apiKey", apiKey);
        intent.putExtra("cameraPermissionTitle", cameraPermissionTitle);
        intent.putExtra("cameraPermissionMessage", cameraPermissionMessage);
        intent.putExtra(ScanBaseActivity.DELAY_SHOWING_EXPIRATION, delayShowingExpiration);
        activity.startActivityForResult(intent, 51234);
    }

    public static void start(@NonNull Fragment fragment, boolean delayShowingExpiration) {
        ScanBaseActivity.warmUp((Context)fragment.getContext());
        Intent intent = new Intent(fragment.getContext(), ScanActivityImpl.class);
        intent.putExtra("apiKey", apiKey);
        intent.putExtra("cameraPermissionTitle", cameraPermissionTitle);
        intent.putExtra("cameraPermissionMessage", cameraPermissionMessage);
        intent.putExtra(ScanBaseActivity.DELAY_SHOWING_EXPIRATION, delayShowingExpiration);
        fragment.startActivityForResult(intent, 51234);
    }

    public static void start(@NonNull Activity activity, boolean delayShowingExpiration, boolean showEnterCardNumberManually) {
        ScanBaseActivity.warmUp((Context)activity.getApplicationContext());
        Intent intent = new Intent((Context)activity, ScanActivityImpl.class);
        intent.putExtra("apiKey", apiKey);
        intent.putExtra("cameraPermissionTitle", cameraPermissionTitle);
        intent.putExtra("cameraPermissionMessage", cameraPermissionMessage);
        intent.putExtra(ScanBaseActivity.DELAY_SHOWING_EXPIRATION, delayShowingExpiration);
        intent.putExtra("enterCardManuallyButton", showEnterCardNumberManually);
        activity.startActivityForResult(intent, 51234);
    }

    public static void start(@NonNull Fragment fragment, boolean delayShowingExpiration, boolean showEnterCardNumberManually) {
        ScanBaseActivity.warmUp((Context)fragment.getContext());
        Intent intent = new Intent(fragment.getContext(), ScanActivityImpl.class);
        intent.putExtra("apiKey", apiKey);
        intent.putExtra("cameraPermissionTitle", cameraPermissionTitle);
        intent.putExtra("cameraPermissionMessage", cameraPermissionMessage);
        intent.putExtra(ScanBaseActivity.DELAY_SHOWING_EXPIRATION, delayShowingExpiration);
        intent.putExtra("enterCardManuallyButton", showEnterCardNumberManually);
        fragment.startActivityForResult(intent, 51234);
    }

    public static void start(@NonNull Activity activity, String scanCardText, String positionCardText) {
        ScanBaseActivity.warmUp((Context)activity.getApplicationContext());
        Intent intent = new Intent((Context)activity, ScanActivityImpl.class);
        intent.putExtra("scanCardText", scanCardText);
        intent.putExtra("positionCardText", positionCardText);
        intent.putExtra("apiKey", apiKey);
        intent.putExtra("cameraPermissionTitle", cameraPermissionTitle);
        intent.putExtra("cameraPermissionMessage", cameraPermissionMessage);
        activity.startActivityForResult(intent, 51234);
    }

    public static void start(@NonNull Fragment fragment, String scanCardText, String positionCardText) {
        ScanBaseActivity.warmUp((Context)fragment.getContext());
        Intent intent = new Intent(fragment.getContext(), ScanActivityImpl.class);
        intent.putExtra("scanCardText", scanCardText);
        intent.putExtra("positionCardText", positionCardText);
        intent.putExtra("apiKey", apiKey);
        intent.putExtra("cameraPermissionTitle", cameraPermissionTitle);
        intent.putExtra("cameraPermissionMessage", cameraPermissionMessage);
        fragment.startActivityForResult(intent, 51234);
    }

    public static void start(@NonNull Activity activity, String scanCardText, String positionCardText, boolean delayShowingExpiration, boolean showEnterCardNumberManually) {
        ScanBaseActivity.warmUp((Context)activity.getApplicationContext());
        Intent intent = new Intent((Context)activity, ScanActivityImpl.class);
        intent.putExtra("scanCardText", scanCardText);
        intent.putExtra("positionCardText", positionCardText);
        intent.putExtra("apiKey", apiKey);
        intent.putExtra("cameraPermissionTitle", cameraPermissionTitle);
        intent.putExtra("cameraPermissionMessage", cameraPermissionMessage);
        intent.putExtra("enterCardManuallyButton", showEnterCardNumberManually);
        intent.putExtra(ScanBaseActivity.DELAY_SHOWING_EXPIRATION, delayShowingExpiration);
        activity.startActivityForResult(intent, 51234);
    }

    public static void start(@NonNull Fragment fragment, String scanCardText, String positionCardText, boolean delayShowingExpiration, boolean showEnterCardNumberManually) {
        ScanBaseActivity.warmUp((Context)fragment.getContext());
        Intent intent = new Intent(fragment.getContext(), ScanActivityImpl.class);
        intent.putExtra("scanCardText", scanCardText);
        intent.putExtra("positionCardText", positionCardText);
        intent.putExtra("apiKey", apiKey);
        intent.putExtra("cameraPermissionTitle", cameraPermissionTitle);
        intent.putExtra("cameraPermissionMessage", cameraPermissionMessage);
        intent.putExtra("enterCardManuallyButton", showEnterCardNumberManually);
        intent.putExtra(ScanBaseActivity.DELAY_SHOWING_EXPIRATION, delayShowingExpiration);
        fragment.startActivityForResult(intent, 51234);
    }

    public static void warmUp(@NonNull Activity activity) {
        ScanBaseActivity.warmUp((Context)activity.getApplicationContext());
    }

    public static void warmUp(@NonNull Fragment fragment) {
        ScanBaseActivity.warmUp((Context)fragment.getContext());
    }

    public static void startDebug(@NonNull Activity activity) {
        ScanActivity.startDebug(activity, null);
    }

    public static void startDebug(@NonNull Activity activity, @Nullable TestingImageReader imageReader) {
        if (imageReader != null) {
            ScanBaseActivity.sTestingImageReader = new TestingImageBridge(imageReader);
        }
        ScanBaseActivity.warmUp((Context)activity.getApplicationContext());
        Intent intent = new Intent((Context)activity, ScanActivityImpl.class);
        intent.putExtra("debug", true);
        intent.putExtra("apiKey", apiKey);
        intent.putExtra("cameraPermissionTitle", cameraPermissionTitle);
        intent.putExtra("cameraPermissionMessage", cameraPermissionMessage);
        activity.startActivityForResult(intent, 51234);
    }

    public static void startDebug(@NonNull Fragment fragment) {
        ScanActivity.startDebug(fragment, null);
    }

    public static void startDebug(@NonNull Fragment fragment, @Nullable TestingImageReader imageReader) {
        if (imageReader != null) {
            ScanBaseActivity.sTestingImageReader = new TestingImageBridge(imageReader);
        }
        ScanBaseActivity.warmUp((Context)fragment.getContext());
        Intent intent = new Intent(fragment.getContext(), ScanActivityImpl.class);
        intent.putExtra("debug", true);
        intent.putExtra("apiKey", apiKey);
        intent.putExtra("cameraPermissionTitle", cameraPermissionTitle);
        intent.putExtra("cameraPermissionMessage", cameraPermissionMessage);
        fragment.startActivityForResult(intent, 51234);
    }

    public static boolean isScanResult(int requestCode) {
        return requestCode == 51234;
    }

    @Nullable
    public static CreditCard creditCardFromResult(Intent intent) {
        String number = intent.getStringExtra("cardNumber");
        String month = intent.getStringExtra("expiryMonth");
        String year = intent.getStringExtra("expiryYear");
        if (TextUtils.isEmpty((CharSequence)number)) {
            return null;
        }
        return new CreditCard(number, month, year);
    }

    public static CountingIdlingResource getScanningIdleResource() {
        return IdleResourceManager.getScanningIdleResource();
    }
}

