/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.getbouncer.cardscan.base.CreditCardUtils;
import com.getbouncer.cardscan.base.SSDOcrModel;
import com.getbouncer.cardscan.base.ssd.DetectedOcrBox;
import com.getbouncer.cardscan.base.ssd.DetectionBox;
import com.getbouncer.cardscan.base.ssd.OcrPriorsGenerator;
import com.getbouncer.cardscan.base.ssd.SSD;
import com.getbouncer.cardscan.base.ssd.Size;
import com.getbouncer.cardscan.base.ssd.domain.ClassifierScores;
import com.getbouncer.cardscan.base.ssd.domain.SizeAndCenter;
import com.getbouncer.cardscan.base.util.ArrayExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.jvm.functions.Function1;

public class SSDOcrDetect {
    @Nullable
    private static SSDOcrModel ssdOcrModel = null;
    @Nullable
    private static float[][] priors = null;
    private final List<Float> yMinArray = new ArrayList<Float>();
    private final List<Float> yMaxArray = new ArrayList<Float>();
    public final List<DetectedOcrBox> objectBoxes = new ArrayList<DetectedOcrBox>();
    public boolean hadUnrecoverableException = false;
    public static boolean USE_GPU = false;

    static boolean isInit() {
        return ssdOcrModel != null;
    }

    @Nullable
    private String ssdOutputToPredictions(@NonNull Bitmap image, boolean strict) {
        String numberOCR;
        if (ssdOcrModel == null || priors == null) {
            return null;
        }
        float[][] k_boxes = SSD.rearrangeOCRArray(SSDOcrDetect.ssdOcrModel.outputLocations, SSDOcrModel.FEATURE_MAP_SIZES, 3, 4);
        k_boxes = ArrayExtensions.reshape(k_boxes, 4);
        SizeAndCenter.adjustLocations(k_boxes, priors, 0.1f, 0.2f);
        SizeAndCenter.toRectForm(k_boxes);
        float[][] k_scores = SSD.rearrangeOCRArray(SSDOcrDetect.ssdOcrModel.outputClasses, SSDOcrModel.FEATURE_MAP_SIZES, 3, 11);
        k_scores = ArrayExtensions.reshape(k_scores, 11);
        ClassifierScores.softMax2D(k_scores);
        List<DetectionBox> detectionBoxes = SSD.extractPredictions(k_scores, k_boxes, new Size(image.getWidth(), image.getHeight()), 0.5f, 0.5f, 20, (Function1<? super Integer, Integer>)new Function1<Integer, Integer>(){

            public Integer invoke(Integer o) {
                if (o == 10) {
                    return 0;
                }
                return o;
            }
        });
        Collections.sort(detectionBoxes, new Comparator<DetectionBox>(){

            @Override
            public int compare(DetectionBox o1, DetectionBox o2) {
                return Float.compare(o1.getRect().left, o2.getRect().left);
            }
        });
        for (DetectionBox detectionBox : detectionBoxes) {
            this.objectBoxes.add(new DetectedOcrBox(detectionBox.getRect().left, detectionBox.getRect().top, detectionBox.getRect().right, detectionBox.getRect().bottom, detectionBox.getConfidence(), detectionBox.getImageSize().getWidth(), detectionBox.getImageSize().getHeight(), detectionBox.getLabel()));
            this.yMinArray.add(Float.valueOf(detectionBox.getRect().top * (float)image.getHeight()));
            this.yMaxArray.add(Float.valueOf(detectionBox.getRect().bottom * (float)image.getHeight()));
        }
        Collections.sort(this.yMinArray);
        Collections.sort(this.yMaxArray);
        float medianYMin = 0.0f;
        float medianYMax = 0.0f;
        float medianHeight = 0.0f;
        float medianYCenter = 0.0f;
        if (!this.yMaxArray.isEmpty() && !this.yMinArray.isEmpty()) {
            medianYMin = this.yMinArray.get(this.yMinArray.size() / 2).floatValue();
            medianYMax = this.yMaxArray.get(this.yMaxArray.size() / 2).floatValue();
            medianHeight = Math.abs(medianYMax - medianYMin);
            medianYCenter = (medianYMax + medianYMin) / 2.0f;
        }
        StringBuilder num = new StringBuilder();
        for (DetectedOcrBox box : this.objectBoxes) {
            if (!(Math.abs(box.rect.centerY() - medianYCenter) <= medianHeight)) continue;
            num.append(box.label);
        }
        if (CreditCardUtils.isValidCardNumber(num.toString())) {
            numberOCR = num.toString();
            Log.d((String)"OCR Number passed", (String)numberOCR);
        } else {
            Log.d((String)"OCR Number failed", (String)num.toString());
            numberOCR = strict ? null : num.toString();
        }
        return numberOCR;
    }

    private String runModel(Bitmap image) {
        return this.runModel(image, true);
    }

    @Nullable
    private String runModel(@NonNull Bitmap image, boolean strict) {
        long startTime = SystemClock.uptimeMillis();
        if (ssdOcrModel == null) {
            return "";
        }
        ssdOcrModel.classifyFrame(image);
        Log.d((String)"Before SSD Post Process", (String)String.valueOf(SystemClock.uptimeMillis() - startTime));
        String number = this.ssdOutputToPredictions(image, strict);
        Log.d((String)"After SSD Post Process", (String)String.valueOf(SystemClock.uptimeMillis() - startTime));
        return number;
    }

    private static <T, V extends Comparable<V>> T getKeyByMaxValue(Map<T, V> map) {
        Map.Entry<T, V> maxEntry = null;
        for (Map.Entry<T, V> entry : map.entrySet()) {
            if (maxEntry != null && ((Comparable)entry.getValue()).compareTo(maxEntry.getValue()) <= 0) continue;
            maxEntry = entry;
        }
        if (maxEntry != null) {
            return (T)maxEntry.getKey();
        }
        return null;
    }

    public static void runInCompletionLoop(final @NonNull List<Bitmap> frames, final @NonNull Context context, final @Nullable OnDetectListener detection) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                final HashMap<String, Integer> results = new HashMap<String, Integer>();
                for (Bitmap ocrFrame : frames) {
                    SSDOcrDetect ocrDetect;
                    String prediction;
                    if (ocrFrame == null || (prediction = (ocrDetect = new SSDOcrDetect()).predict(ocrFrame, context)) == null) continue;
                    Integer count = (Integer)results.get(prediction);
                    if (count != null) {
                        results.put(prediction, count + 1);
                        continue;
                    }
                    results.put(prediction, 1);
                }
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (detection != null) {
                            detection.complete((String)SSDOcrDetect.getKeyByMaxValue(results));
                        }
                    }
                });
            }
        }).start();
    }

    @Nullable
    public synchronized String predict(@NonNull Bitmap image, @NonNull Context context) {
        int NUM_THREADS = 4;
        try {
            boolean createdNewModel = false;
            try {
                if (ssdOcrModel == null) {
                    ssdOcrModel = new SSDOcrModel(context);
                    ssdOcrModel.setNumThreads(4);
                    if (priors == null) {
                        priors = OcrPriorsGenerator.combinePriors();
                    }
                }
            }
            catch (Error | Exception e) {
                Log.e((String)"SSD", (String)"Couldn't load ssd", (Throwable)e);
            }
            try {
                return this.runModel(image);
            }
            catch (Error | Exception e) {
                Log.i((String)"OCR", (String)"runModel exception, retry object detection", (Throwable)e);
                ssdOcrModel = new SSDOcrModel(context);
                return this.runModel(image);
            }
        }
        catch (Error | Exception e) {
            Log.e((String)"OCR", (String)"unrecoverable exception on ObjectDetect", (Throwable)e);
            this.hadUnrecoverableException = true;
            return null;
        }
    }

    @Nullable
    public synchronized String predict(@NonNull Bitmap image, @NonNull Context context, boolean strict) {
        int NUM_THREADS = 4;
        try {
            boolean createdNewModel = false;
            try {
                if (ssdOcrModel == null) {
                    ssdOcrModel = new SSDOcrModel(context);
                    ssdOcrModel.setNumThreads(4);
                    if (priors == null) {
                        priors = OcrPriorsGenerator.combinePriors();
                    }
                }
            }
            catch (Error | Exception e) {
                Log.e((String)"SSD", (String)"Couldn't load ssd", (Throwable)e);
            }
            try {
                return this.runModel(image, strict);
            }
            catch (Error | Exception e) {
                Log.i((String)"ObjectDetect", (String)"runModel exception, retry object detection", (Throwable)e);
                ssdOcrModel = new SSDOcrModel(context);
                return this.runModel(image, strict);
            }
        }
        catch (Error | Exception e) {
            Log.e((String)"ObjectDetect", (String)"unrecoverable exception on ObjectDetect", (Throwable)e);
            this.hadUnrecoverableException = true;
            return null;
        }
    }

    public static interface OnDetectListener {
        public void complete(String var1);
    }
}

