/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.getbouncer.cardscan.base.GlobalConfig;
import com.getbouncer.cardscan.base.SSDDetect;
import com.getbouncer.cardscan.base.ssd.DetectedSSDBox;
import com.getbouncer.cardscan.base.ssd.DetectionBox;
import com.getbouncer.cardscan.base.ssd.ObjectPriorsGen;
import com.getbouncer.cardscan.base.ssd.SSD;
import com.getbouncer.cardscan.base.ssd.Size;
import com.getbouncer.cardscan.base.ssd.domain.ClassifierScores;
import com.getbouncer.cardscan.base.ssd.domain.SizeAndCenter;
import com.getbouncer.cardscan.base.util.ArrayExtensions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class ObjectDetect {
    @Nullable
    private static SSDDetect ssdDetect = null;
    @Nullable
    private static float[][] priors = null;
    @NonNull
    private final File ssdModelFile;
    @NonNull
    public List<DetectedSSDBox> objectBoxes = new ArrayList<DetectedSSDBox>();
    boolean hadUnrecoverableException = false;
    public static boolean USE_GPU = false;

    static boolean isInit() {
        return ssdDetect != null;
    }

    public ObjectDetect(@NotNull File modelFile) {
        this.ssdModelFile = modelFile;
    }

    private void ssdOutputToPredictions(@NonNull Bitmap image) {
        if (ssdDetect == null || priors == null) {
            return;
        }
        float[][] k_boxes = SSD.rearrangeArray(ObjectDetect.ssdDetect.outputLocations, SSDDetect.featureMapSizes, 6, 4);
        k_boxes = ArrayExtensions.reshape(k_boxes, 4);
        SizeAndCenter.adjustLocations(k_boxes, priors, 0.1f, 0.2f);
        SizeAndCenter.toRectForm(k_boxes);
        float[][] k_scores = SSD.rearrangeArray(ObjectDetect.ssdDetect.outputClasses, SSDDetect.featureMapSizes, 6, 14);
        k_scores = ArrayExtensions.reshape(k_scores, 14);
        ClassifierScores.softMax2D(k_scores);
        List<DetectionBox> detectionBoxes = SSD.extractPredictions(k_scores, k_boxes, new Size(image.getWidth(), image.getHeight()), 0.3f, 0.45f, 10, (Function1<? super Integer, Integer>)new Function1<Integer, Integer>(){

            public Integer invoke(Integer integer) {
                return integer;
            }
        });
        for (DetectionBox detectionBox : detectionBoxes) {
            this.objectBoxes.add(new DetectedSSDBox(detectionBox.getRect().left, detectionBox.getRect().top, detectionBox.getRect().right, detectionBox.getRect().bottom, detectionBox.getConfidence(), detectionBox.getImageSize().getWidth(), detectionBox.getImageSize().getHeight(), detectionBox.getLabel()));
        }
    }

    @NonNull
    private String runModel(@NonNull Bitmap image) {
        long startTime = SystemClock.uptimeMillis();
        if (ssdDetect == null) {
            return "Failure";
        }
        ssdDetect.classifyFrame(image);
        if (GlobalConfig.PRINT_TIMING) {
            Log.d((String)"Before SSD Post Process", (String)String.valueOf(SystemClock.uptimeMillis() - startTime));
        }
        this.ssdOutputToPredictions(image);
        if (GlobalConfig.PRINT_TIMING) {
            Log.d((String)"After SSD Post Process", (String)String.valueOf(SystemClock.uptimeMillis() - startTime));
        }
        return "Success";
    }

    @Nullable
    public synchronized String predictOnCpu(@NonNull Bitmap image, @NonNull Context context) {
        int NUM_THREADS = 4;
        try {
            boolean createdNewModel = false;
            try {
                if (ssdDetect == null) {
                    ssdDetect = new SSDDetect(context, this.ssdModelFile);
                    ssdDetect.setNumThreads(4);
                    if (priors == null) {
                        priors = ObjectPriorsGen.combinePriors();
                    }
                }
            }
            catch (Error | Exception e) {
                Log.e((String)"SSD", (String)"Couldn't load ssd", (Throwable)e);
            }
            try {
                return this.runModel(image);
            }
            catch (Error | Exception e) {
                Log.i((String)"ObjectDetect", (String)"runModel exception, retry object detection", (Throwable)e);
                ssdDetect = new SSDDetect(context, this.ssdModelFile);
                return this.runModel(image);
            }
        }
        catch (Error | Exception e) {
            Log.e((String)"ObjectDetect", (String)"unrecoverable exception on ObjectDetect", (Throwable)e);
            this.hadUnrecoverableException = true;
            return null;
        }
    }
}

