/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.getbouncer.cardscan.base.GlobalConfig;
import com.getbouncer.cardscan.base.ObjectDetect;
import com.getbouncer.cardscan.base.OnObjectListener;
import com.getbouncer.cardscan.base.OnScanListener;
import com.getbouncer.cardscan.base.OnUXModelListener;
import com.getbouncer.cardscan.base.SSDOcrDetect;
import com.getbouncer.cardscan.base.ScanBaseActivity;
import com.getbouncer.cardscan.base.image.YUVDecoder;
import com.getbouncer.cardscan.base.ssd.DetectedSSDBox;
import java.io.File;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class MachineLearningThread
implements Runnable {
    protected LinkedList<RunArguments> queue = new LinkedList();

    public synchronized void warmUp(@NonNull Context context) {
        if (!this.queue.isEmpty()) {
            return;
        }
        RunArguments args = new RunArguments(null, 0, 0, 0, 90, null, context, 0.5f);
        this.queue.push(args);
        this.notify();
    }

    public synchronized void post(@Nullable Bitmap bitmap, @Nullable OnScanListener scanListener, @NonNull Context context) {
        RunArguments args = new RunArguments(bitmap, scanListener, context);
        this.queue.push(args);
        this.notify();
    }

    public synchronized void post(@NonNull byte[] bytes, int width, int height, int format, int sensorOrientation, @Nullable OnScanListener scanListener, @NonNull Context context, float roiCenterYRatio) {
        RunArguments args = new RunArguments(bytes, width, height, format, sensorOrientation, scanListener, context, roiCenterYRatio);
        this.queue.push(args);
        this.notify();
    }

    public synchronized void post(@Nullable Bitmap bitmap, @Nullable OnObjectListener objectListener, @NonNull Context context, @Nullable File objectDetectFile) {
        RunArguments args = new RunArguments(bitmap, objectListener, context, objectDetectFile);
        this.queue.push(args);
        this.notify();
    }

    public synchronized void post(@NonNull byte[] bytes, int width, int height, int format, int sensorOrientation, @Nullable OnObjectListener objectListener, @NonNull Context context, float roiCenterYRatio, @Nullable File objectDetectFile) {
        RunArguments args = new RunArguments(bytes, width, height, format, sensorOrientation, objectListener, context, roiCenterYRatio, objectDetectFile);
        this.queue.push(args);
        this.notify();
    }

    @NonNull
    public Bitmap YUVtoRGB(@NonNull byte[] yuvByteArray, int previewWidth, int previewHeight) {
        int resizedWidth;
        int resizedHeight;
        Bitmap fullImage = YUVDecoder.YUVtoBitmap(yuvByteArray, previewWidth, previewHeight);
        if (previewWidth > previewHeight) {
            resizedHeight = ScanBaseActivity.MIN_IMAGE_EDGE;
            resizedWidth = previewWidth * resizedHeight / previewHeight;
        } else {
            resizedWidth = ScanBaseActivity.MIN_IMAGE_EDGE;
            resizedHeight = previewHeight * resizedWidth / previewWidth;
        }
        Bitmap resizedImage = Bitmap.createScaledBitmap((Bitmap)fullImage, (int)resizedWidth, (int)resizedHeight, (boolean)false);
        fullImage.recycle();
        return resizedImage;
    }

    @NonNull
    protected Bitmaps getBitmaps(@NonNull byte[] bytes, int width, int height, int format, int sensorOrientation, float roiCenterYRatio, boolean isOcr) {
        int y;
        int x;
        double h;
        double w;
        long startTime = SystemClock.uptimeMillis();
        Bitmap bitmap = this.YUVtoRGB(bytes, width, height);
        long decode = SystemClock.uptimeMillis();
        if (GlobalConfig.PRINT_TIMING) {
            Log.d((String)"MLThread", (String)("decode -> " + (double)(decode - startTime) / 1000.0));
        }
        if ((sensorOrientation %= 360) == 0) {
            h = w = (double)bitmap.getWidth();
            x = 0;
            y = (int)Math.round((double)bitmap.getHeight() * (double)roiCenterYRatio - h * 0.5);
        } else if (sensorOrientation == 90) {
            w = h = (double)bitmap.getHeight();
            y = 0;
            x = (int)Math.round((double)bitmap.getWidth() * (double)roiCenterYRatio - w * 0.5);
        } else if (sensorOrientation == 180) {
            h = w = (double)bitmap.getWidth();
            x = 0;
            y = (int)Math.round((double)bitmap.getHeight() * (1.0 - (double)roiCenterYRatio) - h * 0.5);
        } else {
            w = h = (double)bitmap.getHeight();
            x = (int)Math.round((double)bitmap.getWidth() * (1.0 - (double)roiCenterYRatio) - w * 0.5);
            y = 0;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if ((double)x + w > (double)bitmap.getWidth()) {
            x = bitmap.getWidth() - (int)w;
        }
        if ((double)y + h > (double)bitmap.getHeight()) {
            y = bitmap.getHeight() - (int)h;
        }
        Bitmap objectCroppedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)x, (int)y, (int)((int)w), (int)((int)h));
        long crop = SystemClock.uptimeMillis();
        if (GlobalConfig.PRINT_TIMING) {
            Log.d((String)"MLThread", (String)("crop -> " + (double)(crop - decode) / 1000.0));
        }
        Matrix matrix = new Matrix();
        matrix.postRotate((float)sensorOrientation);
        Bitmap objectCroppedRotatedBitmap = Bitmap.createBitmap((Bitmap)objectCroppedBitmap, (int)0, (int)0, (int)objectCroppedBitmap.getWidth(), (int)objectCroppedBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Bitmap ocrCroppedBitmap = this.cropBitmapForOCR(objectCroppedRotatedBitmap);
        Bitmap fullScreenRotated = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Bitmap screenCroppedRotatedBitmap = this.cropBitmapForScreenDetection(fullScreenRotated);
        long rotate = SystemClock.uptimeMillis();
        if (GlobalConfig.PRINT_TIMING) {
            Log.d((String)"MLThread", (String)("rotate -> " + (double)(rotate - crop) / 1000.0));
        }
        objectCroppedBitmap.recycle();
        bitmap.recycle();
        return new Bitmaps(ocrCroppedBitmap, objectCroppedRotatedBitmap, screenCroppedRotatedBitmap, fullScreenRotated);
    }

    @NonNull
    protected synchronized RunArguments getNextImage() {
        while (this.queue.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.queue.pop();
    }

    private void runObjectModel(final @NonNull Bitmap bitmapForObjectDetection, final @NonNull RunArguments args, final @Nullable Bitmap bitmapForScreenDetection, final long frameAddedTimeMs) {
        if (args.mObjectDetectFile == null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (args.mObjectListener != null) {
                        args.mObjectListener.onPrediction(bitmapForObjectDetection, new LinkedList<DetectedSSDBox>(), bitmapForObjectDetection.getWidth(), bitmapForObjectDetection.getHeight(), bitmapForScreenDetection, frameAddedTimeMs);
                    }
                    bitmapForObjectDetection.recycle();
                    if (bitmapForScreenDetection != null) {
                        bitmapForScreenDetection.recycle();
                    }
                }
            });
            return;
        }
        final ObjectDetect detect = new ObjectDetect(args.mObjectDetectFile);
        detect.predictOnCpu(bitmapForObjectDetection, args.mContext);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (args.mObjectListener != null) {
                        if (detect.hadUnrecoverableException) {
                            args.mObjectListener.onObjectFatalError();
                        } else {
                            args.mObjectListener.onPrediction(bitmapForObjectDetection, detect.objectBoxes, bitmapForObjectDetection.getWidth(), bitmapForObjectDetection.getHeight(), bitmapForScreenDetection, frameAddedTimeMs);
                        }
                    }
                    bitmapForObjectDetection.recycle();
                    if (bitmapForScreenDetection != null) {
                        bitmapForScreenDetection.recycle();
                    }
                }
                catch (Error | Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void runOcrModel(final @NonNull Bitmap bitmapForOcrDetection, final @NonNull RunArguments args, final @NonNull Bitmap bitmapForObjectDetection, final @Nullable Bitmap bitmapForScreenDetection, final long frameAddedTimeMs) {
        SSDOcrDetect ocrDetect = new SSDOcrDetect();
        final String number = ocrDetect.predict(bitmapForOcrDetection, args.mContext);
        Log.d((String)"OCR Detect", (String)("OCR Number:" + number));
        final boolean hadUnrecoverableException = ocrDetect.hadUnrecoverableException;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (args.mScanListener != null) {
                        if (hadUnrecoverableException) {
                            args.mScanListener.onFatalError();
                        } else {
                            args.mScanListener.onPrediction(number, null, bitmapForOcrDetection, null, null, bitmapForObjectDetection, bitmapForScreenDetection, frameAddedTimeMs);
                        }
                    }
                    bitmapForOcrDetection.recycle();
                    bitmapForObjectDetection.recycle();
                    if (bitmapForScreenDetection != null) {
                        bitmapForScreenDetection.recycle();
                    }
                }
                catch (Error | Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void runModel() {
        Bitmap screenDetect;
        Bitmap objectDetect;
        Bitmap ocr;
        RunArguments args = this.getNextImage();
        if (args.mFrameBytes != null) {
            Bitmaps bitmaps = this.getBitmaps(args.mFrameBytes, args.mWidth, args.mHeight, args.mFormat, args.mSensorOrientation, args.mRoiCenterYRatio, args.mIsOcr);
            ocr = bitmaps.ocr;
            objectDetect = bitmaps.objectDetect;
            screenDetect = bitmaps.screenDetect;
        } else if (args.mBitmap != null) {
            ocr = this.cropBitmapForOCR(args.mBitmap);
            objectDetect = args.mBitmap;
            screenDetect = null;
        } else {
            objectDetect = Bitmap.createBitmap((int)480, (int)480, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(objectDetect);
            Paint paint = new Paint();
            paint.setColor(-7829368);
            canvas.drawRect(0.0f, 0.0f, 480.0f, 480.0f, paint);
            ocr = this.cropBitmapForOCR(objectDetect);
            screenDetect = null;
        }
        if (args.mIsOcr) {
            this.runOcrModel(ocr, args, objectDetect, screenDetect, args.frameAddedTimeMs);
        } else {
            this.runObjectModel(objectDetect, args, screenDetect, args.frameAddedTimeMs);
        }
    }

    @NonNull
    protected Bitmap cropBitmapForOCR(@NonNull Bitmap objectDetect) {
        float width = objectDetect.getWidth();
        float height = width * 375.0f / 600.0f;
        if (height > (float)objectDetect.getHeight()) {
            height = objectDetect.getHeight();
            width = height / 375.0f * 600.0f;
        }
        float y = ((float)objectDetect.getHeight() - height) / 2.0f;
        float x = ((float)objectDetect.getWidth() - width) / 2.0f;
        return Bitmap.createBitmap((Bitmap)objectDetect, (int)((int)x), (int)((int)y), (int)((int)width), (int)((int)height));
    }

    @NonNull
    protected Bitmap cropBitmapForScreenDetection(@NonNull Bitmap fullScreen) {
        float width = fullScreen.getWidth();
        float height = width * 16.0f / 9.0f;
        if (height > (float)fullScreen.getHeight()) {
            height = fullScreen.getHeight();
            width = height / 16.0f * 9.0f;
        }
        float y = ((float)fullScreen.getHeight() - height) / 2.0f;
        float x = ((float)fullScreen.getWidth() - width) / 2.0f;
        return Bitmap.createBitmap((Bitmap)fullScreen, (int)((int)x), (int)((int)y), (int)((int)width), (int)((int)height));
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.runModel();
                }
            }
            catch (Error | Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected static class Bitmaps {
        @NonNull
        public final Bitmap ocr;
        @NonNull
        public final Bitmap objectDetect;
        @NonNull
        public final Bitmap screenDetect;
        @NonNull
        public final Bitmap fullScreen;

        Bitmaps(@NonNull Bitmap ocr, @NonNull Bitmap objectDetect, @NonNull Bitmap screenDetect, @NonNull Bitmap fullScreen) {
            this.ocr = ocr;
            this.objectDetect = objectDetect;
            this.screenDetect = screenDetect;
            this.fullScreen = fullScreen;
        }
    }

    protected static class RunArguments {
        @Nullable
        public final byte[] mFrameBytes;
        @Nullable
        public final Bitmap mBitmap;
        @Nullable
        final OnScanListener mScanListener;
        @Nullable
        final OnObjectListener mObjectListener;
        @Nullable
        public final OnUXModelListener mUXModelListener;
        @NonNull
        public final Context mContext;
        public final int mWidth;
        public final int mHeight;
        public final int mFormat;
        public final int mSensorOrientation;
        public final float mRoiCenterYRatio;
        public final boolean mIsOcr;
        @Nullable
        final File mObjectDetectFile;
        public final boolean mRunAdditionalOcr;
        public final boolean mRunUXModel;
        public final long frameAddedTimeMs;

        RunArguments(@Nullable byte[] frameBytes, int width, int height, int format, int sensorOrientation, @Nullable OnScanListener scanListener, @NonNull Context context, float roiCenterYRatio) {
            this.mFrameBytes = frameBytes;
            this.mBitmap = null;
            this.mWidth = width;
            this.mHeight = height;
            this.mFormat = format;
            this.mScanListener = scanListener;
            this.mContext = context;
            this.mSensorOrientation = sensorOrientation;
            this.mRoiCenterYRatio = roiCenterYRatio;
            this.mIsOcr = true;
            this.mObjectListener = null;
            this.mObjectDetectFile = null;
            this.mRunAdditionalOcr = false;
            this.mRunUXModel = false;
            this.mUXModelListener = null;
            this.frameAddedTimeMs = System.currentTimeMillis();
        }

        RunArguments(@Nullable byte[] frameBytes, int width, int height, int format, int sensorOrientation, @Nullable OnObjectListener objectListener, @NonNull Context context, float roiCenterYRatio, @Nullable File objectDetectFile) {
            this.mFrameBytes = frameBytes;
            this.mBitmap = null;
            this.mWidth = width;
            this.mHeight = height;
            this.mFormat = format;
            this.mScanListener = null;
            this.mUXModelListener = null;
            this.mContext = context;
            this.mSensorOrientation = sensorOrientation;
            this.mRoiCenterYRatio = roiCenterYRatio;
            this.mIsOcr = false;
            this.mObjectListener = objectListener;
            this.mObjectDetectFile = objectDetectFile;
            this.mRunAdditionalOcr = false;
            this.mRunUXModel = false;
            this.frameAddedTimeMs = System.currentTimeMillis();
        }

        public RunArguments(@NonNull byte[] frameBytes, int width, int height, int format, int sensorOrientation, @Nullable OnUXModelListener uxListener, @NonNull Context context, float roiCenterYRatio, @Nullable File objectDetectFile, boolean runOcrModel) {
            this(frameBytes, width, height, format, sensorOrientation, uxListener, context, roiCenterYRatio, objectDetectFile, runOcrModel, true);
        }

        public RunArguments(@NonNull byte[] frameBytes, int width, int height, int format, int sensorOrientation, @Nullable OnUXModelListener uxListener, @NonNull Context context, float roiCenterYRatio, @Nullable File objectDetectFile, boolean runOcrModel, boolean runUXModel) {
            this.mFrameBytes = frameBytes;
            this.mBitmap = null;
            this.mWidth = width;
            this.mHeight = height;
            this.mFormat = format;
            this.mScanListener = null;
            this.mContext = context;
            this.mSensorOrientation = sensorOrientation;
            this.mRoiCenterYRatio = roiCenterYRatio;
            this.mIsOcr = false;
            this.mObjectListener = null;
            this.mObjectDetectFile = objectDetectFile;
            this.mRunAdditionalOcr = runOcrModel;
            this.mRunUXModel = runUXModel;
            this.mUXModelListener = uxListener;
            this.frameAddedTimeMs = System.currentTimeMillis();
        }

        @VisibleForTesting
        RunArguments(@Nullable Bitmap bitmap, @Nullable OnScanListener scanListener, @NotNull Context context) {
            this.mFrameBytes = null;
            this.mBitmap = bitmap;
            this.mWidth = bitmap == null ? 0 : bitmap.getWidth();
            this.mHeight = bitmap == null ? 0 : bitmap.getHeight();
            this.mFormat = 0;
            this.mScanListener = scanListener;
            this.mContext = context;
            this.mSensorOrientation = 0;
            this.mRoiCenterYRatio = 0.0f;
            this.mIsOcr = true;
            this.mObjectListener = null;
            this.mObjectDetectFile = null;
            this.mRunAdditionalOcr = false;
            this.mRunUXModel = false;
            this.mUXModelListener = null;
            this.frameAddedTimeMs = System.currentTimeMillis();
        }

        @VisibleForTesting
        RunArguments(@Nullable Bitmap bitmap, @Nullable OnObjectListener objectListener, @NonNull Context context, @Nullable File objectDetectFile) {
            this.mFrameBytes = null;
            this.mBitmap = bitmap;
            this.mWidth = bitmap == null ? 0 : bitmap.getWidth();
            this.mHeight = bitmap == null ? 0 : bitmap.getHeight();
            this.mFormat = 0;
            this.mScanListener = null;
            this.mContext = context;
            this.mSensorOrientation = 0;
            this.mRoiCenterYRatio = 0.0f;
            this.mIsOcr = false;
            this.mObjectListener = objectListener;
            this.mObjectDetectFile = objectDetectFile;
            this.mRunAdditionalOcr = false;
            this.mRunUXModel = false;
            this.mUXModelListener = null;
            this.frameAddedTimeMs = System.currentTimeMillis();
        }
    }
}

