/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

public class UXModelResult {
    public final float noCardScore;
    public final float panSideScore;
    public final float noPanSideScore;
    private float[] modelOutput;
    private float maxScore;
    private UXModelEnum uxModelEnum;

    public UXModelResult(float[] modelOutput) {
        this.noCardScore = modelOutput[0];
        this.panSideScore = modelOutput[1];
        this.noPanSideScore = modelOutput[2];
        this.modelOutput = modelOutput;
        this.calculateResult();
    }

    public UXModelEnum getResult() {
        return this.uxModelEnum;
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    private void calculateResult() {
        int maxIndex = -1;
        float maxValue = -1.0f;
        for (int i = 0; i < this.modelOutput.length; ++i) {
            if (!(this.modelOutput[i] > maxValue)) continue;
            maxValue = this.modelOutput[i];
            maxIndex = i;
        }
        this.maxScore = maxValue;
        if (maxIndex == 0) {
            this.uxModelEnum = UXModelEnum.NO_PAN_SIDE;
        } else if (maxIndex == 1) {
            this.uxModelEnum = UXModelEnum.NO_CARD;
        } else if (maxIndex == 2) {
            this.uxModelEnum = UXModelEnum.PAN_SIDE;
        } else {
            throw new EnumConstantNotPresentException(UXModelEnum.class, "Unexpected enum value " + maxIndex);
        }
    }

    public static enum UXModelEnum {
        NO_PAN_SIDE,
        NO_CARD,
        PAN_SIDE;

    }
}

