/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import com.getbouncer.cardscan.base.CreditCardUtils;
import com.getbouncer.cardscan.base.SSDOcrModel;
import com.getbouncer.cardscan.base.ssd.ArrUtils;
import com.getbouncer.cardscan.base.ssd.DetectedOcrBox;
import com.getbouncer.cardscan.base.ssd.OcrPriorsGen;
import com.getbouncer.cardscan.base.ssd.PredictionAPI;
import com.getbouncer.cardscan.base.ssd.Result;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SSDOcrDetect {
    private static SSDOcrModel ssdOcrModel = null;
    private static float[][] priors = null;
    public List<DetectedOcrBox> objectBoxes = new ArrayList<DetectedOcrBox>();
    public boolean hadUnrecoverableException = false;
    public static boolean USE_GPU = false;

    static boolean isInit() {
        return ssdOcrModel != null;
    }

    private String ssdOutputToPredictions(Bitmap image, boolean strict) {
        ArrUtils arrUtils = new ArrUtils();
        float[][] k_boxes = arrUtils.rearrangeOCRArray(SSDOcrDetect.ssdOcrModel.outputLocations, SSDOcrModel.featureMapSizes, 3, 4);
        k_boxes = arrUtils.reshape(k_boxes, 3420, 4);
        k_boxes = arrUtils.convertLocationsToBoxes(k_boxes, priors, 0.1f, 0.2f);
        k_boxes = arrUtils.centerFormToCornerForm(k_boxes);
        float[][] k_scores = arrUtils.rearrangeOCRArray(SSDOcrDetect.ssdOcrModel.outputClasses, SSDOcrModel.featureMapSizes, 3, 11);
        k_scores = arrUtils.reshape(k_scores, 3420, 11);
        k_scores = arrUtils.softmax2D(k_scores);
        PredictionAPI predAPI = new PredictionAPI();
        Result result = predAPI.predictionAPI(k_scores, k_boxes, 0.5f, 0.5f, 50, 20);
        if (result.pickedBoxProbs.size() != 0 && result.pickedLabels.size() != 0) {
            for (int i = 0; i < result.pickedBoxProbs.size(); ++i) {
                DetectedOcrBox ocrBox = new DetectedOcrBox(result.pickedBoxes.get(i)[0], result.pickedBoxes.get(i)[1], result.pickedBoxes.get(i)[2], result.pickedBoxes.get(i)[3], result.pickedBoxProbs.get(i).floatValue(), image.getWidth(), image.getHeight(), result.pickedLabels.get(i));
                this.objectBoxes.add(ocrBox);
            }
        }
        String numberOCR = "";
        Collections.sort(this.objectBoxes);
        StringBuilder num = new StringBuilder();
        for (DetectedOcrBox box : this.objectBoxes) {
            if (box.label == 10) {
                box.label = 0;
            }
            num.append(box.label);
        }
        if (CreditCardUtils.isValidCardNumber(num.toString())) {
            numberOCR = num.toString();
            Log.d((String)"OCR Number passed", (String)numberOCR);
        } else {
            Log.d((String)"OCR Number failed", (String)num.toString());
            numberOCR = strict ? null : num.toString();
        }
        return numberOCR;
    }

    private String runModel(Bitmap image) {
        return this.runModel(image, true);
    }

    private String runModel(Bitmap image, boolean strict) {
        long startTime = SystemClock.uptimeMillis();
        ssdOcrModel.classifyFrame(image);
        Log.d((String)"Before SSD Post Process", (String)String.valueOf(SystemClock.uptimeMillis() - startTime));
        String number = this.ssdOutputToPredictions(image, strict);
        Log.d((String)"After SSD Post Process", (String)String.valueOf(SystemClock.uptimeMillis() - startTime));
        return number;
    }

    private static <T> T getKeyByMaxValue(Map<T, ? extends Comparable> map) {
        Map.Entry<T, Comparable> maxEntry = null;
        for (Map.Entry<T, Comparable> entry : map.entrySet()) {
            if (maxEntry != null && entry.getValue().compareTo(maxEntry.getValue()) <= 0) continue;
            maxEntry = entry;
        }
        if (maxEntry != null) {
            return (T)maxEntry.getKey();
        }
        return null;
    }

    public static void runInCompletionLoop(final List<Bitmap> frames, final Context context, final OnDetectListener detection) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                final HashMap<String, Integer> results = new HashMap<String, Integer>();
                for (Bitmap ocrFrame : frames) {
                    SSDOcrDetect ocrDetect;
                    String prediction;
                    if (ocrFrame == null || (prediction = (ocrDetect = new SSDOcrDetect()).predict(ocrFrame, context)) == null) continue;
                    Integer count = (Integer)results.get(prediction);
                    if (count != null) {
                        results.put(prediction, count + 1);
                        continue;
                    }
                    results.put(prediction, 1);
                }
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (detection != null) {
                            detection.complete((String)SSDOcrDetect.getKeyByMaxValue(results));
                        }
                    }
                });
            }
        }).start();
    }

    public synchronized String predict(Bitmap image, Context context) {
        int NUM_THREADS = 4;
        try {
            boolean createdNewModel = false;
            try {
                if (ssdOcrModel == null) {
                    ssdOcrModel = new SSDOcrModel(context);
                    ssdOcrModel.setNumThreads(4);
                    if (priors == null) {
                        priors = OcrPriorsGen.combinePriors();
                    }
                }
            }
            catch (Error | Exception e) {
                Log.e((String)"SSD", (String)"Couldn't load ssd", (Throwable)e);
            }
            try {
                return this.runModel(image);
            }
            catch (Error | Exception e) {
                Log.i((String)"OCR", (String)"runModel exception, retry object detection", (Throwable)e);
                ssdOcrModel = new SSDOcrModel(context);
                return this.runModel(image);
            }
        }
        catch (Error | Exception e) {
            Log.e((String)"OCR", (String)"unrecoverable exception on ObjectDetect", (Throwable)e);
            this.hadUnrecoverableException = true;
            return null;
        }
    }

    public synchronized String predict(Bitmap image, Context context, boolean strict) {
        int NUM_THREADS = 4;
        try {
            boolean createdNewModel = false;
            try {
                if (ssdOcrModel == null) {
                    ssdOcrModel = new SSDOcrModel(context);
                    ssdOcrModel.setNumThreads(4);
                    if (priors == null) {
                        priors = OcrPriorsGen.combinePriors();
                    }
                }
            }
            catch (Error | Exception e) {
                Log.e((String)"SSD", (String)"Couldn't load ssd", (Throwable)e);
            }
            try {
                return this.runModel(image, strict);
            }
            catch (Error | Exception e) {
                Log.i((String)"ObjectDetect", (String)"runModel exception, retry object detection", (Throwable)e);
                ssdOcrModel = new SSDOcrModel(context);
                return this.runModel(image, strict);
            }
        }
        catch (Error | Exception e) {
            Log.e((String)"ObjectDetect", (String)"unrecoverable exception on ObjectDetect", (Throwable)e);
            this.hadUnrecoverableException = true;
            return null;
        }
    }

    public static interface OnDetectListener {
        public void complete(String var1);
    }
}

