/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base.ssd;

import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;

public class ArrUtils {
    public float[][] reshape(float[][] nums, int r, int c) {
        int totalElements = nums.length * nums[0].length;
        if (totalElements != r * c || totalElements % r != 0) {
            return nums;
        }
        float[][] result = new float[r][c];
        int newR = 0;
        int newC = 0;
        for (int i = 0; i < nums.length; ++i) {
            for (int j = 0; j < nums[i].length; ++j) {
                result[newR][newC] = nums[i][j];
                if (++newC != c) continue;
                newC = 0;
                ++newR;
            }
        }
        return result;
    }

    public float[][] rearrangeOCRArray(float[][] locations, Hashtable<String, Integer> featureMapSizes, int noOfPriors, int locationsPerPrior) {
        int totalLocationsForAllLayers = featureMapSizes.get("layerOneWidth") * featureMapSizes.get("layerOneHeight") * noOfPriors * locationsPerPrior + featureMapSizes.get("layerTwoWidth") * featureMapSizes.get("layerTwoHeight") * noOfPriors * locationsPerPrior;
        float[][] rearranged = new float[1][totalLocationsForAllLayers];
        Integer[] featureMapHeights = new Integer[]{featureMapSizes.get("layerOneHeight"), featureMapSizes.get("layerTwoHeight")};
        Integer[] featureMapWidths = new Integer[]{featureMapSizes.get("layerOneWidth"), featureMapSizes.get("layerTwoWidth")};
        Iterator<Integer> heightIterator = Arrays.asList(featureMapHeights).iterator();
        Iterator<Integer> widthIterator = Arrays.asList(featureMapWidths).iterator();
        int offset = 0;
        while (heightIterator.hasNext() && widthIterator.hasNext()) {
            int height = heightIterator.next();
            int width = widthIterator.next();
            int totalNumberOfLocationsForThisLayer = height * width * noOfPriors * locationsPerPrior;
            int stepsForLoop = height - 1;
            int j = 0;
            int i = 0;
            int step = 0;
            while (i < totalNumberOfLocationsForThisLayer) {
                while (step < height) {
                    for (j = step; j < totalNumberOfLocationsForThisLayer - stepsForLoop + step; j += height) {
                        rearranged[0][offset + i] = locations[0][offset + j];
                        ++i;
                    }
                    ++step;
                }
                offset += totalNumberOfLocationsForThisLayer;
            }
        }
        return rearranged;
    }

    public float[][] rearrangeLayer(float[][] locations, int steps, int noOfPriors, int locationsPerPrior) {
        int totalNumberOfLocationsForAllPriors = steps * steps * noOfPriors * locationsPerPrior;
        float[][] rearranged = new float[1][totalNumberOfLocationsForAllPriors];
        int stepsForLoop = steps - 1;
        int i = 0;
        int j = 0;
        int step = 0;
        while (i < totalNumberOfLocationsForAllPriors) {
            while (step < steps) {
                for (j = step; j < totalNumberOfLocationsForAllPriors - stepsForLoop + step; j += steps) {
                    rearranged[0][i] = locations[0][j];
                    ++i;
                }
                ++step;
            }
        }
        return rearranged;
    }

    public float[][] rearrangeArray(float[][] locations, int[] featureMapSizes, int noOfPriors, int locationsPerPrior) {
        int totalLocationsForAllLayers = 0;
        for (int size : featureMapSizes) {
            totalLocationsForAllLayers += size * size * noOfPriors * locationsPerPrior;
        }
        float[][] rearranged = new float[1][totalLocationsForAllLayers];
        int offset = 0;
        for (int steps : featureMapSizes) {
            int totalNumberOfLocationsForThisLayer = steps * steps * noOfPriors * locationsPerPrior;
            int stepsForLoop = steps - 1;
            int j = 0;
            int i = 0;
            int step = 0;
            while (i < totalNumberOfLocationsForThisLayer) {
                while (step < steps) {
                    for (j = step; j < totalNumberOfLocationsForThisLayer - stepsForLoop + step; j += steps) {
                        rearranged[0][offset + i] = locations[0][offset + j];
                        ++i;
                    }
                    ++step;
                }
                offset += totalNumberOfLocationsForThisLayer;
            }
        }
        return rearranged;
    }

    public float[][] convertLocationsToBoxes(float[][] locations, float[][] priors, float centerVariance, float sizeVariance) {
        float[][] boxes = new float[locations.length][locations[0].length];
        for (int i = 0; i < locations.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                boxes[i][j] = locations[i][j] * centerVariance * priors[i][j + 2] + priors[i][j];
                boxes[i][j + 2] = (float)(Math.exp(locations[i][j + 2] * sizeVariance) * (double)priors[i][j + 2]);
            }
        }
        return boxes;
    }

    public float[][] centerFormToCornerForm(float[][] locations) {
        float[][] boxes = new float[locations.length][locations[0].length];
        for (int i = 0; i < locations.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                boxes[i][j] = locations[i][j] - locations[i][j + 2] / 2.0f;
                boxes[i][j + 2] = locations[i][j] + locations[i][j + 2] / 2.0f;
            }
        }
        return boxes;
    }

    public void print(float[][] arr) {
        Log.d((String)"ArrUtils for float[][]", (String)Arrays.toString((Object[])arr));
    }

    public static void printArrayList(ArrayList<float[]> alist) {
        Log.d((String)"ArrUtils for ArrayList", (String)Arrays.deepToString(alist.toArray()));
    }

    public static void print(float[] arr) {
        Log.d((String)"ArrUtils for float[]", (String)Arrays.toString(arr));
    }

    public static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    public float[][] softmax2D(float[][] scores) {
        float[][] normalizedScores = new float[scores.length][scores[0].length];
        for (int i = 0; i < scores.length; ++i) {
            int j;
            float rowSum = 0.0f;
            for (j = 0; j < scores[0].length; ++j) {
                rowSum = (float)((double)rowSum + Math.exp(scores[i][j]));
            }
            for (j = 0; j < scores[0].length; ++j) {
                normalizedScores[i][j] = (float)(Math.exp(scores[i][j]) / (double)rowSum);
            }
        }
        return normalizedScores;
    }
}

