/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.ImageFormat;
import android.graphics.RectF;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.idling.CountingIdlingResource;
import com.getbouncer.cardscan.base.Api;
import com.getbouncer.cardscan.base.CameraThread;
import com.getbouncer.cardscan.base.CreditCardUtils;
import com.getbouncer.cardscan.base.DetectedBox;
import com.getbouncer.cardscan.base.Expiry;
import com.getbouncer.cardscan.base.IdleResourceManager;
import com.getbouncer.cardscan.base.MachineLearningThread;
import com.getbouncer.cardscan.base.OnCameraOpenListener;
import com.getbouncer.cardscan.base.OnObjectListener;
import com.getbouncer.cardscan.base.OnScanListener;
import com.getbouncer.cardscan.base.Overlay;
import com.getbouncer.cardscan.base.R;
import com.getbouncer.cardscan.base.ScanStats;
import com.getbouncer.cardscan.base.TestingImageReaderInternal;
import com.getbouncer.cardscan.base.ssd.DetectedSSDBox;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;

public abstract class ScanBaseActivity
extends Activity
implements Camera.PreviewCallback,
View.OnClickListener,
OnScanListener,
OnObjectListener,
OnCameraOpenListener {
    private Camera mCamera = null;
    private CameraPreview cameraPreview = null;
    private static MachineLearningThread machineLearningThread = null;
    private Semaphore mMachineLearningSemaphore = new Semaphore(1);
    private int mRotation;
    private boolean mSentResponse = false;
    private boolean mIsActivityActive = false;
    private HashMap<String, Integer> numberResults = new HashMap();
    private HashMap<Expiry, Integer> expiryResults = new HashMap();
    private long firstResultMs = 0L;
    private int mFlashlightId;
    private int mCardNumberId;
    private int mExpiryId;
    private int mTextureId;
    private int mEnterCardManuallyId;
    private float mRoiCenterYRatio;
    private boolean mIsOcr = true;
    private boolean mDelayShowingExpiration = true;
    private byte[] machineLearningFrame = null;
    protected ScanStats scanStats;
    public static String IS_OCR = "is_ocr";
    public static String RESULT_FATAL_ERROR = "result_fatal_error";
    public static String RESULT_CAMERA_OPEN_ERROR = "result_camera_open_error";
    public static String RESULT_ENTER_CARD_MANUALLY_REASON = "result_enter_card_manually";
    public static String DELAY_SHOWING_EXPIRATION = "delay_showing_expiration";
    public boolean wasPermissionDenied = false;
    public String denyPermissionTitle;
    public String denyPermissionMessage;
    public String denyPermissionButton;
    public static TestingImageReaderInternal sTestingImageReader = null;
    private TestingImageReaderInternal mTestingImageReader = null;
    protected CountingIdlingResource mScanningIdleResource = null;
    public long mPredictionStartMs = 0L;
    public boolean mIsPermissionCheckDone = false;
    protected boolean mShowNumberAndExpiryAsScanning = true;
    protected boolean postToMachineLearningThread = true;
    protected File objectDetectFile;
    public long errorCorrectionDurationMs = 1500L;
    public static int MIN_IMAGE_EDGE = 600;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRequestedOrientation(1);
        this.denyPermissionTitle = this.getString(R.string.card_scan_deny_permission_title);
        this.denyPermissionMessage = this.getString(R.string.card_scan_deny_permission_message);
        this.denyPermissionButton = this.getString(R.string.card_scan_deny_permission_button);
        this.mTestingImageReader = sTestingImageReader;
        sTestingImageReader = null;
        this.scanStats = new ScanStats();
        this.mIsOcr = this.getIntent().getBooleanExtra(IS_OCR, true);
        this.mDelayShowingExpiration = this.getIntent().getBooleanExtra(DELAY_SHOWING_EXPIRATION, true);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (grantResults[0] == 0) {
            this.mIsPermissionCheckDone = true;
        } else {
            this.wasPermissionDenied = true;
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setMessage((CharSequence)this.denyPermissionMessage).setTitle((CharSequence)this.denyPermissionTitle);
            builder.setPositiveButton((CharSequence)this.denyPermissionButton, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                }
            });
            AlertDialog dialog = builder.create();
            dialog.show();
        }
    }

    private void setCameraParameters(Camera camera, Camera.Parameters parameters) {
        try {
            camera.setParameters(parameters);
        }
        catch (Error | Exception e) {
            e.printStackTrace();
        }
    }

    private void setCameraPreviewFrame() {
        int format = 17;
        Camera.Parameters parameters = this.mCamera.getParameters();
        parameters.setPreviewFormat(format);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getRealMetrics(displayMetrics);
        int displayWidth = Math.max(displayMetrics.heightPixels, displayMetrics.widthPixels);
        int displayHeight = Math.min(displayMetrics.heightPixels, displayMetrics.widthPixels);
        int height = MIN_IMAGE_EDGE;
        int width = displayWidth * height / displayHeight;
        Camera.Size previewSize = this.getOptimalPreviewSize(parameters.getSupportedPreviewSizes(), width, height);
        if (previewSize != null) {
            parameters.setPreviewSize(previewSize.width, previewSize.height);
        }
        this.setCameraParameters(this.mCamera, parameters);
    }

    @Override
    public void onCameraOpen(@Nullable Camera camera) {
        if (camera == null) {
            Intent intent = new Intent();
            intent.putExtra(RESULT_CAMERA_OPEN_ERROR, true);
            this.setResult(0, intent);
            if (this.cameraPreview != null) {
                this.cameraPreview.getHolder().removeCallback((SurfaceHolder.Callback)this.cameraPreview);
            }
            this.finish();
        } else if (!this.mIsActivityActive) {
            camera.release();
            if (this.cameraPreview != null) {
                this.cameraPreview.getHolder().removeCallback((SurfaceHolder.Callback)this.cameraPreview);
            }
        } else {
            this.mCamera = camera;
            this.setCameraDisplayOrientation(this, 0);
            this.setCameraPreviewFrame();
            this.cameraPreview = new CameraPreview((Context)this, this);
            FrameLayout preview = (FrameLayout)this.findViewById(this.mTextureId);
            preview.removeAllViews();
            preview.addView((View)this.cameraPreview);
        }
    }

    @Nullable
    private Camera.Size getOptimalPreviewSize(List<Camera.Size> sizes, int w, int h) {
        double ASPECT_TOLERANCE = 0.2;
        double targetRatio = (double)w / (double)h;
        if (sizes == null) {
            return null;
        }
        Camera.Size optimalSize = null;
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            if (!(Math.abs(ratio - targetRatio) <= 0.2) || size.height < h) continue;
            optimalSize = size;
        }
        if (optimalSize == null) {
            double minDiffRatio = Double.MAX_VALUE;
            for (Camera.Size size : sizes) {
                double ratio = (double)size.width / (double)size.height;
                double ratioDiff = Math.abs(ratio - targetRatio);
                if (size.height < h || !(ratioDiff <= minDiffRatio)) continue;
                optimalSize = size;
                minDiffRatio = ratioDiff;
            }
        }
        return optimalSize;
    }

    protected void startCamera() {
        this.numberResults = new HashMap();
        this.expiryResults = new HashMap();
        this.firstResultMs = 0L;
        try {
            if (this.mIsPermissionCheckDone) {
                this.mScanningIdleResource = IdleResourceManager.scanningIdleResource;
                IdleResourceManager.scanningIdleResource = null;
                if (this.mScanningIdleResource != null) {
                    this.mScanningIdleResource.increment();
                }
                CameraThread thread = new CameraThread();
                thread.start();
                thread.startCamera(this);
            }
        }
        catch (Exception e) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setMessage((CharSequence)"Another app is using the camera").setTitle((CharSequence)"Can't open camera");
            builder.setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    ScanBaseActivity.this.finish();
                }
            });
            AlertDialog dialog = builder.create();
            dialog.show();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
            this.mCamera.setPreviewCallbackWithBuffer(null);
            this.mCamera.release();
            this.mCamera = null;
        }
        if (this.cameraPreview != null) {
            this.cameraPreview.getHolder().removeCallback((SurfaceHolder.Callback)this.cameraPreview);
            this.cameraPreview = null;
        }
        this.mIsActivityActive = false;
    }

    protected void onResume() {
        super.onResume();
        this.mIsActivityActive = true;
        this.scanStats = new ScanStats();
        this.firstResultMs = 0L;
        this.numberResults = new HashMap();
        this.expiryResults = new HashMap();
        this.mSentResponse = false;
        if (this.findViewById(this.mCardNumberId) != null) {
            this.findViewById(this.mCardNumberId).setVisibility(4);
        }
        if (this.findViewById(this.mExpiryId) != null) {
            this.findViewById(this.mExpiryId).setVisibility(4);
        }
        this.startCamera();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public void setViewIds(int flashlightId, int cardRectangleId, int overlayId, int textureId, int cardNumberId, int expiryId) {
        this.setViewIds(flashlightId, cardRectangleId, overlayId, textureId, cardNumberId, expiryId, -1);
    }

    public void setViewIds(int flashlightId, int cardRectangleId, int overlayId, int textureId, int cardNumberId, int expiryId, int enterCardManuallyId) {
        this.mFlashlightId = flashlightId;
        this.mTextureId = textureId;
        this.mCardNumberId = cardNumberId;
        this.mExpiryId = expiryId;
        this.mEnterCardManuallyId = enterCardManuallyId;
        View flashlight = this.findViewById(flashlightId);
        if (flashlight != null) {
            flashlight.setOnClickListener((View.OnClickListener)this);
        }
        this.findViewById(cardRectangleId).getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)new MyGlobalListenerClass(cardRectangleId, overlayId));
    }

    public void setCameraDisplayOrientation(Activity activity, int cameraId) {
        int result;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        this.mCamera.setDisplayOrientation(result);
        this.mRotation = result;
    }

    public static void warmUp(Context context) {
        ScanBaseActivity.getMachineLearningThread().warmUp(context);
    }

    public static MachineLearningThread getMachineLearningThread() {
        if (machineLearningThread == null) {
            machineLearningThread = new MachineLearningThread();
            new Thread(machineLearningThread).start();
        }
        return machineLearningThread;
    }

    public void onPreviewFrame(byte[] bytes, Camera camera) {
        if (this.postToMachineLearningThread && this.mMachineLearningSemaphore.tryAcquire()) {
            if (this.machineLearningFrame != null) {
                this.mCamera.addCallbackBuffer(this.machineLearningFrame);
            }
            this.machineLearningFrame = bytes;
            this.scanStats.incrementScans();
            MachineLearningThread mlThread = ScanBaseActivity.getMachineLearningThread();
            Camera.Parameters parameters = camera.getParameters();
            int width = parameters.getPreviewSize().width;
            int height = parameters.getPreviewSize().height;
            int format = parameters.getPreviewFormat();
            this.mPredictionStartMs = SystemClock.uptimeMillis();
            if (this.mTestingImageReader == null) {
                if (this.mIsOcr) {
                    mlThread.post(bytes, width, height, format, this.mRotation, this, this.getApplicationContext(), this.mRoiCenterYRatio);
                } else {
                    mlThread.post(bytes, width, height, format, this.mRotation, this, this.getApplicationContext(), this.mRoiCenterYRatio, this.objectDetectFile);
                }
            } else {
                Bitmap bm = this.mTestingImageReader.nextImage();
                if (this.mIsOcr) {
                    mlThread.post(bm, this, this.getApplicationContext());
                } else {
                    mlThread.post(bm, this, this.getApplicationContext(), this.objectDetectFile);
                }
                if (bm == null) {
                    this.mTestingImageReader = null;
                }
            }
        } else {
            this.mCamera.addCallbackBuffer(bytes);
        }
    }

    public void onClick(View view) {
        if (this.mEnterCardManuallyId == view.getId() && this.mEnterCardManuallyId != -1) {
            this.onEnterCardManuallyPressed();
        } else if (this.mCamera != null && this.mFlashlightId == view.getId()) {
            Camera.Parameters parameters = this.mCamera.getParameters();
            if ("torch".equals(parameters.getFlashMode())) {
                parameters.setFlashMode("off");
            } else {
                parameters.setFlashMode("torch");
            }
            this.setCameraParameters(this.mCamera, parameters);
            this.mCamera.startPreview();
        }
    }

    protected void onEnterCardManuallyPressed() {
        Intent intent = new Intent();
        intent.putExtra(RESULT_ENTER_CARD_MANUALLY_REASON, true);
        this.setResult(0, intent);
        this.finish();
    }

    public void onBackPressed() {
        if (!this.mSentResponse && this.mIsActivityActive) {
            this.scanStats.setSuccess(false);
            Api.scanStats((Context)this, this.scanStats);
            this.mSentResponse = true;
            Intent intent = new Intent();
            this.setResult(0, intent);
            this.finish();
            if (this.mScanningIdleResource != null) {
                this.mScanningIdleResource.decrement();
            }
        }
    }

    @VisibleForTesting(otherwise=2)
    public void incrementNumber(String number) {
        Integer currentValue = this.numberResults.get(number);
        if (currentValue == null) {
            currentValue = 0;
        }
        this.numberResults.put(number, currentValue + 1);
    }

    @VisibleForTesting(otherwise=2)
    public void incrementExpiry(Expiry expiry) {
        Integer currentValue = this.expiryResults.get(expiry);
        if (currentValue == null) {
            currentValue = 0;
        }
        this.expiryResults.put(expiry, currentValue + 1);
    }

    @VisibleForTesting(otherwise=2)
    public String getNumberResult() {
        String result = null;
        int maxValue = 0;
        for (String number : this.numberResults.keySet()) {
            int value = 0;
            Integer count = this.numberResults.get(number);
            if (count != null) {
                value = count;
            }
            if (value <= maxValue) continue;
            result = number;
            maxValue = value;
        }
        return result;
    }

    @VisibleForTesting(otherwise=2)
    public Expiry getExpiryResult() {
        Expiry result = null;
        int maxValue = 0;
        for (Expiry expiry : this.expiryResults.keySet()) {
            int value = 0;
            Integer count = this.expiryResults.get(expiry);
            if (count != null) {
                value = count;
            }
            if (value <= maxValue) continue;
            result = expiry;
            maxValue = value;
        }
        return result;
    }

    private void setValueAnimated(TextView textView, String value) {
        if (textView.getVisibility() != 0) {
            textView.setVisibility(0);
            textView.setAlpha(0.0f);
            textView.animate().setDuration(400L).alpha(1.0f);
        }
        textView.setText((CharSequence)value);
    }

    protected abstract void onCardScanned(String var1, String var2, String var3);

    protected void setNumberAndExpiryAnimated(long duration) {
        boolean shouldShowExpiration;
        String numberResult = this.getNumberResult();
        Expiry expiryResult = this.getExpiryResult();
        TextView textView = (TextView)this.findViewById(this.mCardNumberId);
        this.setValueAnimated(textView, CreditCardUtils.formatNumberForDisplay(numberResult));
        boolean bl = shouldShowExpiration = !this.mDelayShowingExpiration || duration >= this.errorCorrectionDurationMs / 2L;
        if (expiryResult != null && shouldShowExpiration) {
            textView = (TextView)this.findViewById(this.mExpiryId);
            this.setValueAnimated(textView, expiryResult.format());
        }
    }

    @Override
    public void onFatalError() {
        Intent intent = new Intent();
        intent.putExtra(RESULT_FATAL_ERROR, true);
        this.setResult(0, intent);
        this.finish();
    }

    @Override
    public void onPrediction(String number, Expiry expiry, Bitmap bitmap, List<DetectedBox> digitBoxes, DetectedBox expiryBox, Bitmap bitmapForObjectDetection, Bitmap fullScreenBitmap) {
        if (!this.mSentResponse && this.mIsActivityActive) {
            if (number != null && this.firstResultMs == 0L) {
                this.firstResultMs = SystemClock.uptimeMillis();
            }
            if (number != null) {
                this.incrementNumber(number);
            }
            if (expiry != null) {
                this.incrementExpiry(expiry);
            }
            long duration = SystemClock.uptimeMillis() - this.firstResultMs;
            if (this.firstResultMs != 0L && this.mShowNumberAndExpiryAsScanning) {
                this.setNumberAndExpiryAnimated(duration);
            }
            if (this.firstResultMs != 0L && duration >= this.errorCorrectionDurationMs) {
                this.mSentResponse = true;
                String numberResult = this.getNumberResult();
                Expiry expiryResult = this.getExpiryResult();
                String month = null;
                String year = null;
                if (expiryResult != null) {
                    month = Integer.toString(expiryResult.month);
                    year = Integer.toString(expiryResult.year);
                }
                this.scanStats.setSuccess(true);
                Api.scanStats((Context)this, this.scanStats);
                this.onCardScanned(numberResult, month, year);
                if (this.mScanningIdleResource != null) {
                    this.mScanningIdleResource.decrement();
                }
            }
        }
        this.mMachineLearningSemaphore.release();
    }

    @Override
    public void onObjectFatalError() {
        Log.d((String)"ScanBaseActivity", (String)"onObjectFatalError for object detection");
    }

    @Override
    public void onPrediction(Bitmap bm, List<DetectedSSDBox> boxes, int imageWidth, int imageHeight, Bitmap fullScreenBitmap) {
        if (this.mSentResponse || this.mIsActivityActive) {
            // empty if block
        }
        this.mMachineLearningSemaphore.release();
    }

    public class CameraPreview
    extends SurfaceView
    implements Camera.AutoFocusCallback,
    SurfaceHolder.Callback {
        private SurfaceHolder mHolder;
        private Camera.PreviewCallback mPreviewCallback;

        public CameraPreview(Context context, Camera.PreviewCallback previewCallback) {
            super(context);
            this.mPreviewCallback = previewCallback;
            this.mHolder = this.getHolder();
            this.mHolder.addCallback((SurfaceHolder.Callback)this);
            Camera.Parameters params = ScanBaseActivity.this.mCamera.getParameters();
            List focusModes = params.getSupportedFocusModes();
            if (focusModes.contains("continuous-picture")) {
                params.setFocusMode("continuous-picture");
            } else if (focusModes.contains("continuous-video")) {
                params.setFocusMode("continuous-video");
            }
            params.setRecordingHint(true);
            ScanBaseActivity.this.setCameraParameters(ScanBaseActivity.this.mCamera, params);
        }

        public void onAutoFocus(boolean success, Camera camera) {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            try {
                ScanBaseActivity.this.mCamera.setPreviewDisplay(holder);
                ScanBaseActivity.this.mCamera.startPreview();
            }
            catch (IOException e) {
                Log.d((String)"CameraCaptureActivity", (String)("Error setting camera preview: " + e.getMessage()));
            }
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
            if (this.mHolder.getSurface() == null) {
                return;
            }
            try {
                ScanBaseActivity.this.mCamera.stopPreview();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ScanBaseActivity.this.mCamera.setPreviewDisplay(this.mHolder);
                int bufSize = w * h * ImageFormat.getBitsPerPixel((int)format) / 8;
                for (int i = 0; i < 3; ++i) {
                    ScanBaseActivity.this.mCamera.addCallbackBuffer(new byte[bufSize]);
                }
                ScanBaseActivity.this.mCamera.setPreviewCallbackWithBuffer(this.mPreviewCallback);
                ScanBaseActivity.this.mCamera.startPreview();
            }
            catch (Exception e) {
                Log.d((String)"CameraCaptureActivity", (String)("Error starting camera preview: " + e.getMessage()));
            }
        }
    }

    class MyGlobalListenerClass
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private final int cardRectangleId;
        private final int overlayId;

        MyGlobalListenerClass(int cardRectangleId, int overlayId) {
            this.cardRectangleId = cardRectangleId;
            this.overlayId = overlayId;
        }

        public void onGlobalLayout() {
            View view = ScanBaseActivity.this.findViewById(this.cardRectangleId);
            int radius = (int)(11.0f * Resources.getSystem().getDisplayMetrics().density);
            RectF rect = new RectF((float)view.getLeft(), (float)view.getTop(), (float)view.getRight(), (float)view.getBottom());
            Overlay overlay = (Overlay)ScanBaseActivity.this.findViewById(this.overlayId);
            overlay.setRect(rect, radius);
            ScanBaseActivity.this.mRoiCenterYRatio = ((float)view.getTop() + (float)view.getHeight() * 0.5f) / (float)overlay.getHeight();
        }
    }
}

