/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.Context;
import android.util.Log;
import com.getbouncer.cardscan.base.ImageClassifier;
import com.getbouncer.cardscan.base.ModelFactory;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

class SSDOcrModel
extends ImageClassifier {
    private static final float IMAGE_MEAN = 127.5f;
    private static final float IMAGE_STD = 128.5f;
    private static final int CROP_SIZE_HEIGHT = 375;
    private static final int CROP_SIZE_WIDTH = 600;
    private static final int NUM_THREADS = 4;
    private boolean isModelQuantized;
    static final int NUM_OF_PRIORS = 3420;
    static final int NUM_OF_PRIORS_PER_ACTIVATION = 3;
    static final int NUM_OF_CLASSES = 11;
    static final int NUM_OF_COORDINATES = 4;
    static final int NUM_LOC = 13680;
    static final int NUM_CLASS = 37620;
    static final float PROB_THRESHOLD = 0.5f;
    static final float IOU_THRESHOLD = 0.5f;
    static final float CENTER_VARIANCE = 0.1f;
    static final float SIZE_VARIANCE = 0.2f;
    static final int CANDIDATE_SIZE = 50;
    static final int TOP_K = 20;
    static final Hashtable<String, Integer> featureMapSizes = new Hashtable();
    private int inputSize;
    private int[] intValues;
    float[][] outputLocations;
    float[][] outputClasses;
    private Map<Integer, Object> outputMap = new HashMap<Integer, Object>();

    public SSDOcrModel(Context context) throws IOException {
        super(context);
        featureMapSizes.put("layerOneWidth", 38);
        featureMapSizes.put("layerOneHeight", 24);
        featureMapSizes.put("layerTwoWidth", 19);
        featureMapSizes.put("layerTwoHeight", 12);
        this.outputLocations = new float[1][13680];
        this.outputClasses = new float[1][37620];
        this.outputMap.put(0, this.outputClasses);
        this.outputMap.put(1, this.outputLocations);
    }

    @Override
    protected MappedByteBuffer loadModelFile(Context context) throws IOException {
        return ModelFactory.getSharedInstance().loadSSDDetectModelFile(context);
    }

    @Override
    protected int getImageSizeX() {
        return 600;
    }

    @Override
    protected int getImageSizeY() {
        return 375;
    }

    @Override
    protected int getNumBytesPerChannel() {
        return 4;
    }

    @Override
    protected void addPixelValue(int pixelValue) {
        this.imgData.putFloat(((float)(pixelValue >> 16 & 0xFF) - 127.5f) / 128.5f);
        this.imgData.putFloat(((float)(pixelValue >> 8 & 0xFF) - 127.5f) / 128.5f);
        this.imgData.putFloat(((float)(pixelValue & 0xFF) - 127.5f) / 128.5f);
    }

    @Override
    protected void runInference() {
        Object[] inputArray = new Object[]{this.imgData};
        Log.d((String)"SSD Inference", (String)"Running inference on image ");
        this.tflite.runForMultipleInputsOutputs(inputArray, this.outputMap);
    }
}

