/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.getbouncer.cardscan.base.DetectedBox;
import com.getbouncer.cardscan.base.GlobalConfig;
import com.getbouncer.cardscan.base.ObjectDetect;
import com.getbouncer.cardscan.base.OnObjectListener;
import com.getbouncer.cardscan.base.OnScanListener;
import com.getbouncer.cardscan.base.SSDOcrDetect;
import com.getbouncer.cardscan.base.ScanBaseActivity;
import com.getbouncer.cardscan.base.image.YUVDecoder;
import com.getbouncer.cardscan.base.ssd.DetectedSSDBox;
import java.io.File;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.LinkedList;

class MachineLearningThread
implements Runnable {
    private LinkedList<RunArguments> queue = new LinkedList();

    MachineLearningThread() {
    }

    public synchronized void warmUp(Context context) {
        if (!this.queue.isEmpty()) {
            return;
        }
        RunArguments args = new RunArguments(null, 0, 0, 0, 90, null, context, 0.5f);
        this.queue.push(args);
        this.notify();
    }

    synchronized void post(Bitmap bitmap, OnScanListener scanListener, Context context) {
        RunArguments args = new RunArguments(bitmap, scanListener, context);
        this.queue.push(args);
        this.notify();
    }

    synchronized void post(byte[] bytes, int width, int height, int format, int sensorOrientation, OnScanListener scanListener, Context context, float roiCenterYRatio) {
        RunArguments args = new RunArguments(bytes, width, height, format, sensorOrientation, scanListener, context, roiCenterYRatio);
        this.queue.push(args);
        this.notify();
    }

    synchronized void post(Bitmap bitmap, OnObjectListener objectListener, Context context, File objectDetectFile) {
        RunArguments args = new RunArguments(bitmap, objectListener, context, objectDetectFile);
        this.queue.push(args);
        this.notify();
    }

    synchronized void post(byte[] bytes, int width, int height, int format, int sensorOrientation, OnObjectListener objectListener, Context context, float roiCenterYRatio, File objectDetectFile) {
        RunArguments args = new RunArguments(bytes, width, height, format, sensorOrientation, objectListener, context, roiCenterYRatio, objectDetectFile);
        this.queue.push(args);
        this.notify();
    }

    public Bitmap YUVtoRGB(byte[] yuvByteArray, int previewWidth, int previewHeight) {
        int resizedWidth;
        int resizedHeight;
        int[] argbByteArray = new int[previewWidth * previewHeight];
        YUVDecoder.YUVtoRGBA(yuvByteArray, previewWidth, previewHeight, argbByteArray);
        Bitmap fullImage = Bitmap.createBitmap((int)previewWidth, (int)previewHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        fullImage.copyPixelsFromBuffer((Buffer)IntBuffer.wrap(argbByteArray));
        if (previewWidth > previewHeight) {
            resizedHeight = ScanBaseActivity.MIN_IMAGE_EDGE;
            resizedWidth = previewWidth * resizedHeight / previewHeight;
        } else {
            resizedWidth = ScanBaseActivity.MIN_IMAGE_EDGE;
            resizedHeight = previewHeight * resizedWidth / previewWidth;
        }
        Bitmap resizedImage = Bitmap.createScaledBitmap((Bitmap)fullImage, (int)resizedWidth, (int)resizedHeight, (boolean)false);
        fullImage.recycle();
        return resizedImage;
    }

    private BitmapPair getBitmap(byte[] bytes, int width, int height, int format, int sensorOrientation, float roiCenterYRatio, boolean isOcr) {
        int y;
        int x;
        double h;
        double w;
        long startTime = SystemClock.uptimeMillis();
        Bitmap bitmap = this.YUVtoRGB(bytes, width, height);
        long decode = SystemClock.uptimeMillis();
        if (GlobalConfig.PRINT_TIMING) {
            Log.d((String)"MLThread", (String)("decode -> " + (double)(decode - startTime) / 1000.0));
        }
        if ((sensorOrientation %= 360) == 0) {
            h = w = (double)bitmap.getWidth();
            x = 0;
            y = (int)Math.round((double)bitmap.getHeight() * (double)roiCenterYRatio - h * 0.5);
        } else if (sensorOrientation == 90) {
            w = h = (double)bitmap.getHeight();
            y = 0;
            x = (int)Math.round((double)bitmap.getWidth() * (double)roiCenterYRatio - w * 0.5);
        } else if (sensorOrientation == 180) {
            h = w = (double)bitmap.getWidth();
            x = 0;
            y = (int)Math.round((double)bitmap.getHeight() * (1.0 - (double)roiCenterYRatio) - h * 0.5);
        } else {
            w = h = (double)bitmap.getHeight();
            x = (int)Math.round((double)bitmap.getWidth() * (1.0 - (double)roiCenterYRatio) - w * 0.5);
            y = 0;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if ((double)x + w > (double)bitmap.getWidth()) {
            x = bitmap.getWidth() - (int)w;
        }
        if ((double)y + h > (double)bitmap.getHeight()) {
            y = bitmap.getHeight() - (int)h;
        }
        Bitmap croppedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)x, (int)y, (int)((int)w), (int)((int)h));
        long crop = SystemClock.uptimeMillis();
        if (GlobalConfig.PRINT_TIMING) {
            Log.d((String)"MLThread", (String)("crop -> " + (double)(crop - decode) / 1000.0));
        }
        Matrix matrix = new Matrix();
        matrix.postRotate((float)sensorOrientation);
        Bitmap bm = Bitmap.createBitmap((Bitmap)croppedBitmap, (int)0, (int)0, (int)croppedBitmap.getWidth(), (int)croppedBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Bitmap fullScreen = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        long rotate = SystemClock.uptimeMillis();
        if (GlobalConfig.PRINT_TIMING) {
            Log.d((String)"MLThread", (String)("rotate -> " + (double)(rotate - crop) / 1000.0));
        }
        croppedBitmap.recycle();
        bitmap.recycle();
        return new BitmapPair(bm, fullScreen);
    }

    private synchronized RunArguments getNextImage() {
        while (this.queue.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.queue.pop();
    }

    private void runObjectModel(final Bitmap bitmap, final RunArguments args, final Bitmap fullScreenBitmap) {
        if (args.mObjectDetectFile == null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (args.mObjectListener != null) {
                        args.mObjectListener.onPrediction(bitmap, new LinkedList<DetectedSSDBox>(), bitmap.getWidth(), bitmap.getHeight(), fullScreenBitmap);
                    }
                    bitmap.recycle();
                    fullScreenBitmap.recycle();
                }
            });
            return;
        }
        final ObjectDetect detect = new ObjectDetect(args.mObjectDetectFile);
        String result = detect.predictOnCpu(bitmap, args.mContext);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (args.mObjectListener != null) {
                        if (detect.hadUnrecoverableException) {
                            args.mObjectListener.onObjectFatalError();
                        } else {
                            args.mObjectListener.onPrediction(bitmap, detect.objectBoxes, bitmap.getWidth(), bitmap.getHeight(), fullScreenBitmap);
                        }
                    }
                    bitmap.recycle();
                    fullScreenBitmap.recycle();
                }
                catch (Error | Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void runOcrModel(final Bitmap bitmap, final RunArguments args, final Bitmap bitmapForObjectDetection, final Bitmap fullScreenBitmap) {
        SSDOcrDetect ocrDetect = new SSDOcrDetect();
        final String number = ocrDetect.predict(bitmap, args.mContext);
        Log.d((String)"OCR Detect", (String)("OCR Number:" + number));
        final boolean hadUnrecoverableException = ocrDetect.hadUnrecoverableException;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (args.mScanListener != null) {
                        if (hadUnrecoverableException) {
                            args.mScanListener.onFatalError();
                        } else {
                            args.mScanListener.onPrediction(number, null, bitmap, new ArrayList<DetectedBox>(), null, bitmapForObjectDetection, fullScreenBitmap);
                        }
                    }
                    bitmap.recycle();
                    bitmapForObjectDetection.recycle();
                    if (fullScreenBitmap != null) {
                        fullScreenBitmap.recycle();
                    }
                }
                catch (Error | Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void runModel() {
        Bitmap bm;
        RunArguments args = this.getNextImage();
        Bitmap fullScreen = null;
        if (args.mFrameBytes != null) {
            BitmapPair pair = this.getBitmap(args.mFrameBytes, args.mWidth, args.mHeight, args.mFormat, args.mSensorOrientation, args.mRoiCenterYRatio, args.mIsOcr);
            bm = pair.cropped;
            fullScreen = pair.fullScreen;
        } else if (args.mBitmap != null) {
            bm = args.mBitmap;
        } else {
            bm = Bitmap.createBitmap((int)480, (int)480, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bm);
            Paint paint = new Paint();
            paint.setColor(-7829368);
            canvas.drawRect(0.0f, 0.0f, 480.0f, 480.0f, paint);
        }
        if (args.mIsOcr) {
            float width = bm.getWidth();
            float height = width * 375.0f / 600.0f;
            float y = ((float)bm.getHeight() - height) / 2.0f;
            float x = 0.0f;
            Bitmap croppedBitmap = Bitmap.createBitmap((Bitmap)bm, (int)((int)x), (int)((int)y), (int)((int)width), (int)((int)height));
            this.runOcrModel(croppedBitmap, args, bm, fullScreen);
        } else {
            this.runObjectModel(bm, args, fullScreen);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.runModel();
                }
            }
            catch (Error | Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    class BitmapPair {
        private Bitmap cropped;
        private Bitmap fullScreen;

        BitmapPair(Bitmap cropped, Bitmap fullScreen) {
            this.cropped = cropped;
            this.fullScreen = fullScreen;
        }
    }

    class RunArguments {
        private final byte[] mFrameBytes;
        private final Bitmap mBitmap;
        private final OnScanListener mScanListener;
        private final OnObjectListener mObjectListener;
        private final Context mContext;
        private final int mWidth;
        private final int mHeight;
        private final int mFormat;
        private final int mSensorOrientation;
        private final float mRoiCenterYRatio;
        private final boolean mIsOcr;
        private final File mObjectDetectFile;

        RunArguments(byte[] frameBytes, int width, int height, int format, int sensorOrientation, OnScanListener scanListener, Context context, float roiCenterYRatio) {
            this.mFrameBytes = frameBytes;
            this.mBitmap = null;
            this.mWidth = width;
            this.mHeight = height;
            this.mFormat = format;
            this.mScanListener = scanListener;
            this.mContext = context;
            this.mSensorOrientation = sensorOrientation;
            this.mRoiCenterYRatio = roiCenterYRatio;
            this.mIsOcr = true;
            this.mObjectListener = null;
            this.mObjectDetectFile = null;
        }

        RunArguments(byte[] frameBytes, int width, int height, int format, int sensorOrientation, OnObjectListener objectListener, Context context, float roiCenterYRatio, File objectDetectFile) {
            this.mFrameBytes = frameBytes;
            this.mBitmap = null;
            this.mWidth = width;
            this.mHeight = height;
            this.mFormat = format;
            this.mScanListener = null;
            this.mContext = context;
            this.mSensorOrientation = sensorOrientation;
            this.mRoiCenterYRatio = roiCenterYRatio;
            this.mIsOcr = false;
            this.mObjectListener = objectListener;
            this.mObjectDetectFile = objectDetectFile;
        }

        @VisibleForTesting
        RunArguments(Bitmap bitmap, OnScanListener scanListener, Context context) {
            this.mFrameBytes = null;
            this.mBitmap = bitmap;
            this.mWidth = bitmap == null ? 0 : bitmap.getWidth();
            this.mHeight = bitmap == null ? 0 : bitmap.getHeight();
            this.mFormat = 0;
            this.mScanListener = scanListener;
            this.mContext = context;
            this.mSensorOrientation = 0;
            this.mRoiCenterYRatio = 0.0f;
            this.mIsOcr = true;
            this.mObjectListener = null;
            this.mObjectDetectFile = null;
        }

        @VisibleForTesting
        RunArguments(Bitmap bitmap, OnObjectListener objectListener, Context context, File objectDetectFile) {
            this.mFrameBytes = null;
            this.mBitmap = bitmap;
            this.mWidth = bitmap == null ? 0 : bitmap.getWidth();
            this.mHeight = bitmap == null ? 0 : bitmap.getHeight();
            this.mFormat = 0;
            this.mScanListener = null;
            this.mContext = context;
            this.mSensorOrientation = 0;
            this.mRoiCenterYRatio = 0.0f;
            this.mIsOcr = false;
            this.mObjectListener = objectListener;
            this.mObjectDetectFile = objectDetectFile;
        }
    }
}

