/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import androidx.annotation.DrawableRes;
import com.getbouncer.cardscan.base.CardNetwork;
import com.getbouncer.cardscan.base.CreditCardUtils$WhenMappings;
import com.getbouncer.cardscan.base.R;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eH\u0007J\u001a\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u001e\u0010 \u001a\u0004\u0018\u00010\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u000eH\u0007J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000bH\u0007J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000eH\u0007J\u0012\u0010&\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010\u000bH\u0007J+\u0010'\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010)J \u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00100\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u000201H\u0002J\u0012\u00102\u001a\u00020\u001c2\b\u00103\u001a\u0004\u0018\u00010\u000eH\u0007J\u001c\u00104\u001a\u00020\u001c2\b\u00105\u001a\u0004\u0018\u00010\u000e2\b\u0010$\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u00106\u001a\u00020\u001c2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u00106\u001a\u00020\u001c2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u00107\u001a\u00020\u000bH\u0002J\u0012\u00108\u001a\u00020\u001c2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eH\u0007J\u0017\u00109\u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010:J\u001f\u0010;\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020.H\u0002\u00a2\u0006\u0002\u0010<J\u001c\u0010=\u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u000eH\u0007J$\u0010=\u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010-\u001a\u00020.H\u0002J\u0012\u0010>\u001a\u00020\u001c2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010?\u001a\u00020\u001c2\b\u0010@\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010A\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.H\u0002J\u0014\u0010B\u001a\u0004\u0018\u00010\u000e2\b\u0010C\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006D"}, d2={"Lcom/getbouncer/cardscan/base/CreditCardUtils;", "", "()V", "CVC_LENGTH_AMEX", "", "CVC_LENGTH_COMMON", "LENGTH_AMEX", "LENGTH_COMMON_CARD", "LENGTH_DINERS_CLUB", "NETWORK_RESOURCE_MAP", "", "Lcom/getbouncer/cardscan/base/CardNetwork;", "PREFIXES_AMEX", "", "", "[Ljava/lang/String;", "PREFIXES_DINERS_CLUB", "PREFIXES_DISCOVER", "PREFIXES_JCB", "PREFIXES_MASTERCARD", "PREFIXES_UNIONPAY", "PREFIXES_VISA", "asInteger", "str", "(Ljava/lang/String;)Ljava/lang/Integer;", "determineCardNetwork", "cardNumber", "shouldNormalize", "", "formatAmexForDisplay", "number", "formatCommonForDisplay", "formatExpirationForDisplay", "expMonth", "expYear", "formatNetworkForDisplay", "network", "formatNumberForDisplay", "getNetworkIcon", "hasAnyPrefix", "prefixes", "(Ljava/lang/String;[Ljava/lang/String;)Z", "hasMonthPassed", "year", "month", "now", "Ljava/util/Calendar;", "hasYearPassed", "isDigitsOnly", "", "isValidBin", "bin", "isValidCVC", "cvc", "isValidCardLength", "cardNetwork", "isValidCardNumber", "isValidExpMonth", "(Ljava/lang/Integer;)Z", "isValidExpYear", "(Ljava/lang/Integer;Ljava/util/Calendar;)Z", "isValidExpirationDate", "isValidLuhnNumber", "isWholePositiveNumber", "value", "normalizeYear", "removeSpacesAndHyphens", "cardNumberWithSpaces", "cardscan-base_release"})
public final class CreditCardUtils {
    public static final int LENGTH_COMMON_CARD = 16;
    public static final int LENGTH_AMEX = 15;
    private static final int CVC_LENGTH_AMEX = 4;
    private static final int CVC_LENGTH_COMMON = 3;
    private static final String[] PREFIXES_AMEX;
    private static final String[] PREFIXES_DISCOVER;
    private static final String[] PREFIXES_JCB;
    private static final String[] PREFIXES_DINERS_CLUB;
    private static final String[] PREFIXES_VISA;
    private static final String[] PREFIXES_MASTERCARD;
    private static final String[] PREFIXES_UNIONPAY;
    private static final int LENGTH_DINERS_CLUB = 14;
    private static final Map<CardNetwork, Integer> NETWORK_RESOURCE_MAP;
    public static final CreditCardUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final CardNetwork determineCardNetwork(@Nullable String cardNumber) {
        return INSTANCE.determineCardNetwork(cardNumber, true);
    }

    @JvmStatic
    public static final boolean isValidCardNumber(@Nullable String cardNumber) {
        String normalizedNumber = INSTANCE.removeSpacesAndHyphens(cardNumber);
        return INSTANCE.isValidLuhnNumber(normalizedNumber) && INSTANCE.isValidCardLength(normalizedNumber);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isValidLuhnNumber(String cardNumber) {
        CharSequence charSequence = cardNumber;
        boolean bl = false;
        int n = 0;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        boolean isOdd = true;
        int sum = 0;
        n = cardNumber.length() - 1;
        boolean bl2 = false;
        while (n >= 0) {
            void index;
            char c = cardNumber.charAt((int)index);
            if (!Character.isDigit(c)) {
                return false;
            }
            int digitInteger = Character.getNumericValue(c);
            boolean bl3 = isOdd = !isOdd;
            if (isOdd) {
                digitInteger *= 2;
            }
            if (digitInteger > 9) {
                digitInteger -= 9;
            }
            sum += digitInteger;
            --index;
        }
        return sum % 10 == 0;
    }

    @JvmStatic
    public static final boolean isValidBin(@Nullable String bin) {
        return CreditCardUtils.determineCardNetwork(bin) != CardNetwork.UNKNOWN;
    }

    private final boolean isValidCardLength(String cardNumber) {
        return cardNumber != null && this.isValidCardLength(cardNumber, this.determineCardNetwork(cardNumber, false));
    }

    private final boolean isValidCardLength(String cardNumber, CardNetwork cardNetwork) {
        boolean bl;
        if (cardNumber == null || CardNetwork.UNKNOWN == cardNetwork) {
            return false;
        }
        int length = cardNumber.length();
        switch (CreditCardUtils$WhenMappings.$EnumSwitchMapping$0[cardNetwork.ordinal()]) {
            case 1: {
                if (length == 15) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (length == 14) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = length == 16;
            }
        }
        return bl;
    }

    private final CardNetwork determineCardNetwork(String cardNumber, boolean shouldNormalize) {
        CharSequence charSequence = cardNumber;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return CardNetwork.UNKNOWN;
        }
        String normalizedCardNumber = shouldNormalize ? this.removeSpacesAndHyphens(cardNumber) : cardNumber;
        return this.hasAnyPrefix(normalizedCardNumber, Arrays.copyOf(PREFIXES_AMEX, PREFIXES_AMEX.length)) ? CardNetwork.AMEX : (this.hasAnyPrefix(normalizedCardNumber, Arrays.copyOf(PREFIXES_DISCOVER, PREFIXES_DISCOVER.length)) ? CardNetwork.DISCOVER : (this.hasAnyPrefix(normalizedCardNumber, Arrays.copyOf(PREFIXES_JCB, PREFIXES_JCB.length)) ? CardNetwork.JCB : (this.hasAnyPrefix(normalizedCardNumber, Arrays.copyOf(PREFIXES_DINERS_CLUB, PREFIXES_DINERS_CLUB.length)) ? CardNetwork.DINERS_CLUB : (this.hasAnyPrefix(normalizedCardNumber, Arrays.copyOf(PREFIXES_VISA, PREFIXES_VISA.length)) ? CardNetwork.VISA : (this.hasAnyPrefix(normalizedCardNumber, Arrays.copyOf(PREFIXES_MASTERCARD, PREFIXES_MASTERCARD.length)) ? CardNetwork.MASTERCARD : (this.hasAnyPrefix(normalizedCardNumber, Arrays.copyOf(PREFIXES_UNIONPAY, PREFIXES_UNIONPAY.length)) ? CardNetwork.UNIONPAY : CardNetwork.UNKNOWN))))));
    }

    @JvmStatic
    public static final boolean isValidCVC(@Nullable String cvc, @Nullable CardNetwork network) {
        CharSequence charSequence = cvc;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        String string2 = cvc;
        bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String cvcValue = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        boolean validLength = network == null && cvcValue.length() >= 3 && cvcValue.length() <= 4 || CardNetwork.AMEX == network && cvcValue.length() == 4 || cvcValue.length() == 3;
        return INSTANCE.isWholePositiveNumber(cvcValue) && validLength;
    }

    @JvmStatic
    public static final boolean isValidExpirationDate(@Nullable String expMonth, @Nullable String expYear) {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        return INSTANCE.isValidExpirationDate(expMonth, expYear, calendar);
    }

    private final boolean isValidExpirationDate(String expMonth, String expYear, Calendar now) {
        Integer expirationMonth = this.asInteger(expMonth);
        Integer expirationYear = this.asInteger(expYear);
        if (expirationMonth == null || !this.isValidExpMonth(expirationMonth)) {
            return false;
        }
        return expirationYear == null || !this.isValidExpYear(expirationYear, now) ? false : !this.hasMonthPassed(expirationYear, expirationMonth, now);
    }

    @JvmStatic
    @DrawableRes
    public static final int getNetworkIcon(@Nullable CardNetwork network) {
        Map<CardNetwork, Integer> map = NETWORK_RESOURCE_MAP;
        boolean bl = false;
        Integer n = map.get(network);
        return n != null ? n : R.drawable.bouncer_card_unknown;
    }

    @JvmStatic
    @NotNull
    public static final String formatNumberForDisplay(@NotNull String number) {
        Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
        if (number.length() == 16) {
            return INSTANCE.formatCommonForDisplay(number);
        }
        if (number.length() == 15) {
            return INSTANCE.formatAmexForDisplay(number);
        }
        return number;
    }

    @JvmStatic
    @NotNull
    public static final String formatNetworkForDisplay(@NotNull CardNetwork network) {
        Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
        return network.getDisplayName();
    }

    @JvmStatic
    @Nullable
    public static final String formatExpirationForDisplay(@Nullable String expMonth, @Nullable String expYear) {
        String string2;
        String month;
        if (expMonth == null || expYear == null) {
            return null;
        }
        String string3 = month = expMonth.length() == 1 ? '0' + expMonth : expMonth;
        if (expYear.length() == 4) {
            String string4 = expYear;
            int n = 2;
            boolean bl = false;
            String string5 = string4.substring(n);
            string2 = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string2 = expYear;
        }
        String year = string2;
        return month + '/' + year;
    }

    /*
     * WARNING - void declaration
     */
    private final String formatCommonForDisplay(String number) {
        StringBuilder result = new StringBuilder();
        int n = 0;
        int n2 = ((CharSequence)number).length();
        while (n < n2) {
            void idx;
            if (idx == 4 || idx == 8 || idx == 12) {
                result.append(" ");
            }
            result.append(number.charAt((int)idx));
            ++idx;
        }
        String string2 = result.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final String formatAmexForDisplay(String number) {
        StringBuilder result = new StringBuilder();
        int n = 0;
        int n2 = ((CharSequence)number).length();
        while (n < n2) {
            void idx;
            if (idx == 4 || idx == 10) {
                result.append(" ");
            }
            result.append(number.charAt((int)idx));
            ++idx;
        }
        String string2 = result.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.toString()");
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidExpMonth(Integer expMonth) {
        Integer n = expMonth;
        if (n == null) return false;
        Integer n2 = n;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n2).intValue();
        boolean bl3 = false;
        int n3 = it;
        if (1 > n3) return false;
        if (12 < n3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidExpYear(Integer expYear, Calendar now) {
        Integer n = expYear;
        if (n == null) return false;
        Integer n2 = n;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n2).intValue();
        boolean bl3 = false;
        if (INSTANCE.hasYearPassed(it, now)) return false;
        return true;
    }

    private final boolean hasMonthPassed(int year, int month, Calendar now) {
        return this.hasYearPassed(year, now) ? true : this.normalizeYear(year, now) == now.get(1) && month < now.get(2) + 1;
    }

    private final boolean hasYearPassed(int year, Calendar now) {
        return this.normalizeYear(year, now) < now.get(1);
    }

    private final int normalizeYear(int year, Calendar now) {
        int n;
        int n2 = year;
        if (0 <= n2 && 99 >= n2) {
            String currentYear;
            String string2 = currentYear = String.valueOf(now.get(1));
            int n3 = 0;
            int n4 = currentYear.length() - 2;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n3, n4);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String prefix = string4;
            string2 = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            String string5 = "%s%02d";
            Object[] objectArray = new Object[]{prefix, year};
            boolean bl2 = false;
            String string6 = String.format(locale2, string5, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(locale, format, *args)");
            string2 = string6;
            boolean bl3 = false;
            n = Integer.parseInt(string2);
        } else {
            n = year;
        }
        return n;
    }

    private final String removeSpacesAndHyphens(String cardNumberWithSpaces) {
        String string2;
        CharSequence charSequence = cardNumberWithSpaces;
        boolean bl = false;
        boolean bl2 = false;
        String it = charSequence;
        boolean bl3 = false;
        CharSequence charSequence2 = it;
        boolean bl4 = false;
        boolean bl5 = false;
        String string3 = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? charSequence : null;
        if (string3 != null) {
            charSequence = string3;
            String string4 = "\\s|-";
            bl2 = false;
            string4 = new Regex(string4);
            String string5 = "";
            boolean bl6 = false;
            string2 = string4.replace(charSequence, string5);
        } else {
            string2 = null;
        }
        return string2;
    }

    private final boolean hasAnyPrefix(String number, String ... prefixes) {
        boolean bl;
        block1: {
            String[] $this$any$iv = prefixes;
            boolean $i$f$any = false;
            String[] stringArray = $this$any$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl2 = false;
                String string2 = number;
                if (!(string2 != null && StringsKt.startsWith$default((String)string2, (String)it, (boolean)false, (int)2, null))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isWholePositiveNumber(String value) {
        return value != null && this.isDigitsOnly(value);
    }

    private final boolean isDigitsOnly(CharSequence str) {
        int cp;
        for (int i = 0; i < str.length(); i += Character.charCount(cp)) {
            cp = Character.codePointAt(str, i);
            if (Character.isDigit(cp)) continue;
            return false;
        }
        return true;
    }

    private final Integer asInteger(String str) {
        Integer n;
        if (str != null && this.isDigitsOnly(str)) {
            String string2 = str;
            boolean bl = false;
            n = Integer.parseInt(string2);
        } else {
            n = null;
        }
        return n;
    }

    private CreditCardUtils() {
    }

    static {
        CreditCardUtils creditCardUtils;
        INSTANCE = creditCardUtils = new CreditCardUtils();
        PREFIXES_AMEX = new String[]{"34", "37"};
        PREFIXES_DISCOVER = new String[]{"60", "64", "65"};
        PREFIXES_JCB = new String[]{"35"};
        PREFIXES_DINERS_CLUB = new String[]{"300", "301", "302", "303", "304", "305", "309", "36", "38", "39"};
        PREFIXES_VISA = new String[]{"4"};
        PREFIXES_MASTERCARD = new String[]{"2221", "2222", "2223", "2224", "2225", "2226", "2227", "2228", "2229", "223", "224", "225", "226", "227", "228", "229", "23", "24", "25", "26", "270", "271", "2720", "50", "51", "52", "53", "54", "55", "67"};
        PREFIXES_UNIONPAY = new String[]{"62"};
        NETWORK_RESOURCE_MAP = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)CardNetwork.AMEX, (Object)R.drawable.bouncer_card_amex), TuplesKt.to((Object)CardNetwork.DINERS_CLUB, (Object)R.drawable.bouncer_card_diners), TuplesKt.to((Object)CardNetwork.DISCOVER, (Object)R.drawable.bouncer_card_discover), TuplesKt.to((Object)CardNetwork.JCB, (Object)R.drawable.bouncer_card_jcb), TuplesKt.to((Object)CardNetwork.MASTERCARD, (Object)R.drawable.bouncer_card_mastercard), TuplesKt.to((Object)CardNetwork.VISA, (Object)R.drawable.bouncer_card_visa), TuplesKt.to((Object)CardNetwork.UNIONPAY, (Object)R.drawable.bouncer_card_unionpay), TuplesKt.to((Object)CardNetwork.UNKNOWN, (Object)R.drawable.bouncer_card_unknown)});
    }
}

