/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.getbouncer.cardscan.base.OnCameraOpenListener;
import java.lang.ref.WeakReference;

class CameraThread
extends Thread {
    private WeakReference<OnCameraOpenListener> listener;

    CameraThread() {
    }

    synchronized void startCamera(OnCameraOpenListener listener) {
        this.listener = new WeakReference<OnCameraOpenListener>(listener);
        this.notify();
    }

    synchronized OnCameraOpenListener waitForOpenRequest() {
        while (this.listener == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return (OnCameraOpenListener)this.listener.get();
    }

    @Override
    public void run() {
        final OnCameraOpenListener listener = this.waitForOpenRequest();
        if (listener == null) {
            this.listener.clear();
            return;
        }
        Camera camera = null;
        try {
            camera = Camera.open();
        }
        catch (Exception e) {
            Log.e((String)"CameraThread", (String)"failed to open Camera");
            e.printStackTrace();
        }
        final Camera resultCamera = camera;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                listener.onCameraOpen(resultCamera);
                CameraThread.this.listener.clear();
                CameraThread.this.listener = null;
            }
        });
    }
}

