/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.getbouncer.cardscan.base.Api;
import com.getbouncer.cardscan.base.DetectedBox;
import com.getbouncer.cardscan.base.Expiry;
import com.getbouncer.cardscan.base.ImageUtils;
import com.getbouncer.cardscan.base.R;
import com.getbouncer.cardscan.base.ScanBaseActivity;
import java.util.List;

public class ScanActivityImpl
extends ScanBaseActivity {
    private static final String TAG = "ScanActivityImpl";
    private ImageView mDebugImageView;
    private boolean mInDebugMode = false;
    private static long startTimeMs = 0L;
    public static final String SCAN_CARD_TEXT = "scanCardText";
    public static final String POSITION_CARD_TEXT = "positionCardText";
    public static final String API_KEY = "apiKey";
    public static final String RESULT_CARD_NUMBER = "cardNumber";
    public static final String RESULT_EXPIRY_MONTH = "expiryMonth";
    public static final String RESULT_EXPIRY_YEAR = "expiryYear";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        String apiKey;
        String positionCardText;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.bouncer_private_activity_scan_card);
        String scanCardText = this.getIntent().getStringExtra(SCAN_CARD_TEXT);
        if (!TextUtils.isEmpty((CharSequence)scanCardText)) {
            ((TextView)this.findViewById(R.id.scanCard)).setText((CharSequence)scanCardText);
        }
        if (!TextUtils.isEmpty((CharSequence)(positionCardText = this.getIntent().getStringExtra(POSITION_CARD_TEXT)))) {
            ((TextView)this.findViewById(R.id.positionCard)).setText((CharSequence)positionCardText);
        }
        if (!TextUtils.isEmpty((CharSequence)(apiKey = this.getIntent().getStringExtra(API_KEY)))) {
            Api.apiKey = apiKey;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.checkSelfPermission("android.permission.CAMERA") != 0) {
                this.requestPermissions(new String[]{"android.permission.CAMERA"}, 110);
            } else {
                this.mIsPermissionCheckDone = true;
            }
        } else {
            this.mIsPermissionCheckDone = true;
        }
        this.findViewById(R.id.closeButton).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ScanActivityImpl.this.onBackPressed();
            }
        });
        this.mDebugImageView = (ImageView)this.findViewById(R.id.debugImageView);
        this.mInDebugMode = this.getIntent().getBooleanExtra("debug", false);
        if (!this.mInDebugMode) {
            this.mDebugImageView.setVisibility(4);
        }
        this.setViewIds(R.id.flashlightButton, R.id.cardRectangle, R.id.shadedBackground, R.id.texture, R.id.cardNumber, R.id.expiry);
    }

    @Override
    protected void onCardScanned(String numberResult, String month, String year) {
        Intent intent = new Intent();
        intent.putExtra(RESULT_CARD_NUMBER, numberResult);
        intent.putExtra(RESULT_EXPIRY_MONTH, month);
        intent.putExtra(RESULT_EXPIRY_YEAR, year);
        this.setResult(-1, intent);
        this.finish();
    }

    @Override
    public void onPrediction(String number, Expiry expiry, Bitmap bitmap, List<DetectedBox> digitBoxes, DetectedBox expiryBox, Bitmap bitmapForObjectDetection, Bitmap fullScreenBitmap) {
        if (this.mInDebugMode) {
            this.mDebugImageView.setImageBitmap(ImageUtils.drawBoxesOnImage(bitmap, digitBoxes, expiryBox));
            Log.d((String)TAG, (String)("Prediction (ms): " + (SystemClock.uptimeMillis() - this.mPredictionStartMs)));
            if (startTimeMs != 0L) {
                Log.d((String)TAG, (String)("time to first prediction: " + (SystemClock.uptimeMillis() - startTimeMs)));
                startTimeMs = 0L;
            }
        }
        super.onPrediction(number, expiry, bitmap, digitBoxes, expiryBox, bitmapForObjectDetection, fullScreenBitmap);
    }
}

