/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.Context;
import com.getbouncer.cardscan.base.CGSize;
import com.getbouncer.cardscan.base.ImageClassifier;
import com.getbouncer.cardscan.base.ModelFactory;
import java.io.IOException;
import java.nio.MappedByteBuffer;

class FindFourModel
extends ImageClassifier {
    final int rows = 34;
    final int cols = 51;
    final CGSize boxSize = new CGSize(80.0f, 36.0f);
    final CGSize cardSize = new CGSize(480.0f, 302.0f);
    private final int classes = 3;
    private final int digitClass = 1;
    private final int expiryClass = 2;
    private float[][][][] labelProbArray = new float[1][34][51][3];

    FindFourModel(Context context) throws IOException {
        super(context);
    }

    boolean hasDigits(int row, int col) {
        return (double)this.digitConfidence(row, col) >= 0.5;
    }

    boolean hasExpiry(int row, int col) {
        return (double)this.expiryConfidence(row, col) >= 0.5;
    }

    float digitConfidence(int row, int col) {
        return this.labelProbArray[0][row][col][1];
    }

    float expiryConfidence(int row, int col) {
        return this.labelProbArray[0][row][col][2];
    }

    @Override
    protected MappedByteBuffer loadModelFile(Context context) throws IOException {
        return ModelFactory.getSharedInstance().loadFindFourFile(context);
    }

    @Override
    protected int getImageSizeX() {
        return 480;
    }

    @Override
    protected int getImageSizeY() {
        return 302;
    }

    @Override
    protected int getNumBytesPerChannel() {
        return 4;
    }

    @Override
    protected void addPixelValue(int pixelValue) {
        this.imgData.putFloat((float)(pixelValue >> 16 & 0xFF) / 255.0f);
        this.imgData.putFloat((float)(pixelValue >> 8 & 0xFF) / 255.0f);
        this.imgData.putFloat((float)(pixelValue & 0xFF) / 255.0f);
    }

    @Override
    protected void runInference() {
        this.tflite.run((Object)this.imgData, (Object)this.labelProbArray);
    }
}

