/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.Context;
import com.getbouncer.cardscan.base.ImageClassifier;
import com.getbouncer.cardscan.base.ModelFactory;
import java.io.IOException;
import java.nio.MappedByteBuffer;

class RecognizedDigitsModel
extends ImageClassifier {
    private final int kImageWidth = 80;
    private final int kImageHeight = 36;
    static final int kNumPredictions = 17;
    private final int classes = 11;
    private float[][][][] labelProbArray = new float[1][1][17][11];

    RecognizedDigitsModel(Context context) throws IOException {
        super(context);
    }

    ArgMaxAndConfidence argAndValueMax(int col) {
        int maxIdx = -1;
        float maxValue = -1.0f;
        for (int idx = 0; idx < 11; ++idx) {
            float value = this.labelProbArray[0][0][col][idx];
            if (!(value > maxValue)) continue;
            maxIdx = idx;
            maxValue = value;
        }
        return new ArgMaxAndConfidence(maxIdx, maxValue);
    }

    @Override
    protected MappedByteBuffer loadModelFile(Context context) throws IOException {
        return ModelFactory.getSharedInstance().loadRecognizeDigitsFile(context);
    }

    @Override
    protected int getImageSizeX() {
        return 80;
    }

    @Override
    protected int getImageSizeY() {
        return 36;
    }

    @Override
    protected int getNumBytesPerChannel() {
        return 4;
    }

    @Override
    protected void addPixelValue(int pixelValue) {
        this.imgData.putFloat((float)(pixelValue >> 16 & 0xFF) / 255.0f);
        this.imgData.putFloat((float)(pixelValue >> 8 & 0xFF) / 255.0f);
        this.imgData.putFloat((float)(pixelValue & 0xFF) / 255.0f);
    }

    @Override
    protected void runInference() {
        this.tflite.run((Object)this.imgData, (Object)this.labelProbArray);
    }

    class ArgMaxAndConfidence {
        final int argMax;
        final float confidence;

        ArgMaxAndConfidence(int argMax, float confidence) {
            this.argMax = argMax;
            this.confidence = confidence;
        }
    }
}

