/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base.ssd;

import com.getbouncer.cardscan.base.ssd.ArrUtils;

public class PriorsGen {
    public static float[][] genPriors(int featureMapSize, int shrinkage, int boxSizeMin, int boxSizeMax, int aspecRatioOne, int aspectRatioTwo, int noOfPriors) {
        float[][] boxes = new float[featureMapSize * featureMapSize * noOfPriors][4];
        int image_size = 300;
        float scale = image_size / shrinkage;
        int priorIndex = 0;
        for (int j = 0; j < featureMapSize; ++j) {
            for (int i = 0; i < featureMapSize; ++i) {
                float w;
                float x_center = (float)((double)i + 0.5) / scale;
                float y_center = (float)((double)j + 0.5) / scale;
                float size = boxSizeMin;
                float h = w = size / (float)image_size;
                boxes[priorIndex][0] = x_center;
                boxes[priorIndex][1] = y_center;
                boxes[priorIndex][2] = h;
                boxes[priorIndex][3] = w;
                size = (float)Math.sqrt(boxSizeMax * boxSizeMin);
                h = w = size / (float)image_size;
                boxes[++priorIndex][0] = x_center;
                boxes[priorIndex][1] = y_center;
                boxes[priorIndex][2] = h;
                boxes[priorIndex][3] = w;
                size = boxSizeMin;
                h = w = size / (float)image_size;
                float ratioOne = (float)Math.sqrt(aspecRatioOne);
                float ratioTwo = (float)Math.sqrt(aspectRatioTwo);
                boxes[++priorIndex][0] = x_center;
                boxes[priorIndex][1] = y_center;
                boxes[priorIndex][2] = h * ratioOne;
                boxes[priorIndex][3] = w / ratioOne;
                boxes[++priorIndex][0] = x_center;
                boxes[priorIndex][1] = y_center;
                boxes[priorIndex][2] = h / ratioOne;
                boxes[priorIndex][3] = w * ratioOne;
                boxes[++priorIndex][0] = x_center;
                boxes[priorIndex][1] = y_center;
                boxes[priorIndex][2] = h * ratioTwo;
                boxes[priorIndex][3] = w / ratioTwo;
                boxes[++priorIndex][0] = x_center;
                boxes[priorIndex][1] = y_center;
                boxes[priorIndex][2] = h / ratioTwo;
                boxes[priorIndex][3] = w * ratioTwo;
                ++priorIndex;
            }
        }
        return boxes;
    }

    public static float[][] combinePriors() {
        int j;
        int i;
        float[][] priorsOne = PriorsGen.genPriors(19, 16, 60, 105, 2, 3, 6);
        float[][] priorsTwo = PriorsGen.genPriors(10, 32, 105, 150, 2, 3, 6);
        float[][] priorsCombined = new float[priorsOne.length + priorsTwo.length][4];
        for (i = 0; i < priorsOne.length; ++i) {
            for (j = 0; j < priorsOne[0].length; ++j) {
                priorsCombined[i][j] = ArrUtils.clamp(priorsOne[i][j], 0.0f, 1.0f);
            }
        }
        for (i = 0; i < priorsTwo.length; ++i) {
            for (j = 0; j < priorsTwo[0].length; ++j) {
                priorsCombined[i + priorsOne.length][j] = ArrUtils.clamp(priorsTwo[i][j], 0.0f, 1.0f);
            }
        }
        return priorsCombined;
    }
}

