/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.graphics.Bitmap;
import com.getbouncer.cardscan.base.CGRect;
import com.getbouncer.cardscan.base.RecognizedDigitsModel;
import java.util.ArrayList;
import java.util.Collections;

class RecognizedDigits {
    private static final int kNumPredictions = 17;
    private ArrayList<Integer> digits;
    private ArrayList<Float> confidence;
    private static final int kBackgroundClass = 10;
    private static final float kDigitMinConfidence = 0.15f;

    private RecognizedDigits(ArrayList<Integer> digits, ArrayList<Float> confidence) {
        this.digits = digits;
        this.confidence = confidence;
    }

    static RecognizedDigits from(RecognizedDigitsModel model, Bitmap image, CGRect box) {
        Bitmap frame = Bitmap.createBitmap((Bitmap)image, (int)Math.round(box.x), (int)Math.round(box.y), (int)((int)box.width), (int)((int)box.height));
        model.classifyFrame(frame);
        ArrayList<Integer> digits = new ArrayList<Integer>();
        ArrayList<Float> confidence = new ArrayList<Float>();
        for (int col = 0; col < 17; ++col) {
            RecognizedDigitsModel.ArgMaxAndConfidence argAndConf = model.argAndValueMax(col);
            if (argAndConf.confidence < 0.15f) {
                digits.add(10);
            } else {
                digits.add(argAndConf.argMax);
            }
            confidence.add(Float.valueOf(argAndConf.confidence));
        }
        return new RecognizedDigits(digits, confidence);
    }

    ArrayList<Integer> nonMaxSuppression() {
        ArrayList<Integer> digits = new ArrayList<Integer>();
        ArrayList<Float> confidence = new ArrayList<Float>();
        digits.addAll(this.digits);
        confidence.addAll(this.confidence);
        for (int idx = 0; idx < 16; ++idx) {
            if (digits.get(idx) == 10 || digits.get(idx + 1) == 10) continue;
            if (((Float)confidence.get(idx)).floatValue() < ((Float)confidence.get(idx + 1)).floatValue()) {
                digits.set(idx, 10);
                confidence.set(idx, Float.valueOf(1.0f));
                continue;
            }
            digits.set(idx + 1, 10);
            confidence.set(idx + 1, Float.valueOf(1.0f));
        }
        return digits;
    }

    String debugString() {
        ArrayList<Integer> digits = this.nonMaxSuppression();
        String result = "";
        for (Integer digit : digits) {
            if (digit != 10) {
                result = result + digit;
                continue;
            }
            result = result + "-";
        }
        return result;
    }

    String stringResult() {
        ArrayList<Integer> digits = this.nonMaxSuppression();
        String result = "";
        for (Integer digit : digits) {
            if (digit == 10) continue;
            result = result + digit;
        }
        return result;
    }

    String four() {
        ArrayList<Integer> digits = this.nonMaxSuppression();
        String result = this.stringResult();
        if (result.length() < 4) {
            return "";
        }
        boolean fromLeft = true;
        int leftIdx = 0;
        int rightIdx = digits.size() - 1;
        while (result.length() > 4) {
            if (fromLeft) {
                if (digits.get(leftIdx) != 10) {
                    result = result.substring(1);
                    digits.set(leftIdx, 10);
                }
                fromLeft = false;
                ++leftIdx;
                continue;
            }
            if (digits.get(rightIdx) != 10) {
                result = result.substring(0, result.length() - 1);
                digits.set(rightIdx, 10);
            }
            fromLeft = true;
            --rightIdx;
        }
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (int idx = 0; idx < digits.size(); ++idx) {
            if (digits.get(idx) == 10) continue;
            positions.add(idx);
        }
        ArrayList<Integer> deltas = new ArrayList<Integer>();
        for (int idx = 1; idx < positions.size(); ++idx) {
            deltas.add((Integer)positions.get(idx) - (Integer)positions.get(idx - 1));
        }
        Collections.sort(deltas);
        int maxDelta = (Integer)deltas.get(deltas.size() - 1);
        int minDelta = (Integer)deltas.get(0);
        if (maxDelta > minDelta + 1) {
            return "";
        }
        return result;
    }
}

