/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.graphics.Bitmap;
import com.getbouncer.cardscan.base.CGRect;
import com.getbouncer.cardscan.base.CreditCardUtils;
import com.getbouncer.cardscan.base.DetectedBox;
import com.getbouncer.cardscan.base.RecognizedDigits;
import com.getbouncer.cardscan.base.RecognizedDigitsModel;
import java.util.ArrayList;

class RecognizeNumbers {
    private final int numRows;
    private final int numCols;
    private RecognizedDigits[][] recognizedDigits;
    private String number = null;
    private ArrayList<CGRect> numberBoxes;
    private final Bitmap image;

    RecognizeNumbers(Bitmap image, int numRows, int numCols) {
        this.image = image;
        this.numRows = numRows;
        this.numCols = numCols;
        this.recognizedDigits = new RecognizedDigits[numRows][numCols];
    }

    String number(RecognizedDigitsModel model, ArrayList<ArrayList<DetectedBox>> lines) {
        for (ArrayList<DetectedBox> line : lines) {
            String candidateNumber = "";
            for (DetectedBox word : line) {
                RecognizedDigits recognized = this.cachedDigits(model, word);
                if (recognized == null) {
                    return null;
                }
                candidateNumber = candidateNumber + recognized.four();
            }
            if (candidateNumber.length() != 16 || !CreditCardUtils.luhnCheck(candidateNumber)) continue;
            this.number = candidateNumber;
            this.numberBoxes = new ArrayList();
            for (DetectedBox box : line) {
                this.numberBoxes.add(box.rect);
            }
            return candidateNumber;
        }
        return null;
    }

    private String recognizeAmexDigits(RecognizedDigitsModel model, ArrayList<DetectedBox> line) {
        int idx;
        ArrayList<RecognizedDigits> recognizedDigits = new ArrayList<RecognizedDigits>();
        for (DetectedBox box : line) {
            recognizedDigits.add(this.cachedDigits(model, box));
            String string = ((RecognizedDigits)recognizedDigits.get(recognizedDigits.size() - 1)).debugString();
        }
        int startCol = line.get((int)0).col;
        int numCols = line.get((int)(line.size() - 1)).col + 8 - startCol;
        int positionsPerBox = 16;
        int numPositions = numCols * 2;
        ArrayList<Integer> digits = new ArrayList<Integer>();
        for (idx = 0; idx < numPositions; ++idx) {
            digits.add(10);
        }
        for (int position = 0; position < numPositions; ++position) {
            for (int idx2 = 0; idx2 < line.size(); ++idx2) {
                DetectedBox box = line.get(idx2);
                RecognizedDigits recognized = (RecognizedDigits)recognizedDigits.get(idx2);
                int boxPosition = (box.col - startCol) * 2;
                if (position < boxPosition || position >= boxPosition + positionsPerBox) continue;
                int digitIdx = position - boxPosition;
                if ((Integer)digits.get(position) != 10) continue;
                digits.set(position, recognized.nonMaxSuppression().get(digitIdx));
            }
        }
        for (idx = 0; idx < digits.size() - 1; ++idx) {
            if (!((Integer)digits.get(idx)).equals(digits.get(idx + 1))) continue;
            digits.set(idx, 10);
        }
        String candidateNumber = "";
        for (Integer digit : digits) {
            if (digit == 10) continue;
            candidateNumber = candidateNumber + digit;
        }
        if (candidateNumber.length() == 15 && CreditCardUtils.luhnCheck(candidateNumber)) {
            return candidateNumber;
        }
        return null;
    }

    String amexNumber(RecognizedDigitsModel model, ArrayList<ArrayList<DetectedBox>> lines) {
        for (ArrayList<DetectedBox> line : lines) {
            String candidateNumber = this.recognizeAmexDigits(model, line);
            if (candidateNumber == null) continue;
            return candidateNumber;
        }
        return null;
    }

    private RecognizedDigits cachedDigits(RecognizedDigitsModel model, DetectedBox box) {
        if (this.recognizedDigits[box.row][box.col] == null) {
            this.recognizedDigits[box.row][box.col] = RecognizedDigits.from(model, this.image, box.rect);
        }
        return this.recognizedDigits[box.row][box.col];
    }
}

