/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.Context;
import com.getbouncer.cardscan.base.ImageClassifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;

class SSDDetect
extends ImageClassifier {
    private static final float IMAGE_MEAN = 127.5f;
    private static final float IMAGE_STD = 128.5f;
    private static final int CROP_SIZE = 300;
    private static final int NUM_THREADS = 4;
    private boolean isModelQuantized;
    static final int NUM_OF_PRIORS = 2766;
    static final int NUM_OF_PRIORS_PER_ACTIVATION = 6;
    static final int NUM_OF_CLASSES = 13;
    static final int NUM_OF_CORDINATES = 4;
    static final int NUM_LOC = 11064;
    static final int NUM_CLASS = 35958;
    static final float PROB_THRESHOLD = 0.3f;
    static final float IOU_THRESHOLD = 0.45f;
    static final float CENTER_VARIANCE = 0.1f;
    static final float SIZE_VARIANCE = 0.2f;
    static final int CANDIDATE_SIZE = 200;
    static final int TOP_K = 10;
    static final int[] featureMapSizes = new int[]{19, 10};
    private int inputSize;
    private int[] intValues;
    float[][] outputLocations;
    float[][] outputClasses;
    private Map<Integer, Object> outputMap = new HashMap<Integer, Object>();
    private File modelFile = null;

    public SSDDetect(Context context, File modelFile) throws IOException {
        this.modelFile = modelFile;
        this.init(context);
        this.outputLocations = new float[1][11064];
        this.outputClasses = new float[1][35958];
        this.outputMap.put(0, this.outputClasses);
        this.outputMap.put(1, this.outputLocations);
    }

    @Override
    MappedByteBuffer loadModelFile(Context context) throws IOException {
        FileInputStream inputStream = new FileInputStream(this.modelFile);
        FileChannel fileChannel = inputStream.getChannel();
        long startOffset = 0L;
        long declaredLength = this.modelFile.length();
        MappedByteBuffer result = fileChannel.map(FileChannel.MapMode.READ_ONLY, startOffset, declaredLength);
        inputStream.close();
        return result;
    }

    @Override
    protected int getImageSizeX() {
        return 300;
    }

    @Override
    protected int getImageSizeY() {
        return 300;
    }

    @Override
    protected int getNumBytesPerChannel() {
        return 4;
    }

    @Override
    protected void addPixelValue(int pixelValue) {
        this.imgData.putFloat(((float)(pixelValue >> 16 & 0xFF) - 127.5f) / 128.5f);
        this.imgData.putFloat(((float)(pixelValue >> 8 & 0xFF) - 127.5f) / 128.5f);
        this.imgData.putFloat(((float)(pixelValue & 0xFF) - 127.5f) / 127.5f);
    }

    @Override
    protected void runInference() {
        Object[] inputArray = new Object[]{this.imgData};
        this.tflite.runForMultipleInputsOutputs(inputArray, this.outputMap);
    }
}

