/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.SystemClock;
import android.util.Log;
import com.getbouncer.cardscan.base.GlobalConfig;
import com.getbouncer.cardscan.base.SSDDetect;
import com.getbouncer.cardscan.base.ssd.ArrUtils;
import com.getbouncer.cardscan.base.ssd.DetectedSSDBox;
import com.getbouncer.cardscan.base.ssd.PredictionAPI;
import com.getbouncer.cardscan.base.ssd.PriorsGen;
import com.getbouncer.cardscan.base.ssd.Result;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ObjectDetect {
    private static SSDDetect ssdDetect = null;
    private static float[][] priors = null;
    private final File ssdModelFile;
    public List<DetectedSSDBox> objectBoxes = new ArrayList<DetectedSSDBox>();
    boolean hadUnrecoverableException = false;
    public static boolean USE_GPU = false;

    static boolean isInit() {
        return ssdDetect != null;
    }

    public ObjectDetect(File modelFile) {
        this.ssdModelFile = modelFile;
    }

    private void ssdOutputToPredictions(Bitmap image) {
        ArrUtils arrUtils = new ArrUtils();
        float[][] k_boxes = arrUtils.rearrangeArray(ObjectDetect.ssdDetect.outputLocations, SSDDetect.featureMapSizes, 6, 4);
        k_boxes = arrUtils.reshape(k_boxes, 2766, 4);
        k_boxes = arrUtils.convertLocationsToBoxes(k_boxes, priors, 0.1f, 0.2f);
        k_boxes = arrUtils.centerFormToCornerForm(k_boxes);
        float[][] k_scores = arrUtils.rearrangeArray(ObjectDetect.ssdDetect.outputClasses, SSDDetect.featureMapSizes, 6, 13);
        k_scores = arrUtils.reshape(k_scores, 2766, 13);
        k_scores = arrUtils.softmax2D(k_scores);
        PredictionAPI predAPI = new PredictionAPI();
        Result result = predAPI.predictionAPI(k_scores, k_boxes, 0.3f, 0.45f, 200, 10);
        if (result.pickedBoxProbs.size() != 0 && result.pickedLabels.size() != 0) {
            for (int i = 0; i < result.pickedBoxProbs.size(); ++i) {
                DetectedSSDBox ssdBox = new DetectedSSDBox(result.pickedBoxes.get(i)[0], result.pickedBoxes.get(i)[1], result.pickedBoxes.get(i)[2], result.pickedBoxes.get(i)[3], result.pickedBoxProbs.get(i).floatValue(), image.getWidth(), image.getHeight(), result.pickedLabels.get(i));
                this.objectBoxes.add(ssdBox);
            }
        }
    }

    private String runModel(Bitmap image) {
        long startTime = SystemClock.uptimeMillis();
        ssdDetect.classifyFrame(image);
        if (GlobalConfig.PRINT_TIMING) {
            Log.e((String)"Before SSD Post Process", (String)String.valueOf(SystemClock.uptimeMillis() - startTime));
        }
        this.ssdOutputToPredictions(image);
        if (GlobalConfig.PRINT_TIMING) {
            Log.e((String)"After SSD Post Process", (String)String.valueOf(SystemClock.uptimeMillis() - startTime));
        }
        return "Success";
    }

    public synchronized String predict(Bitmap image, Context context) {
        int NUM_THREADS = 4;
        try {
            boolean createdNewModel = false;
            try {
                if (ssdDetect == null) {
                    ssdDetect = new SSDDetect(context, this.ssdModelFile);
                    ssdDetect.setNumThreads(4);
                    if (priors == null) {
                        priors = PriorsGen.combinePriors();
                    }
                }
            }
            catch (Error | Exception e) {
                Log.e((String)"SSD", (String)"Couldn't load ssd", (Throwable)e);
            }
            try {
                return this.runModel(image);
            }
            catch (Error | Exception e) {
                Log.i((String)"ObjectDetect", (String)"runModel exception, retry object detection", (Throwable)e);
                ssdDetect = new SSDDetect(context, this.ssdModelFile);
                return this.runModel(image);
            }
        }
        catch (Error | Exception e) {
            Log.e((String)"ObjectDetect", (String)"unrecoverable exception on ObjectDetect", (Throwable)e);
            this.hadUnrecoverableException = true;
            return null;
        }
    }
}

