/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import com.getbouncer.cardscan.base.DetectedBox;
import com.getbouncer.cardscan.base.FindFourModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

class PostDetectionAlgorithm {
    private final int kNumberWordCount = 4;
    private final int kAmexWordCount = 5;
    private final int kMaxBoxesToDetect = 20;
    private final int kDeltaRowForCombine = 2;
    private final int kDeltaColForCombine = 2;
    private final int kDeltaRowForHorizontalNumbers = 1;
    private final int kDeltaColForVerticalNumbers = 1;
    private ArrayList<DetectedBox> sortedBoxes;
    private final int numRows;
    private final int numCols;
    private static Comparator<DetectedBox> colCompare = new Comparator<DetectedBox>(){

        @Override
        public int compare(DetectedBox o1, DetectedBox o2) {
            return PostDetectionAlgorithm.integerCompare(o1.col, o2.col);
        }
    };
    private static Comparator<DetectedBox> rowCompare = new Comparator<DetectedBox>(){

        @Override
        public int compare(DetectedBox o1, DetectedBox o2) {
            return PostDetectionAlgorithm.integerCompare(o1.row, o2.row);
        }
    };

    private static int integerCompare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    PostDetectionAlgorithm(ArrayList<DetectedBox> boxes, FindFourModel findFour) {
        this.numCols = findFour.cols;
        this.numRows = findFour.rows;
        this.sortedBoxes = new ArrayList();
        Collections.sort(boxes);
        Collections.reverse(boxes);
        for (DetectedBox box : boxes) {
            if (this.sortedBoxes.size() >= 20) break;
            this.sortedBoxes.add(box);
        }
    }

    ArrayList<ArrayList<DetectedBox>> horizontalNumbers() {
        ArrayList<DetectedBox> boxes = this.combineCloseBoxes(2, 2);
        ArrayList<ArrayList<DetectedBox>> lines = this.findHorizontalNumbers(boxes, 4);
        ArrayList<ArrayList<DetectedBox>> linesOut = new ArrayList<ArrayList<DetectedBox>>();
        for (ArrayList<DetectedBox> line : lines) {
            int minDelta;
            ArrayList<Integer> deltas = new ArrayList<Integer>();
            for (int idx = 0; idx < line.size() - 1; ++idx) {
                deltas.add(line.get((int)(idx + 1)).col - line.get((int)idx).col);
            }
            Collections.sort(deltas);
            int maxDelta = (Integer)deltas.get(deltas.size() - 1);
            if (maxDelta - (minDelta = ((Integer)deltas.get(0)).intValue()) > 2) continue;
            linesOut.add(line);
        }
        return linesOut;
    }

    ArrayList<ArrayList<DetectedBox>> amexNumbers() {
        ArrayList<DetectedBox> boxes = this.combineCloseBoxes(2, 1);
        ArrayList<ArrayList<DetectedBox>> lines = this.findHorizontalNumbers(boxes, 5);
        ArrayList<ArrayList<DetectedBox>> linesOut = new ArrayList<ArrayList<DetectedBox>>();
        for (ArrayList<DetectedBox> line : lines) {
            ArrayList<Integer> colDeltas = new ArrayList<Integer>();
            for (int idx = 1; idx < line.size(); ++idx) {
                colDeltas.add(line.get((int)idx).col - line.get((int)(idx - 1)).col);
            }
            ArrayList evenColDeltas = new ArrayList();
            ArrayList oddColDeltas = new ArrayList();
            for (int idx = 0; idx < colDeltas.size(); ++idx) {
                if (idx % 2 == 0) {
                    evenColDeltas.add(colDeltas.get(idx));
                    continue;
                }
                oddColDeltas.add(colDeltas.get(idx));
            }
            boolean areGapsBigEnough = true;
            for (int idx = 0; idx < evenColDeltas.size(); ++idx) {
                float even = ((Integer)evenColDeltas.get(idx)).intValue();
                float odd = ((Integer)oddColDeltas.get(idx)).intValue();
                areGapsBigEnough = areGapsBigEnough && (double)(even / odd) >= 2.0;
            }
            if (!areGapsBigEnough) continue;
            linesOut.add(line);
        }
        return linesOut;
    }

    ArrayList<ArrayList<DetectedBox>> verticalNumbers() {
        ArrayList<DetectedBox> boxes = this.combineCloseBoxes(2, 2);
        ArrayList<ArrayList<DetectedBox>> lines = this.findVerticalNumbers(boxes);
        ArrayList<ArrayList<DetectedBox>> linesOut = new ArrayList<ArrayList<DetectedBox>>();
        for (ArrayList<DetectedBox> line : lines) {
            int minDelta;
            ArrayList<Integer> deltas = new ArrayList<Integer>();
            for (int idx = 0; idx < line.size() - 1; ++idx) {
                deltas.add(line.get((int)(idx + 1)).row - line.get((int)idx).row);
            }
            Collections.sort(deltas);
            int maxDelta = (Integer)deltas.get(deltas.size() - 1);
            if (maxDelta - (minDelta = ((Integer)deltas.get(0)).intValue()) > 2) continue;
            linesOut.add(line);
        }
        return linesOut;
    }

    private boolean horizontalPredicate(DetectedBox currentWord, DetectedBox nextWord) {
        int deltaRow = 1;
        return nextWord.col > currentWord.col && nextWord.row >= currentWord.row - deltaRow && nextWord.row <= currentWord.row + deltaRow;
    }

    private boolean verticalPredicate(DetectedBox currentWord, DetectedBox nextWord) {
        int deltaCol = 1;
        return nextWord.row > currentWord.row && nextWord.col >= currentWord.col - deltaCol && nextWord.col <= currentWord.col + deltaCol;
    }

    private void findNumbers(ArrayList<DetectedBox> currentLine, ArrayList<DetectedBox> words, boolean useHorizontalPredicate, int numberOfBoxes, ArrayList<ArrayList<DetectedBox>> lines) {
        if (currentLine.size() == numberOfBoxes) {
            lines.add(currentLine);
            return;
        }
        if (words.size() == 0) {
            return;
        }
        DetectedBox currentWord = currentLine.get(currentLine.size() - 1);
        if (currentWord == null) {
            return;
        }
        for (int idx = 0; idx < words.size(); ++idx) {
            ArrayList<DetectedBox> newCurrentLine;
            DetectedBox word = words.get(idx);
            if (useHorizontalPredicate && this.horizontalPredicate(currentWord, word)) {
                newCurrentLine = new ArrayList<DetectedBox>();
                newCurrentLine.addAll(currentLine);
                newCurrentLine.add(word);
                this.findNumbers(newCurrentLine, this.dropFirst(words, idx + 1), useHorizontalPredicate, numberOfBoxes, lines);
                continue;
            }
            if (!this.verticalPredicate(currentWord, word)) continue;
            newCurrentLine = new ArrayList();
            newCurrentLine.addAll(currentLine);
            newCurrentLine.add(word);
            this.findNumbers(newCurrentLine, this.dropFirst(words, idx + 1), useHorizontalPredicate, numberOfBoxes, lines);
        }
    }

    private ArrayList<DetectedBox> dropFirst(ArrayList<DetectedBox> boxes, int n) {
        ArrayList<DetectedBox> result = new ArrayList<DetectedBox>();
        for (int idx = n; idx < boxes.size(); ++idx) {
            result.add(boxes.get(idx));
        }
        return result;
    }

    private ArrayList<ArrayList<DetectedBox>> findHorizontalNumbers(ArrayList<DetectedBox> words, int numberOfBoxes) {
        Collections.sort(words, colCompare);
        ArrayList<ArrayList<DetectedBox>> lines = new ArrayList<ArrayList<DetectedBox>>();
        for (int idx = 0; idx < words.size(); ++idx) {
            ArrayList<DetectedBox> currentLine = new ArrayList<DetectedBox>();
            currentLine.add(words.get(idx));
            this.findNumbers(currentLine, this.dropFirst(words, idx + 1), true, numberOfBoxes, lines);
        }
        return lines;
    }

    private ArrayList<ArrayList<DetectedBox>> findVerticalNumbers(ArrayList<DetectedBox> words) {
        int numberOfBoxes = 4;
        Collections.sort(words, rowCompare);
        ArrayList<ArrayList<DetectedBox>> lines = new ArrayList<ArrayList<DetectedBox>>();
        for (int idx = 0; idx < words.size(); ++idx) {
            ArrayList<DetectedBox> currentLine = new ArrayList<DetectedBox>();
            currentLine.add(words.get(idx));
            this.findNumbers(currentLine, this.dropFirst(words, idx + 1), false, numberOfBoxes, lines);
        }
        return lines;
    }

    private ArrayList<DetectedBox> combineCloseBoxes(int deltaRow, int deltaCol) {
        boolean[][] cardGrid = new boolean[this.numRows][this.numCols];
        for (int row = 0; row < this.numRows; ++row) {
            for (int col = 0; col < this.numCols; ++col) {
                cardGrid[row][col] = false;
            }
        }
        for (DetectedBox box : this.sortedBoxes) {
            cardGrid[box.row][box.col] = true;
        }
        for (DetectedBox box : this.sortedBoxes) {
            if (!cardGrid[box.row][box.col]) continue;
            for (int row = box.row - deltaRow; row <= box.row + deltaRow; ++row) {
                for (int col = box.col - deltaCol; col <= box.col + deltaCol; ++col) {
                    if (row < 0 || row >= this.numRows || col < 0 || col >= this.numCols) continue;
                    cardGrid[row][col] = false;
                }
            }
            cardGrid[box.row][box.col] = true;
        }
        ArrayList<DetectedBox> combinedBoxes = new ArrayList<DetectedBox>();
        for (DetectedBox box : this.sortedBoxes) {
            if (!cardGrid[box.row][box.col]) continue;
            combinedBoxes.add(box);
        }
        return combinedBoxes;
    }
}

