/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.SystemClock;
import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.Interpreter;
import org.tensorflow.lite.gpu.GpuDelegate;

abstract class ImageClassifier {
    private static final String TAG = "CardScan";
    private static final int DIM_BATCH_SIZE = 1;
    private static final int DIM_PIXEL_SIZE = 3;
    private int[] intValues = new int[this.getImageSizeX() * this.getImageSizeY()];
    private final Interpreter.Options tfliteOptions = new Interpreter.Options();
    private MappedByteBuffer tfliteModel;
    protected Interpreter tflite;
    protected ByteBuffer imgData = null;
    GpuDelegate gpuDelegate = null;

    ImageClassifier(Context context) throws IOException {
        this.tfliteModel = this.loadModelFile(context);
        this.tflite = new Interpreter((ByteBuffer)this.tfliteModel, this.tfliteOptions);
        this.imgData = ByteBuffer.allocateDirect(1 * this.getImageSizeX() * this.getImageSizeY() * 3 * this.getNumBytesPerChannel());
        this.imgData.order(ByteOrder.nativeOrder());
        Log.d((String)TAG, (String)"Created a Tensorflow Lite Image Classifier.");
    }

    void classifyFrame(Bitmap bitmap) {
        if (this.tflite == null) {
            Log.e((String)TAG, (String)"Image classifier has not been initialized; Skipped.");
        }
        this.convertBitmapToByteBuffer(bitmap);
        long startTime = SystemClock.uptimeMillis();
        this.runInference();
        long endTime = SystemClock.uptimeMillis();
    }

    private void recreateInterpreter() {
        if (this.tflite != null) {
            this.tflite.close();
            this.tflite = new Interpreter((ByteBuffer)this.tfliteModel, this.tfliteOptions);
        }
    }

    public void useCPU() {
        this.tfliteOptions.setUseNNAPI(false);
        this.recreateInterpreter();
    }

    public void useGpu() {
        if (this.gpuDelegate == null) {
            this.gpuDelegate = new GpuDelegate();
            this.tfliteOptions.addDelegate((Delegate)this.gpuDelegate);
            this.recreateInterpreter();
        }
    }

    public void useNNAPI() {
        this.tfliteOptions.setUseNNAPI(true);
        this.recreateInterpreter();
    }

    public void setNumThreads(int numThreads) {
        this.tfliteOptions.setNumThreads(numThreads);
        this.recreateInterpreter();
    }

    public void close() {
        this.tflite.close();
        this.tflite = null;
        if (this.gpuDelegate != null) {
            this.gpuDelegate.close();
            this.gpuDelegate = null;
        }
        this.tfliteModel = null;
    }

    abstract MappedByteBuffer loadModelFile(Context var1) throws IOException;

    private void convertBitmapToByteBuffer(Bitmap bitmap) {
        if (this.imgData == null) {
            return;
        }
        this.imgData.rewind();
        Bitmap resizedBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.getImageSizeX(), (int)this.getImageSizeY(), (boolean)false);
        resizedBitmap.getPixels(this.intValues, 0, resizedBitmap.getWidth(), 0, 0, resizedBitmap.getWidth(), resizedBitmap.getHeight());
        int pixel = 0;
        long startTime = SystemClock.uptimeMillis();
        for (int i = 0; i < this.getImageSizeX(); ++i) {
            for (int j = 0; j < this.getImageSizeY(); ++j) {
                int val = this.intValues[pixel++];
                this.addPixelValue(val);
            }
        }
        long endTime = SystemClock.uptimeMillis();
    }

    protected abstract int getImageSizeX();

    protected abstract int getImageSizeY();

    protected abstract int getNumBytesPerChannel();

    protected abstract void addPixelValue(int var1);

    protected abstract void runInference();
}

