/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.RectF;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.VisibleForTesting;
import android.support.test.espresso.idling.CountingIdlingResource;
import android.util.Log;
import android.view.OrientationEventListener;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.getbouncer.cardscan.base.Api;
import com.getbouncer.cardscan.base.CreditCardUtils;
import com.getbouncer.cardscan.base.DetectedBox;
import com.getbouncer.cardscan.base.Expiry;
import com.getbouncer.cardscan.base.IdleResourceManager;
import com.getbouncer.cardscan.base.MachineLearningThread;
import com.getbouncer.cardscan.base.OnScanListener;
import com.getbouncer.cardscan.base.Overlay;
import com.getbouncer.cardscan.base.ScanStats;
import com.getbouncer.cardscan.base.TestingImageReaderInternal;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;

public abstract class ScanBaseActivity
extends Activity
implements Camera.PreviewCallback,
View.OnClickListener,
OnScanListener {
    private Camera mCamera = null;
    private OrientationEventListener mOrientationEventListener;
    private static MachineLearningThread machineLearningThread = null;
    private Semaphore mMachineLearningSemaphore = new Semaphore(1);
    private int mRotation;
    private boolean mSentResponse = false;
    private boolean mIsActivityActive = false;
    private HashMap<String, Integer> numberResults = new HashMap();
    private HashMap<Expiry, Integer> expiryResults = new HashMap();
    private long firstResultMs = 0L;
    private int mFlashlightId;
    private int mCardNumberId;
    private int mExpiryId;
    private int mTextureId;
    private float mRoiCenterYRatio;
    private ScanStats scanStats;
    public static String RESULT_FATAL_ERROR = "result_fatal_error";
    public static TestingImageReaderInternal sTestingImageReader = null;
    private TestingImageReaderInternal mTestingImageReader = null;
    private CountingIdlingResource mScanningIdleResource = null;
    public long mPredictionStartMs = 0L;
    public boolean mIsPermissionCheckDone = false;
    protected boolean mShowNumberAndExpiryAsScanning = true;
    public long errorCorrectionDurationMs = 1500L;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mTestingImageReader = sTestingImageReader;
        sTestingImageReader = null;
        this.mScanningIdleResource = IdleResourceManager.scanningIdleResource;
        IdleResourceManager.scanningIdleResource = null;
        if (this.mScanningIdleResource != null) {
            this.mScanningIdleResource.increment();
        }
        this.scanStats = new ScanStats();
        this.mOrientationEventListener = new OrientationEventListener((Context)this){

            public void onOrientationChanged(int orientation) {
                ScanBaseActivity.this.orientationChanged(orientation);
            }
        };
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (grantResults[0] == 0) {
            this.mIsPermissionCheckDone = true;
        } else {
            this.finish();
        }
    }

    protected void startCamera() {
        this.numberResults = new HashMap();
        this.expiryResults = new HashMap();
        this.firstResultMs = 0L;
        if (this.mOrientationEventListener.canDetectOrientation()) {
            this.mOrientationEventListener.enable();
        }
        try {
            if (this.mIsPermissionCheckDone) {
                this.mCamera = Camera.open();
                this.setCameraDisplayOrientation(this, 0, this.mCamera);
                CameraPreview cameraPreview = new CameraPreview((Context)this, this);
                FrameLayout preview = (FrameLayout)this.findViewById(this.mTextureId);
                preview.addView((View)cameraPreview);
                this.mCamera.setPreviewCallback((Camera.PreviewCallback)this);
            }
        }
        catch (Exception e) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setMessage((CharSequence)"Another app is using the camera").setTitle((CharSequence)"Can't open camera");
            builder.setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    ScanBaseActivity.this.finish();
                }
            });
            AlertDialog dialog = builder.create();
            dialog.show();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
            this.mCamera.setPreviewCallback(null);
            this.mCamera.release();
        }
        this.mOrientationEventListener.disable();
        this.mIsActivityActive = false;
    }

    protected void onResume() {
        super.onResume();
        this.mIsActivityActive = true;
        this.scanStats = new ScanStats();
        this.firstResultMs = 0L;
        this.numberResults = new HashMap();
        this.expiryResults = new HashMap();
        this.mSentResponse = false;
        this.findViewById(this.mCardNumberId).setVisibility(4);
        this.findViewById(this.mExpiryId).setVisibility(4);
        this.startCamera();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public void setViewIds(int flashlightId, int cardRectangleId, int overlayId, int textureId, int cardNumberId, int expiryId) {
        this.mFlashlightId = flashlightId;
        this.mTextureId = textureId;
        this.mCardNumberId = cardNumberId;
        this.mExpiryId = expiryId;
        int mCardRectangleId = cardNumberId;
        this.findViewById(flashlightId).setOnClickListener((View.OnClickListener)this);
        this.findViewById(cardRectangleId).getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)new MyGlobalListenerClass(cardRectangleId, overlayId));
    }

    public void orientationChanged(int orientation) {
        if (orientation == -1) {
            return;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)info);
        orientation = (orientation + 45) / 90 * 90;
        int rotation = 0;
        rotation = info.facing == 1 ? (info.orientation - orientation + 360) % 360 : (info.orientation + orientation) % 360;
        if (this.mCamera != null) {
            Camera.Parameters params = this.mCamera.getParameters();
            params.setRotation(rotation);
            this.mCamera.setParameters(params);
        }
    }

    public void setCameraDisplayOrientation(Activity activity, int cameraId, Camera camera) {
        int result;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        camera.setDisplayOrientation(result);
        this.mRotation = result;
    }

    public static void warmUp(Context context) {
        ScanBaseActivity.getMachineLearningThread().warmUp(context);
    }

    public static MachineLearningThread getMachineLearningThread() {
        if (machineLearningThread == null) {
            machineLearningThread = new MachineLearningThread();
            new Thread(machineLearningThread).start();
        }
        return machineLearningThread;
    }

    public void onPreviewFrame(byte[] bytes, Camera camera) {
        if (this.mMachineLearningSemaphore.tryAcquire()) {
            this.scanStats.incrementScans();
            MachineLearningThread mlThread = ScanBaseActivity.getMachineLearningThread();
            Camera.Parameters parameters = camera.getParameters();
            int width = parameters.getPreviewSize().width;
            int height = parameters.getPreviewSize().height;
            int format = parameters.getPreviewFormat();
            this.mPredictionStartMs = SystemClock.uptimeMillis();
            if (this.mTestingImageReader == null) {
                mlThread.post(bytes, width, height, format, this.mRotation, this, this.getApplicationContext(), this.mRoiCenterYRatio);
            } else {
                Bitmap bm = this.mTestingImageReader.nextImage();
                mlThread.post(bm, this, this.getApplicationContext());
                if (bm == null) {
                    this.mTestingImageReader = null;
                }
            }
        }
    }

    public void onClick(View view) {
        if (this.mCamera != null && this.mFlashlightId == view.getId()) {
            Camera.Parameters parameters = this.mCamera.getParameters();
            if (parameters.getFlashMode().equals("torch")) {
                parameters.setFlashMode("off");
            } else {
                parameters.setFlashMode("torch");
            }
            this.mCamera.setParameters(parameters);
            this.mCamera.startPreview();
        }
    }

    public void onBackPressed() {
        if (!this.mSentResponse && this.mIsActivityActive) {
            this.scanStats.setSuccess(false);
            Api.fraudCheck((Context)this, this.scanStats);
            this.mSentResponse = true;
            Intent intent = new Intent();
            this.setResult(0, intent);
            this.finish();
            if (this.mScanningIdleResource != null) {
                this.mScanningIdleResource.decrement();
            }
        }
    }

    @VisibleForTesting(otherwise=2)
    public void incrementNumber(String number) {
        Integer currentValue = this.numberResults.get(number);
        if (currentValue == null) {
            currentValue = 0;
        }
        this.numberResults.put(number, currentValue + 1);
    }

    @VisibleForTesting(otherwise=2)
    public void incrementExpiry(Expiry expiry) {
        Integer currentValue = this.expiryResults.get(expiry);
        if (currentValue == null) {
            currentValue = 0;
        }
        this.expiryResults.put(expiry, currentValue + 1);
    }

    @VisibleForTesting(otherwise=2)
    public String getNumberResult() {
        String result = null;
        int maxValue = 0;
        for (String number : this.numberResults.keySet()) {
            int value = 0;
            Integer count = this.numberResults.get(number);
            if (count != null) {
                value = count;
            }
            if (value <= maxValue) continue;
            result = number;
            maxValue = value;
        }
        return result;
    }

    @VisibleForTesting(otherwise=2)
    public Expiry getExpiryResult() {
        Expiry result = null;
        int maxValue = 0;
        for (Expiry expiry : this.expiryResults.keySet()) {
            int value = 0;
            Integer count = this.expiryResults.get(expiry);
            if (count != null) {
                value = count;
            }
            if (value <= maxValue) continue;
            result = expiry;
            maxValue = value;
        }
        return result;
    }

    private void setValueAnimated(TextView textView, String value) {
        if (textView.getVisibility() != 0) {
            textView.setVisibility(0);
            textView.setAlpha(0.0f);
            textView.animate().setDuration(400L).alpha(1.0f);
        }
        textView.setText((CharSequence)value);
    }

    protected abstract void onCardScanned(String var1, String var2, String var3);

    protected void setNumberAndExpiryAnimated(long duration) {
        String numberResult = this.getNumberResult();
        Expiry expiryResult = this.getExpiryResult();
        TextView textView = (TextView)this.findViewById(this.mCardNumberId);
        this.setValueAnimated(textView, CreditCardUtils.format(numberResult));
        if (expiryResult != null && duration >= this.errorCorrectionDurationMs / 2L) {
            textView = (TextView)this.findViewById(this.mExpiryId);
            this.setValueAnimated(textView, expiryResult.format());
        }
    }

    @Override
    public void onFatalError() {
        Intent intent = new Intent();
        intent.putExtra(RESULT_FATAL_ERROR, true);
        this.setResult(0, intent);
        this.finish();
    }

    @Override
    public void onPrediction(String number, Expiry expiry, Bitmap bitmap, List<DetectedBox> digitBoxes, DetectedBox expiryBox) {
        if (!this.mSentResponse && this.mIsActivityActive) {
            if (number != null && this.firstResultMs == 0L) {
                this.firstResultMs = SystemClock.uptimeMillis();
            }
            if (number != null) {
                this.incrementNumber(number);
            }
            if (expiry != null) {
                this.incrementExpiry(expiry);
            }
            long duration = SystemClock.uptimeMillis() - this.firstResultMs;
            if (this.firstResultMs != 0L && this.mShowNumberAndExpiryAsScanning) {
                this.setNumberAndExpiryAnimated(duration);
            }
            if (this.firstResultMs != 0L && duration >= this.errorCorrectionDurationMs) {
                this.mSentResponse = true;
                String numberResult = this.getNumberResult();
                Expiry expiryResult = this.getExpiryResult();
                String month = null;
                String year = null;
                if (expiryResult != null) {
                    month = Integer.toString(expiryResult.month);
                    year = Integer.toString(expiryResult.year);
                }
                this.scanStats.setSuccess(true);
                Api.fraudCheck((Context)this, this.scanStats);
                this.onCardScanned(numberResult, month, year);
                if (this.mScanningIdleResource != null) {
                    this.mScanningIdleResource.decrement();
                }
            }
        }
        this.mMachineLearningSemaphore.release();
    }

    public class CameraPreview
    extends SurfaceView
    implements Camera.AutoFocusCallback,
    SurfaceHolder.Callback {
        private SurfaceHolder mHolder;
        private Camera.PreviewCallback mPreviewCallback;

        public CameraPreview(Context context, Camera.PreviewCallback previewCallback) {
            super(context);
            this.mPreviewCallback = previewCallback;
            this.mHolder = this.getHolder();
            this.mHolder.addCallback((SurfaceHolder.Callback)this);
            this.mHolder.setType(3);
            Camera.Parameters params = ScanBaseActivity.this.mCamera.getParameters();
            List focusModes = params.getSupportedFocusModes();
            if (focusModes.contains("continuous-picture")) {
                params.setFocusMode("continuous-picture");
            } else if (focusModes.contains("continuous-video")) {
                params.setFocusMode("continuous-video");
            }
            params.setRecordingHint(true);
            ScanBaseActivity.this.mCamera.setParameters(params);
        }

        public void onAutoFocus(boolean success, Camera camera) {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            try {
                ScanBaseActivity.this.mCamera.setPreviewDisplay(holder);
                ScanBaseActivity.this.mCamera.startPreview();
            }
            catch (IOException e) {
                Log.d((String)"CameraCaptureActivity", (String)("Error setting camera preview: " + e.getMessage()));
            }
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
            if (this.mHolder.getSurface() == null) {
                return;
            }
            try {
                ScanBaseActivity.this.mCamera.stopPreview();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ScanBaseActivity.this.mCamera.setPreviewDisplay(this.mHolder);
                ScanBaseActivity.this.mCamera.setPreviewCallback(this.mPreviewCallback);
                ScanBaseActivity.this.mCamera.startPreview();
            }
            catch (Exception e) {
                Log.d((String)"CameraCaptureActivity", (String)("Error starting camera preview: " + e.getMessage()));
            }
        }
    }

    class MyGlobalListenerClass
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private final int cardRectangleId;
        private final int overlayId;

        MyGlobalListenerClass(int cardRectangleId, int overlayId) {
            this.cardRectangleId = cardRectangleId;
            this.overlayId = overlayId;
        }

        public void onGlobalLayout() {
            int[] xy = new int[2];
            View view = ScanBaseActivity.this.findViewById(this.cardRectangleId);
            view.getLocationOnScreen(xy);
            int radius = (int)(11.0f * Resources.getSystem().getDisplayMetrics().density);
            RectF rect = new RectF((float)xy[0], (float)xy[1], (float)(xy[0] + view.getWidth()), (float)(xy[1] + view.getHeight()));
            Overlay overlay = (Overlay)ScanBaseActivity.this.findViewById(this.overlayId);
            overlay.setCircle(rect, radius);
            ScanBaseActivity.this.mRoiCenterYRatio = ((float)xy[1] + (float)view.getHeight() * 0.5f) / (float)overlay.getHeight();
        }
    }
}

