/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.getbouncer.cardscan.base.ScanStats;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;

public class Api {
    public static String baseUrl = "https://api.getbouncer.com";
    public static String apiKey = null;

    private static JSONObject getUnknownErrorResponse() {
        JSONObject response = new JSONObject();
        try {
            response.put("status", (Object)"error");
            response.put("error_code", (Object)"network_error");
            response.put("error_message", (Object)"Network error");
        }
        catch (JSONException e1) {
            e1.printStackTrace();
        }
        return response;
    }

    private static JSONObject getApiUrlNotSet() {
        JSONObject response = new JSONObject();
        try {
            response.put("status", (Object)"error");
            response.put("error_code", (Object)"api_baseurl_not_set");
            response.put("error_message", (Object)"Your API.baseUrl or token isn't set");
        }
        catch (JSONException e1) {
            e1.printStackTrace();
        }
        return response;
    }

    @NonNull
    static void fraudCheck(Context context, ScanStats scanStats) {
        try {
            JSONObject args = new JSONObject();
            args.put("platform", (Object)"android");
            String ssaid = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            args.put("vendor_id", (Object)ssaid);
            args.put("safety_net", null);
            args.put("scan_stats", (Object)scanStats.toJson());
            Api.makeApiCallPost(baseUrl + "/fraud_check", args);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static String downloadString(HttpURLConnection urlConnection) throws IOException, JSONException {
        String data;
        StringWriter responseBody;
        InputStreamReader in = new InputStreamReader(urlConnection.getInputStream());
        int contentLen = urlConnection.getContentLength();
        StringWriter stringWriter = responseBody = contentLen > 0 ? new StringWriter(contentLen) : new StringWriter();
        do {
            if (TextUtils.isEmpty((CharSequence)(data = Api.readIt2(in, 4096)))) continue;
            responseBody.append(data);
        } while (data != null);
        return responseBody.toString();
    }

    private static void makeApiCallPost(final String url, final JSONObject args) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Api.makeApiCallPostImplementation(url, args);
            }
        }).start();
    }

    private static JSONObject makeApiCallPostImplementation(String url, JSONObject args) {
        HttpURLConnection urlConnection = null;
        try {
            if (TextUtils.isEmpty((CharSequence)baseUrl) || TextUtils.isEmpty((CharSequence)apiKey)) {
                return Api.getApiUrlNotSet();
            }
            urlConnection = (HttpURLConnection)new URL(url).openConnection();
            if (!TextUtils.isEmpty((CharSequence)apiKey)) {
                urlConnection.setRequestProperty("x-bouncer-auth", apiKey);
            }
            urlConnection.setDoOutput(true);
            byte[] content = args.toString().getBytes("UTF-8");
            urlConnection.setFixedLengthStreamingMode(content.length);
            BufferedOutputStream out = new BufferedOutputStream(urlConnection.getOutputStream());
            ((OutputStream)out).write(content);
            ((OutputStream)out).flush();
            return new JSONObject(Api.downloadString(urlConnection));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Api.getUnknownErrorResponse();
        }
    }

    private static String readIt2(InputStreamReader stream, int len) throws IOException {
        char[] buffer = new char[len];
        int ret = stream.read(buffer);
        if (ret < 0) {
            return null;
        }
        return new String(buffer, 0, ret);
    }
}

