/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.getbouncer.cardscan.base.CGSize;
import com.getbouncer.cardscan.base.DetectedBox;
import com.getbouncer.cardscan.base.Expiry;
import com.getbouncer.cardscan.base.FindFourModel;
import com.getbouncer.cardscan.base.PostDetectionAlgorithm;
import com.getbouncer.cardscan.base.RecognizeNumbers;
import com.getbouncer.cardscan.base.RecognizedDigitsModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class Ocr {
    private static FindFourModel findFour = null;
    private static RecognizedDigitsModel recognizedDigitsModel = null;
    List<DetectedBox> digitBoxes = new ArrayList<DetectedBox>();
    DetectedBox expiryBox = null;
    Expiry expiry = null;
    boolean hadUnrecoverableException = false;

    Ocr() {
    }

    static boolean isInit() {
        return findFour != null && recognizedDigitsModel != null;
    }

    private ArrayList<DetectedBox> detectBoxes(Bitmap image) {
        ArrayList<DetectedBox> boxes = new ArrayList<DetectedBox>();
        for (int row = 0; row < Ocr.findFour.rows; ++row) {
            for (int col = 0; col < Ocr.findFour.cols; ++col) {
                if (!findFour.hasDigits(row, col)) continue;
                float confidence = findFour.digitConfidence(row, col);
                CGSize imageSize = new CGSize(image.getWidth(), image.getHeight());
                DetectedBox box = new DetectedBox(row, col, confidence, Ocr.findFour.rows, Ocr.findFour.cols, Ocr.findFour.boxSize, Ocr.findFour.cardSize, imageSize);
                boxes.add(box);
            }
        }
        return boxes;
    }

    private ArrayList<DetectedBox> detectExpiry(Bitmap image) {
        ArrayList<DetectedBox> boxes = new ArrayList<DetectedBox>();
        for (int row = 0; row < Ocr.findFour.rows; ++row) {
            for (int col = 0; col < Ocr.findFour.cols; ++col) {
                if (!findFour.hasExpiry(row, col)) continue;
                float confidence = findFour.expiryConfidence(row, col);
                CGSize imageSize = new CGSize(image.getWidth(), image.getHeight());
                DetectedBox box = new DetectedBox(row, col, confidence, Ocr.findFour.rows, Ocr.findFour.cols, Ocr.findFour.boxSize, Ocr.findFour.cardSize, imageSize);
                boxes.add(box);
            }
        }
        return boxes;
    }

    private String runModel(Bitmap image) {
        findFour.classifyFrame(image);
        ArrayList<DetectedBox> boxes = this.detectBoxes(image);
        ArrayList<DetectedBox> expiryBoxes = this.detectExpiry(image);
        PostDetectionAlgorithm postDetection = new PostDetectionAlgorithm(boxes, findFour);
        RecognizeNumbers recognizeNumbers = new RecognizeNumbers(image, Ocr.findFour.rows, Ocr.findFour.cols);
        ArrayList<ArrayList<DetectedBox>> lines = postDetection.horizontalNumbers();
        String algorithm = null;
        String number = recognizeNumbers.number(recognizedDigitsModel, lines);
        if (number == null) {
            ArrayList<ArrayList<DetectedBox>> verticalLines = postDetection.verticalNumbers();
            number = recognizeNumbers.number(recognizedDigitsModel, verticalLines);
            lines.addAll(verticalLines);
        } else {
            algorithm = "horizontal";
        }
        if (number == null) {
            ArrayList<ArrayList<DetectedBox>> amexLines = postDetection.amexNumbers();
            number = recognizeNumbers.amexNumber(recognizedDigitsModel, amexLines);
            lines.addAll((Collection<ArrayList<DetectedBox>>)amexLines);
            if (number != null) {
                algorithm = "amex";
            }
        } else {
            algorithm = "vertical";
        }
        boxes = new ArrayList();
        for (ArrayList arrayList : lines) {
            boxes.addAll(arrayList);
        }
        this.expiry = null;
        if (expiryBoxes.size() > 0) {
            Collections.sort(expiryBoxes);
            DetectedBox expiryBox = expiryBoxes.get(expiryBoxes.size() - 1);
            this.expiry = Expiry.from(recognizedDigitsModel, image, expiryBox.rect);
            this.expiryBox = this.expiry != null ? expiryBox : null;
        }
        this.digitBoxes = boxes;
        return number;
    }

    public synchronized String predict(Bitmap image, Context context) {
        try {
            if (findFour == null) {
                findFour = new FindFourModel(context);
                try {
                    findFour.useGpu();
                }
                catch (Error | Exception e) {
                    Log.i((String)"Ocr", (String)"useGpu exception, falling back to CPU", (Throwable)e);
                    findFour = new FindFourModel(context);
                }
            }
            if (recognizedDigitsModel == null) {
                recognizedDigitsModel = new RecognizedDigitsModel(context);
            }
            try {
                return this.runModel(image);
            }
            catch (Error | Exception e) {
                Log.i((String)"Ocr", (String)"runModel exception, retry prediction", (Throwable)e);
                findFour = new FindFourModel(context);
                return this.runModel(image);
            }
        }
        catch (Error | Exception e) {
            Log.e((String)"Ocr", (String)"unrecoverable exception on Ocr", (Throwable)e);
            this.hadUnrecoverableException = true;
            return null;
        }
    }
}

