/*
 * Decompiled with CFR 0.152.
 */
package com.getbouncer.cardscan.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.os.Handler;
import android.os.Looper;
import com.getbouncer.cardscan.base.Ocr;
import com.getbouncer.cardscan.base.OnScanListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.LinkedList;

class MachineLearningThread
implements Runnable {
    private LinkedList<RunArguments> queue = new LinkedList();

    MachineLearningThread() {
    }

    public synchronized void warmUp(Context context) {
        if (Ocr.isInit() || !this.queue.isEmpty()) {
            return;
        }
        RunArguments args = new RunArguments(null, 0, 0, 0, 90, null, context, 0.5f);
        this.queue.push(args);
        this.notify();
    }

    synchronized void post(Bitmap bitmap, OnScanListener scanListener, Context context) {
        RunArguments args = new RunArguments(bitmap, scanListener, context);
        this.queue.push(args);
        this.notify();
    }

    synchronized void post(byte[] bytes, int width, int height, int format, int sensorOrientation, OnScanListener scanListener, Context context, float roiCenterYRatio) {
        RunArguments args = new RunArguments(bytes, width, height, format, sensorOrientation, scanListener, context, roiCenterYRatio);
        this.queue.push(args);
        this.notify();
    }

    private Bitmap getBitmap(byte[] bytes, int width, int height, int format, int sensorOrientation, float roiCenterYRatio) {
        YuvImage yuv = new YuvImage(bytes, format, width, height, null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        yuv.compressToJpeg(new Rect(0, 0, width, height), 100, (OutputStream)out);
        byte[] b = out.toByteArray();
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])b, (int)0, (int)b.length);
        Matrix matrix = new Matrix();
        matrix.postRotate((float)sensorOrientation);
        Bitmap bm = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        double w = bm.getWidth();
        double h = 302.0 * w / 480.0;
        int x = 0;
        int y = (int)Math.round((double)bm.getHeight() * (double)roiCenterYRatio - h * 0.5);
        Bitmap result = Bitmap.createBitmap((Bitmap)bm, (int)x, (int)y, (int)((int)w), (int)((int)h));
        bitmap.recycle();
        bm.recycle();
        return result;
    }

    private synchronized RunArguments getNextImage() {
        while (this.queue.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.queue.pop();
    }

    private void runModel() {
        Bitmap bm;
        final RunArguments args = this.getNextImage();
        if (args.mFrameBytes != null) {
            bm = this.getBitmap(args.mFrameBytes, args.mWidth, args.mHeight, args.mFormat, args.mSensorOrientation, args.mRoiCenterYRatio);
        } else if (args.mBitmap != null) {
            bm = args.mBitmap;
        } else {
            bm = Bitmap.createBitmap((int)480, (int)302, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bm);
            Paint paint = new Paint();
            paint.setColor(-7829368);
            canvas.drawRect(0.0f, 0.0f, 480.0f, 302.0f, paint);
        }
        final Bitmap bitmap = bm;
        final Ocr ocr = new Ocr();
        final String number = ocr.predict(bitmap, args.mContext);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (args.mScanListener != null) {
                        args.mScanListener.onPrediction(number, ocr.expiry, bitmap, ocr.digitBoxes, ocr.expiryBox);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                bitmap.recycle();
            }
        });
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.runModel();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    class RunArguments {
        private final byte[] mFrameBytes;
        private final Bitmap mBitmap;
        private final OnScanListener mScanListener;
        private final Context mContext;
        private final int mWidth;
        private final int mHeight;
        private final int mFormat;
        private final int mSensorOrientation;
        private final float mRoiCenterYRatio;

        RunArguments(byte[] frameBytes, int width, int height, int format, int sensorOrientation, OnScanListener scanListener, Context context, float roiCenterYRatio) {
            this.mFrameBytes = frameBytes;
            this.mBitmap = null;
            this.mWidth = width;
            this.mHeight = height;
            this.mFormat = format;
            this.mScanListener = scanListener;
            this.mContext = context;
            this.mSensorOrientation = sensorOrientation;
            this.mRoiCenterYRatio = roiCenterYRatio;
        }

        RunArguments(Bitmap bitmap, OnScanListener scanListener, Context context) {
            this.mFrameBytes = null;
            this.mBitmap = bitmap;
            this.mWidth = bitmap == null ? 0 : bitmap.getWidth();
            this.mHeight = bitmap == null ? 0 : bitmap.getHeight();
            this.mFormat = 0;
            this.mScanListener = scanListener;
            this.mContext = context;
            this.mSensorOrientation = 0;
            this.mRoiCenterYRatio = 0.0f;
        }
    }
}

