/*
 * Decompiled with CFR 0.152.
 */
package com.futuremind.recyclerviewfastscroll;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.widget.TextViewCompat;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.futuremind.recyclerviewfastscroll.FastScrollBubble;
import com.futuremind.recyclerviewfastscroll.R;
import com.futuremind.recyclerviewfastscroll.SectionTitleProvider;
import com.futuremind.recyclerviewfastscroll.Utils;

public class FastScroller
extends LinearLayout {
    private int handleColor;
    private int bubbleColor;
    private int bubbleTextAppearance;
    private FastScrollBubble bubble;
    private ImageView handle;
    private int bubbleOffset;
    private int scrollerOrientation;
    private RecyclerView recyclerView;
    private final ScrollListener scrollListener = new ScrollListener();
    private boolean manuallyChangingPosition;
    private SectionTitleProvider titleProvider;

    public FastScroller(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FastScroller(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setClipChildren(false);
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        inflater.inflate(R.layout.fastscroll__scroller, (ViewGroup)this);
        TypedArray style = context.obtainStyledAttributes(attrs, R.styleable.fastscroll__fastScroller, R.attr.fastscroll__style, 0);
        try {
            this.bubbleColor = style.getColor(R.styleable.fastscroll__fastScroller_fastscroll__bubbleColor, ContextCompat.getColor((Context)context, (int)17170443));
            this.handleColor = style.getColor(R.styleable.fastscroll__fastScroller_fastscroll__handleColor, ContextCompat.getColor((Context)context, (int)0x1060000));
            this.bubbleTextAppearance = style.getResourceId(R.styleable.fastscroll__fastScroller_fastscroll__bubbleTextAppearance, 16973886);
        }
        finally {
            style.recycle();
        }
    }

    public void setOrientation(int orientation) {
        this.scrollerOrientation = orientation;
        super.setOrientation(orientation == 0 ? 1 : 0);
    }

    public void setRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
        if (recyclerView.getAdapter() instanceof SectionTitleProvider) {
            this.titleProvider = (SectionTitleProvider)recyclerView.getAdapter();
        }
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.scrollListener);
        this.invalidateVisibility();
        recyclerView.setOnHierarchyChangeListener(new ViewGroup.OnHierarchyChangeListener(){

            public void onChildViewAdded(View parent, View child) {
                FastScroller.this.invalidateVisibility();
            }

            public void onChildViewRemoved(View parent, View child) {
                FastScroller.this.invalidateVisibility();
            }
        });
    }

    public void setBubbleColor(int color) {
        this.bubbleColor = color;
        this.invalidate();
    }

    public void setHandleColor(int color) {
        this.handleColor = color;
        this.invalidate();
    }

    public void setBubbleTextAppearance(int resId) {
        this.bubbleTextAppearance = resId;
        this.invalidate();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.bubble = (FastScrollBubble)this.findViewById(R.id.fastscroller_bubble);
        this.handle = (ImageView)this.findViewById(R.id.fastscroller_handle);
        TextView defaultBubble = (TextView)this.bubble.getChildAt(0);
        this.bubbleOffset = (int)(this.isVertical() ? (float)this.handle.getHeight() / 2.0f - (float)this.bubble.getHeight() : (float)this.handle.getWidth() / 2.0f - (float)this.bubble.getWidth());
        this.initHandleBackground();
        this.initHandleMovement();
        this.setBackgroundTint((View)defaultBubble, this.bubbleColor);
        this.setImageTint(this.handle, this.handleColor);
        TextViewCompat.setTextAppearance((TextView)defaultBubble, (int)this.bubbleTextAppearance);
    }

    private void setBackgroundTint(View view, int color) {
        Drawable background = DrawableCompat.wrap((Drawable)view.getBackground());
        DrawableCompat.setTint((Drawable)background, (int)color);
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(background);
        } else {
            view.setBackgroundDrawable(background);
        }
    }

    private void setImageTint(ImageView view, int color) {
        Drawable image = DrawableCompat.wrap((Drawable)view.getDrawable());
        DrawableCompat.setTint((Drawable)image, (int)color);
        view.setImageDrawable(image);
    }

    private void initHandleBackground() {
        this.handle.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)(this.isVertical() ? R.drawable.fastscroll__handle_vertical : R.drawable.fastscroll__handle_horizontal)));
    }

    private void initHandleMovement() {
        this.handle.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0 || event.getAction() == 2) {
                    if (FastScroller.this.titleProvider != null) {
                        FastScroller.this.bubble.show();
                    }
                    FastScroller.this.manuallyChangingPosition = true;
                    float relativePos = FastScroller.this.getRelativeTouchPosition(event);
                    FastScroller.this.setHandlePosition(relativePos);
                    FastScroller.this.setRecyclerViewPosition(relativePos);
                    return true;
                }
                if (event.getAction() == 1) {
                    FastScroller.this.manuallyChangingPosition = false;
                    if (FastScroller.this.titleProvider != null) {
                        FastScroller.this.bubble.hide();
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private float getRelativeTouchPosition(MotionEvent event) {
        if (this.isVertical()) {
            float yInParent = event.getRawY() - Utils.getViewRawY((View)this.handle);
            return yInParent / (float)(this.getHeight() - this.handle.getHeight());
        }
        float xInParent = event.getRawX() - Utils.getViewRawX((View)this.handle);
        return xInParent / (float)(this.getWidth() - this.handle.getWidth());
    }

    private void invalidateVisibility() {
        if (this.recyclerView.getAdapter() == null || this.recyclerView.getAdapter().getItemCount() == 0 || this.recyclerView.getChildAt(0) == null || this.isRecyclerViewScrollable()) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
        }
    }

    private boolean isRecyclerViewScrollable() {
        if (this.isVertical()) {
            return this.recyclerView.getChildAt(0).getHeight() * this.recyclerView.getAdapter().getItemCount() <= this.getHeight();
        }
        return this.recyclerView.getChildAt(0).getWidth() * this.recyclerView.getAdapter().getItemCount() <= this.getWidth();
    }

    private void setRecyclerViewPosition(float relativePos) {
        if (this.recyclerView != null) {
            int itemCount = this.recyclerView.getAdapter().getItemCount();
            int targetPos = (int)Utils.getValueInRange(0.0f, itemCount - 1, (int)(relativePos * (float)itemCount));
            this.recyclerView.scrollToPosition(targetPos);
            if (this.titleProvider != null) {
                this.bubble.setText(this.titleProvider.getSectionTitle(targetPos));
            }
        }
    }

    private void setHandlePosition(float relativePos) {
        if (this.isVertical()) {
            this.bubble.setY(Utils.getValueInRange(0.0f, this.getHeight() - this.bubble.getHeight(), relativePos * (float)(this.getHeight() - this.handle.getHeight()) + (float)this.bubbleOffset));
            this.handle.setY(Utils.getValueInRange(0.0f, this.getHeight() - this.handle.getHeight(), relativePos * (float)(this.getHeight() - this.handle.getHeight())));
        } else {
            this.bubble.setX(Utils.getValueInRange(0.0f, this.getWidth() - this.bubble.getWidth(), relativePos * (float)(this.getWidth() - this.handle.getWidth()) + (float)this.bubbleOffset));
            this.handle.setX(Utils.getValueInRange(0.0f, this.getWidth() - this.handle.getWidth(), relativePos * (float)(this.getWidth() - this.handle.getWidth())));
        }
    }

    private boolean isVertical() {
        return this.scrollerOrientation == 1;
    }

    private class ScrollListener
    extends RecyclerView.OnScrollListener {
        private ScrollListener() {
        }

        public void onScrolled(RecyclerView rv, int dx, int dy) {
            if (FastScroller.this.handle != null && !FastScroller.this.manuallyChangingPosition && FastScroller.this.recyclerView.getChildCount() > 0) {
                float relativePos;
                if (FastScroller.this.isVertical()) {
                    int offset = FastScroller.this.recyclerView.computeVerticalScrollOffset();
                    int extent = FastScroller.this.recyclerView.computeVerticalScrollExtent();
                    int range = FastScroller.this.recyclerView.computeVerticalScrollRange();
                    relativePos = (float)offset / (float)(range - extent);
                } else {
                    int offset = FastScroller.this.recyclerView.computeHorizontalScrollOffset();
                    int extent = FastScroller.this.recyclerView.computeHorizontalScrollExtent();
                    int range = FastScroller.this.recyclerView.computeHorizontalScrollRange();
                    relativePos = (float)offset / (float)(range - extent);
                }
                FastScroller.this.setHandlePosition(relativePos);
            }
        }
    }
}

