/*
 * Decompiled with CFR 0.152.
 */
package com.dd;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.StateSet;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.dd.CircularAnimatedDrawable;
import com.dd.CircularProgressDrawable;
import com.dd.MorphingAnimation;
import com.dd.OnAnimationEndListener;
import com.dd.StateManager;
import com.dd.StrokeGradientDrawable;
import com.dd.circular.progress.button.R;

public class CircularProgressButton
extends Button {
    public static final int IDLE_STATE_PROGRESS = 0;
    public static final int ERROR_STATE_PROGRESS = -1;
    public static final int SUCCESS_STATE_PROGRESS = 100;
    public static final int INDETERMINATE_STATE_PROGRESS = 50;
    private StrokeGradientDrawable background;
    private CircularAnimatedDrawable mAnimatedDrawable;
    private CircularProgressDrawable mProgressDrawable;
    private ColorStateList mIdleColorState;
    private ColorStateList mCompleteColorState;
    private ColorStateList mErrorColorState;
    private StateListDrawable mIdleStateDrawable;
    private StateListDrawable mCompleteStateDrawable;
    private StateListDrawable mErrorStateDrawable;
    private StateManager mStateManager;
    private State mState;
    private String mIdleText;
    private String mCompleteText;
    private String mErrorText;
    private String mProgressText;
    private int mColorProgress;
    private int mColorIndicator;
    private int mColorIndicatorBackground;
    private int mIconComplete;
    private int mIconError;
    private int mStrokeWidth;
    private int mPaddingProgress;
    private float mCornerRadius;
    private boolean mIndeterminateProgressMode;
    private boolean mConfigurationChanged;
    private int mMaxProgress;
    private int mProgress;
    private boolean mMorphingInProgress;
    private OnAnimationEndListener mProgressStateListener = new OnAnimationEndListener(){

        @Override
        public void onAnimationEnd() {
            CircularProgressButton.this.mMorphingInProgress = false;
            CircularProgressButton.this.mState = State.PROGRESS;
            CircularProgressButton.this.mStateManager.checkState(CircularProgressButton.this);
        }
    };
    private OnAnimationEndListener mCompleteStateListener = new OnAnimationEndListener(){

        @Override
        public void onAnimationEnd() {
            if (CircularProgressButton.this.mIconComplete != 0) {
                CircularProgressButton.this.setText(null);
                CircularProgressButton.this.setIcon(CircularProgressButton.this.mIconComplete);
            } else {
                CircularProgressButton.this.setText(CircularProgressButton.this.mCompleteText);
            }
            CircularProgressButton.this.mMorphingInProgress = false;
            CircularProgressButton.this.mState = State.COMPLETE;
            CircularProgressButton.this.mStateManager.checkState(CircularProgressButton.this);
        }
    };
    private OnAnimationEndListener mIdleStateListener = new OnAnimationEndListener(){

        @Override
        public void onAnimationEnd() {
            CircularProgressButton.this.removeIcon();
            CircularProgressButton.this.setText(CircularProgressButton.this.mIdleText);
            CircularProgressButton.this.mMorphingInProgress = false;
            CircularProgressButton.this.mState = State.IDLE;
            CircularProgressButton.this.mStateManager.checkState(CircularProgressButton.this);
        }
    };
    private OnAnimationEndListener mErrorStateListener = new OnAnimationEndListener(){

        @Override
        public void onAnimationEnd() {
            if (CircularProgressButton.this.mIconError != 0) {
                CircularProgressButton.this.setText(null);
                CircularProgressButton.this.setIcon(CircularProgressButton.this.mIconError);
            } else {
                CircularProgressButton.this.setText(CircularProgressButton.this.mErrorText);
            }
            CircularProgressButton.this.mMorphingInProgress = false;
            CircularProgressButton.this.mState = State.ERROR;
            CircularProgressButton.this.mStateManager.checkState(CircularProgressButton.this);
        }
    };

    public CircularProgressButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public CircularProgressButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CircularProgressButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.mStrokeWidth = (int)this.getContext().getResources().getDimension(R.dimen.cpb_stroke_width);
        this.initAttributes(context, attributeSet);
        this.mMaxProgress = 100;
        this.mState = State.IDLE;
        this.mStateManager = new StateManager(this);
        this.setText(this.mIdleText);
        this.initIdleStateDrawable();
        this.setBackgroundCompat((Drawable)this.mIdleStateDrawable);
    }

    private void initErrorStateDrawable() {
        int colorPressed = this.getPressedColor(this.mErrorColorState);
        StrokeGradientDrawable drawablePressed = this.createDrawable(colorPressed);
        this.mErrorStateDrawable = new StateListDrawable();
        this.mErrorStateDrawable.addState(new int[]{16842919}, (Drawable)drawablePressed.getGradientDrawable());
        this.mErrorStateDrawable.addState(StateSet.WILD_CARD, (Drawable)this.background.getGradientDrawable());
    }

    private void initCompleteStateDrawable() {
        int colorPressed = this.getPressedColor(this.mCompleteColorState);
        StrokeGradientDrawable drawablePressed = this.createDrawable(colorPressed);
        this.mCompleteStateDrawable = new StateListDrawable();
        this.mCompleteStateDrawable.addState(new int[]{16842919}, (Drawable)drawablePressed.getGradientDrawable());
        this.mCompleteStateDrawable.addState(StateSet.WILD_CARD, (Drawable)this.background.getGradientDrawable());
    }

    private void initIdleStateDrawable() {
        int colorNormal = this.getNormalColor(this.mIdleColorState);
        int colorPressed = this.getPressedColor(this.mIdleColorState);
        int colorFocused = this.getFocusedColor(this.mIdleColorState);
        int colorDisabled = this.getDisabledColor(this.mIdleColorState);
        if (this.background == null) {
            this.background = this.createDrawable(colorNormal);
        }
        StrokeGradientDrawable drawableDisabled = this.createDrawable(colorDisabled);
        StrokeGradientDrawable drawableFocused = this.createDrawable(colorFocused);
        StrokeGradientDrawable drawablePressed = this.createDrawable(colorPressed);
        this.mIdleStateDrawable = new StateListDrawable();
        this.mIdleStateDrawable.addState(new int[]{16842919}, (Drawable)drawablePressed.getGradientDrawable());
        this.mIdleStateDrawable.addState(new int[]{16842908}, (Drawable)drawableFocused.getGradientDrawable());
        this.mIdleStateDrawable.addState(new int[]{-16842910}, (Drawable)drawableDisabled.getGradientDrawable());
        this.mIdleStateDrawable.addState(StateSet.WILD_CARD, (Drawable)this.background.getGradientDrawable());
    }

    private int getNormalColor(ColorStateList colorStateList) {
        return colorStateList.getColorForState(new int[]{16842910}, 0);
    }

    private int getPressedColor(ColorStateList colorStateList) {
        return colorStateList.getColorForState(new int[]{16842919}, 0);
    }

    private int getFocusedColor(ColorStateList colorStateList) {
        return colorStateList.getColorForState(new int[]{16842908}, 0);
    }

    private int getDisabledColor(ColorStateList colorStateList) {
        return colorStateList.getColorForState(new int[]{-16842910}, 0);
    }

    private StrokeGradientDrawable createDrawable(int color2) {
        GradientDrawable drawable2 = (GradientDrawable)this.getResources().getDrawable(R.drawable.cpb_background).mutate();
        drawable2.setColor(color2);
        drawable2.setCornerRadius(this.mCornerRadius);
        StrokeGradientDrawable strokeGradientDrawable = new StrokeGradientDrawable(drawable2);
        strokeGradientDrawable.setStrokeColor(color2);
        strokeGradientDrawable.setStrokeWidth(this.mStrokeWidth);
        return strokeGradientDrawable;
    }

    protected void drawableStateChanged() {
        if (this.mState == State.COMPLETE) {
            this.initCompleteStateDrawable();
            this.setBackgroundCompat((Drawable)this.mCompleteStateDrawable);
        } else if (this.mState == State.IDLE) {
            this.initIdleStateDrawable();
            this.setBackgroundCompat((Drawable)this.mIdleStateDrawable);
        } else if (this.mState == State.ERROR) {
            this.initErrorStateDrawable();
            this.setBackgroundCompat((Drawable)this.mErrorStateDrawable);
        }
        if (this.mState != State.PROGRESS) {
            super.drawableStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes(Context context, AttributeSet attributeSet) {
        TypedArray attr2 = this.getTypedArray(context, attributeSet, R.styleable.CircularProgressButton);
        if (attr2 == null) {
            return;
        }
        try {
            this.mIdleText = attr2.getString(R.styleable.CircularProgressButton_cpb_textIdle);
            this.mCompleteText = attr2.getString(R.styleable.CircularProgressButton_cpb_textComplete);
            this.mErrorText = attr2.getString(R.styleable.CircularProgressButton_cpb_textError);
            this.mProgressText = attr2.getString(R.styleable.CircularProgressButton_cpb_textProgress);
            this.mIconComplete = attr2.getResourceId(R.styleable.CircularProgressButton_cpb_iconComplete, 0);
            this.mIconError = attr2.getResourceId(R.styleable.CircularProgressButton_cpb_iconError, 0);
            this.mCornerRadius = attr2.getDimension(R.styleable.CircularProgressButton_cpb_cornerRadius, 0.0f);
            this.mPaddingProgress = attr2.getDimensionPixelSize(R.styleable.CircularProgressButton_cpb_paddingProgress, 0);
            int blue = this.getColor(R.color.cpb_blue);
            int white = this.getColor(R.color.cpb_white);
            int grey = this.getColor(R.color.cpb_grey);
            int idleStateSelector = attr2.getResourceId(R.styleable.CircularProgressButton_cpb_selectorIdle, R.color.cpb_idle_state_selector);
            this.mIdleColorState = this.getResources().getColorStateList(idleStateSelector);
            int completeStateSelector = attr2.getResourceId(R.styleable.CircularProgressButton_cpb_selectorComplete, R.color.cpb_complete_state_selector);
            this.mCompleteColorState = this.getResources().getColorStateList(completeStateSelector);
            int errorStateSelector = attr2.getResourceId(R.styleable.CircularProgressButton_cpb_selectorError, R.color.cpb_error_state_selector);
            this.mErrorColorState = this.getResources().getColorStateList(errorStateSelector);
            this.mColorProgress = attr2.getColor(R.styleable.CircularProgressButton_cpb_colorProgress, white);
            this.mColorIndicator = attr2.getColor(R.styleable.CircularProgressButton_cpb_colorIndicator, blue);
            this.mColorIndicatorBackground = attr2.getColor(R.styleable.CircularProgressButton_cpb_colorIndicatorBackground, grey);
        }
        finally {
            attr2.recycle();
        }
    }

    protected int getColor(int id) {
        return this.getResources().getColor(id);
    }

    protected TypedArray getTypedArray(Context context, AttributeSet attributeSet, int[] attr2) {
        return context.obtainStyledAttributes(attributeSet, attr2, 0, 0);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mProgress > 0 && this.mState == State.PROGRESS && !this.mMorphingInProgress) {
            if (this.mIndeterminateProgressMode) {
                this.drawIndeterminateProgress(canvas);
            } else {
                this.drawProgress(canvas);
            }
        }
    }

    private void drawIndeterminateProgress(Canvas canvas) {
        if (this.mAnimatedDrawable == null) {
            int offset = (this.getWidth() - this.getHeight()) / 2;
            this.mAnimatedDrawable = new CircularAnimatedDrawable(this.mColorIndicator, this.mStrokeWidth);
            int left = offset + this.mPaddingProgress;
            int right = this.getWidth() - offset - this.mPaddingProgress;
            int bottom = this.getHeight() - this.mPaddingProgress;
            int top = this.mPaddingProgress;
            this.mAnimatedDrawable.setBounds(left, top, right, bottom);
            this.mAnimatedDrawable.setCallback((Drawable.Callback)this);
            this.mAnimatedDrawable.start();
        } else {
            this.mAnimatedDrawable.draw(canvas);
        }
    }

    private void drawProgress(Canvas canvas) {
        if (this.mProgressDrawable == null) {
            int offset = (this.getWidth() - this.getHeight()) / 2;
            int size = this.getHeight() - this.mPaddingProgress * 2;
            this.mProgressDrawable = new CircularProgressDrawable(size, this.mStrokeWidth, this.mColorIndicator);
            int left = offset + this.mPaddingProgress;
            this.mProgressDrawable.setBounds(left, this.mPaddingProgress, left, this.mPaddingProgress);
        }
        float sweepAngle = 360.0f / (float)this.mMaxProgress * (float)this.mProgress;
        this.mProgressDrawable.setSweepAngle(sweepAngle);
        this.mProgressDrawable.draw(canvas);
    }

    public boolean isIndeterminateProgressMode() {
        return this.mIndeterminateProgressMode;
    }

    public void setIndeterminateProgressMode(boolean indeterminateProgressMode) {
        this.mIndeterminateProgressMode = indeterminateProgressMode;
    }

    protected boolean verifyDrawable(Drawable who) {
        return who == this.mAnimatedDrawable || super.verifyDrawable(who);
    }

    private MorphingAnimation createMorphing() {
        this.mMorphingInProgress = true;
        MorphingAnimation animation = new MorphingAnimation((TextView)this, this.background);
        animation.setFromCornerRadius(this.mCornerRadius);
        animation.setToCornerRadius(this.mCornerRadius);
        animation.setFromWidth(this.getWidth());
        animation.setToWidth(this.getWidth());
        if (this.mConfigurationChanged) {
            animation.setDuration(1);
        } else {
            animation.setDuration(400);
        }
        this.mConfigurationChanged = false;
        return animation;
    }

    private MorphingAnimation createProgressMorphing(float fromCorner, float toCorner, int fromWidth, int toWidth) {
        this.mMorphingInProgress = true;
        MorphingAnimation animation = new MorphingAnimation((TextView)this, this.background);
        animation.setFromCornerRadius(fromCorner);
        animation.setToCornerRadius(toCorner);
        animation.setPadding(this.mPaddingProgress);
        animation.setFromWidth(fromWidth);
        animation.setToWidth(toWidth);
        if (this.mConfigurationChanged) {
            animation.setDuration(1);
        } else {
            animation.setDuration(400);
        }
        this.mConfigurationChanged = false;
        return animation;
    }

    private void morphToProgress() {
        this.setWidth(this.getWidth());
        this.setText(this.mProgressText);
        MorphingAnimation animation = this.createProgressMorphing(this.mCornerRadius, this.getHeight(), this.getWidth(), this.getHeight());
        animation.setFromColor(this.getNormalColor(this.mIdleColorState));
        animation.setToColor(this.mColorProgress);
        animation.setFromStrokeColor(this.getNormalColor(this.mIdleColorState));
        animation.setToStrokeColor(this.mColorIndicatorBackground);
        animation.setListener(this.mProgressStateListener);
        animation.start();
    }

    private void morphProgressToComplete() {
        MorphingAnimation animation = this.createProgressMorphing(this.getHeight(), this.mCornerRadius, this.getHeight(), this.getWidth());
        animation.setFromColor(this.mColorProgress);
        animation.setToColor(this.getNormalColor(this.mCompleteColorState));
        animation.setFromStrokeColor(this.mColorIndicator);
        animation.setToStrokeColor(this.getNormalColor(this.mCompleteColorState));
        animation.setListener(this.mCompleteStateListener);
        animation.start();
    }

    private void morphIdleToComplete() {
        MorphingAnimation animation = this.createMorphing();
        animation.setFromColor(this.getNormalColor(this.mIdleColorState));
        animation.setToColor(this.getNormalColor(this.mCompleteColorState));
        animation.setFromStrokeColor(this.getNormalColor(this.mIdleColorState));
        animation.setToStrokeColor(this.getNormalColor(this.mCompleteColorState));
        animation.setListener(this.mCompleteStateListener);
        animation.start();
    }

    private void morphCompleteToIdle() {
        MorphingAnimation animation = this.createMorphing();
        animation.setFromColor(this.getNormalColor(this.mCompleteColorState));
        animation.setToColor(this.getNormalColor(this.mIdleColorState));
        animation.setFromStrokeColor(this.getNormalColor(this.mCompleteColorState));
        animation.setToStrokeColor(this.getNormalColor(this.mIdleColorState));
        animation.setListener(this.mIdleStateListener);
        animation.start();
    }

    private void morphErrorToIdle() {
        MorphingAnimation animation = this.createMorphing();
        animation.setFromColor(this.getNormalColor(this.mErrorColorState));
        animation.setToColor(this.getNormalColor(this.mIdleColorState));
        animation.setFromStrokeColor(this.getNormalColor(this.mErrorColorState));
        animation.setToStrokeColor(this.getNormalColor(this.mIdleColorState));
        animation.setListener(this.mIdleStateListener);
        animation.start();
    }

    private void morphIdleToError() {
        MorphingAnimation animation = this.createMorphing();
        animation.setFromColor(this.getNormalColor(this.mIdleColorState));
        animation.setToColor(this.getNormalColor(this.mErrorColorState));
        animation.setFromStrokeColor(this.getNormalColor(this.mIdleColorState));
        animation.setToStrokeColor(this.getNormalColor(this.mErrorColorState));
        animation.setListener(this.mErrorStateListener);
        animation.start();
    }

    private void morphProgressToError() {
        MorphingAnimation animation = this.createProgressMorphing(this.getHeight(), this.mCornerRadius, this.getHeight(), this.getWidth());
        animation.setFromColor(this.mColorProgress);
        animation.setToColor(this.getNormalColor(this.mErrorColorState));
        animation.setFromStrokeColor(this.mColorIndicator);
        animation.setToStrokeColor(this.getNormalColor(this.mErrorColorState));
        animation.setListener(this.mErrorStateListener);
        animation.start();
    }

    private void morphProgressToIdle() {
        MorphingAnimation animation = this.createProgressMorphing(this.getHeight(), this.mCornerRadius, this.getHeight(), this.getWidth());
        animation.setFromColor(this.mColorProgress);
        animation.setToColor(this.getNormalColor(this.mIdleColorState));
        animation.setFromStrokeColor(this.mColorIndicator);
        animation.setToStrokeColor(this.getNormalColor(this.mIdleColorState));
        animation.setListener(new OnAnimationEndListener(){

            @Override
            public void onAnimationEnd() {
                CircularProgressButton.this.removeIcon();
                CircularProgressButton.this.setText(CircularProgressButton.this.mIdleText);
                CircularProgressButton.this.mMorphingInProgress = false;
                CircularProgressButton.this.mState = State.IDLE;
                CircularProgressButton.this.mStateManager.checkState(CircularProgressButton.this);
            }
        });
        animation.start();
    }

    private void setIcon(int icon) {
        Drawable drawable2 = this.getResources().getDrawable(icon);
        if (drawable2 != null) {
            int padding = this.getWidth() / 2 - drawable2.getIntrinsicWidth() / 2;
            this.setCompoundDrawablesWithIntrinsicBounds(icon, 0, 0, 0);
            this.setPadding(padding, 0, 0, 0);
        }
    }

    protected void removeIcon() {
        this.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        this.setPadding(0, 0, 0, 0);
    }

    @SuppressLint(value={"NewApi"})
    public void setBackgroundCompat(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(drawable2);
        } else {
            this.setBackgroundDrawable(drawable2);
        }
    }

    public void setProgress(int progress) {
        this.mProgress = progress;
        if (this.mMorphingInProgress || this.getWidth() == 0) {
            return;
        }
        this.mStateManager.saveProgress(this);
        if (this.mProgress >= this.mMaxProgress) {
            if (this.mState == State.PROGRESS) {
                this.morphProgressToComplete();
            } else if (this.mState == State.IDLE) {
                this.morphIdleToComplete();
            }
        } else if (this.mProgress > 0) {
            if (this.mState == State.IDLE) {
                this.morphToProgress();
            } else if (this.mState == State.PROGRESS) {
                this.invalidate();
            }
        } else if (this.mProgress == -1) {
            if (this.mState == State.PROGRESS) {
                this.morphProgressToError();
            } else if (this.mState == State.IDLE) {
                this.morphIdleToError();
            }
        } else if (this.mProgress == 0) {
            if (this.mState == State.COMPLETE) {
                this.morphCompleteToIdle();
            } else if (this.mState == State.PROGRESS) {
                this.morphProgressToIdle();
            } else if (this.mState == State.ERROR) {
                this.morphErrorToIdle();
            }
        }
    }

    public int getProgress() {
        return this.mProgress;
    }

    public void setBackgroundColor(int color2) {
        this.background.getGradientDrawable().setColor(color2);
    }

    public void setStrokeColor(int color2) {
        this.background.setStrokeColor(color2);
    }

    public String getIdleText() {
        return this.mIdleText;
    }

    public String getCompleteText() {
        return this.mCompleteText;
    }

    public String getErrorText() {
        return this.mErrorText;
    }

    public void setIdleText(String text) {
        this.mIdleText = text;
    }

    public void setCompleteText(String text) {
        this.mCompleteText = text;
    }

    public void setErrorText(String text) {
        this.mErrorText = text;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.setProgress(this.mProgress);
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.mProgress = this.mProgress;
        savedState.mIndeterminateProgressMode = this.mIndeterminateProgressMode;
        savedState.mConfigurationChanged = true;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            SavedState savedState = (SavedState)state;
            this.mProgress = savedState.mProgress;
            this.mIndeterminateProgressMode = savedState.mIndeterminateProgressMode;
            this.mConfigurationChanged = savedState.mConfigurationChanged;
            super.onRestoreInstanceState(savedState.getSuperState());
            this.setProgress(this.mProgress);
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        private boolean mIndeterminateProgressMode;
        private boolean mConfigurationChanged;
        private int mProgress;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable parcel) {
            super(parcel);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mProgress = in.readInt();
            this.mIndeterminateProgressMode = in.readInt() == 1;
            this.mConfigurationChanged = in.readInt() == 1;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mProgress);
            out.writeInt(this.mIndeterminateProgressMode ? 1 : 0);
            out.writeInt(this.mConfigurationChanged ? 1 : 0);
        }
    }

    private static enum State {
        PROGRESS,
        IDLE,
        COMPLETE,
        ERROR;

    }
}

