/*
 * Decompiled with CFR 0.152.
 */
package com.fpliu.newton.log;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.fpliu.newton.log.Logger$$Lambda$1;
import com.fpliu.newton.log.Logger$$Lambda$4;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Locale;
import okio.Okio;
import okio.Sink;

public final class Logger {
    private static boolean ENABLED = true;
    private static String PREFIX = "Logger_";
    private static Context appContext;

    private Logger() {
    }

    public static void init(Context appContext) {
        Logger.appContext = appContext;
    }

    public static void init(Context appContext, String prefix) {
        Logger.appContext = appContext;
        PREFIX = prefix;
    }

    public static void init(Context appContext, String prefix, boolean enabled) {
        Logger.appContext = appContext;
        PREFIX = prefix;
        ENABLED = enabled;
    }

    public static int v(String tag, String msg) {
        return ENABLED ? Log.v((String)(PREFIX + tag), (String)("" + msg)) : 0;
    }

    public static int d(String tag, String msg) {
        if ("GEM-703L".equals(Build.MODEL) || "H60-L11".equals(Build.MODEL)) {
            return Logger.i(tag, msg);
        }
        return ENABLED ? Log.d((String)(PREFIX + tag), (String)("" + msg)) : 0;
    }

    public static int i(String tag, String msg) {
        return ENABLED ? Log.i((String)(PREFIX + tag), (String)("" + msg)) : 0;
    }

    public static int w(String tag, String msg) {
        return ENABLED ? Log.w((String)(PREFIX + tag), (String)("" + msg)) : 0;
    }

    public static int e(String tag, String msg) {
        return ENABLED ? Log.e((String)(PREFIX + tag), (String)("" + msg)) : 0;
    }

    public static int e(String tag, String msg, Throwable throwable) {
        return ENABLED ? Log.e((String)(PREFIX + tag), (String)msg, (Throwable)throwable) : 0;
    }

    public static String getExceptionTrace(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static void asyncSaveFile(File logFile, String content) {
        if (logFile == null || TextUtils.isEmpty((CharSequence)content)) {
            return;
        }
        Observable.create((ObservableOnSubscribe)Logger$$Lambda$1.lambdaFactory$(logFile, content)).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).subscribe(Logger$$Lambda$4.lambdaFactory$());
    }

    public static boolean syncSaveFile(File logFile, Throwable throwable) {
        if (logFile == null || throwable == null) {
            return false;
        }
        String content = Logger.getEnvironmentInfo(appContext).append(Logger.getExceptionTrace(throwable)).toString();
        return Logger.syncSaveFile(logFile, content);
    }

    public static boolean syncSaveFile(File logFile, String content) {
        if (logFile == null || TextUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        try {
            Okio.buffer((Sink)Okio.appendingSink((File)logFile)).writeUtf8(content).close();
            return true;
        }
        catch (IOException e) {
            Logger.e(PREFIX, "syncSaveFile()", e);
            return false;
        }
    }

    private static StringBuilder getEnvironmentInfo(Context context) {
        StringBuilder info = new StringBuilder();
        info.append("time = ").append(Logger.getCurrentFormatDateTime()).append("\n");
        info.append("versionName = ").append(Logger.getMyVersionName(context)).append("\n");
        info.append(Logger.getAllInfo().toString()).append("\n");
        return info;
    }

    private static StringBuilder getAllInfo() {
        StringBuilder info = new StringBuilder();
        Class<?> clazz = null;
        try {
            clazz = Class.forName("android.os.Build");
        }
        catch (ClassNotFoundException ex) {
            try {
                clazz = Class.forName("miui.os.Build");
            }
            catch (ClassNotFoundException e) {
                Logger.e(PREFIX, "getAllInfo()", e);
            }
        }
        if (clazz != null) {
            try {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    field.setAccessible(true);
                    info.append(field.getName());
                    info.append(" = ");
                    info.append(field.get(null));
                    info.append("\n");
                }
            }
            catch (Exception e) {
                Logger.e(PREFIX, "getAllInfo()", e);
            }
        }
        return info;
    }

    private static String getCurrentFormatDateTime() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.CHINESE).format(System.currentTimeMillis());
    }

    private static String getMyVersionName(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception e) {
            Logger.e(PREFIX, "getMyVersionName()", e);
            return "";
        }
    }

    static /* synthetic */ void lambda$asyncSaveFile$1(Object isSuccess) throws Exception {
    }

    static /* synthetic */ void lambda$asyncSaveFile$0(File logFile, String content, ObservableEmitter emitter) throws Exception {
        boolean isSuccess = Logger.syncSaveFile(logFile, content);
        if (!emitter.isDisposed()) {
            emitter.onNext((Object)isSuccess);
        }
    }
}

