package com.foresee.sdk.cxMeasure.tracker.listeners;

import com.foresee.sdk.common.configuration.EligibleMeasureConfigurations;
import com.foresee.sdk.common.configuration.MeasureConfiguration;

/**
 * Created by ardavan.kalhori on 16-04-22.
 */
public interface CustomContactInviteListener extends BaseInviteListener
{
    /**
     * Called when invite is ready to be shown
     * @param measures measure configurations related to this invite
     */
    void showInvite(EligibleMeasureConfigurations measures);

    /**
     * Called when the contact info is not in the correct format
     */
    void onContactFormatError();

    /**
     * Called when the contact info is missing
     */
    void onContactMissing();

    /**
     * Called when invitation is cancelled due to a network error
     */
    void onInviteCancelledWithNetworkError();
}
