package com.foresee.sdk.common.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;

/**
 * Created by selwynleeke on 2017-03-21.
 */

public class MeasureConfiguration implements Serializable {
    private MeasureConfigurationInternal measureConfigurationInternal;

    public MeasureConfiguration(MeasureConfigurationInternal configurationInternal) {
        this.measureConfigurationInternal = configurationInternal;
    }

    /**
     * Get the Survey ID (SID) associated with this measure
     * @return a string containing the SID
     */
    public String getSurveyId() {
        return measureConfigurationInternal.getSurveyId();
    }

    /**
     * Get the combined criteria contained within this measure
     * @return a collection of MeasureConfiguration objects representing the combined criteria required before an
     * invite is shown
     */
    public ArrayList<MeasureConfiguration> getCombinedCriteria() {
        ArrayList<MeasureConfiguration> returnList = new ArrayList<>();

        ArrayList<MeasureConfigurationInternal> combinedCriteria = measureConfigurationInternal.getCombinedCriteria();
        for (MeasureConfigurationInternal internalConfig : combinedCriteria) {
            returnList.add(new MeasureConfiguration(internalConfig));
        }

        return returnList;
    }

    /**
     * Get the daysSinceFirstLaunch criteria for this measure
     * @return the number of days that should pass after the first launch before the invite should appear
     */
    public int getDaysSinceFirstLaunchCriteria() {
        return measureConfigurationInternal.getMaxDaysSinceFirstLaunch();
    }

    /**
     * Get the launchCount criteria for this measure
     * @return the number of launches after which the invite should appear
     */
    public int getLaunchCountCriteria() {
        return measureConfigurationInternal.getMaxLaunchCount();
    }

    /**
     * Get the daysSinceFirstLaunch criteria for this measure
     * @return the number of days that should pass after the most recent launch before the invite should appear
     */
    public int getDaysSinceLastLaunchCriteria() {
        return measureConfigurationInternal.getMaxDaysSinceLastLaunch();
    }

    /**
     * Get the pageViews criteria for this measure
     * @return the number of pages that should be displayed before the invite should appear
     */
    public int getPageViewsCriteria() {
        return measureConfigurationInternal.getMaxPageViews();
    }

    /**
     * Get the significant event thresholds for this measure
     * @return a list of keys and values representing the significant events that are required to be fulfilled
     * before the invite appears
     */
    public Map<String, Integer> getSignificantEventThresholds() {
        return measureConfigurationInternal.getSignificantEventThresholds();
    }

    /**
     * Get the survey style for this measure
     * @return the survey style for this measure
     */
    public String getSurveyStyle() {
        return measureConfigurationInternal.getSurveyStyle();
    }

    @Override
    public String toString() {
        return measureConfigurationInternal != null ? measureConfigurationInternal.toString() : "[measure configuration unavailable]";
    }
}
