package com.foresee.sdk.cxMeasure.tracker.listeners;

import com.foresee.sdk.common.configuration.EligibleMeasureConfigurations;

/**
 * Created by ardavan.kalhori on 16-04-22.
 */
public interface BaseInviteListener
{
    /**
     * Called when invitation is completed and user has accepted the invitation
     */
    void onInviteCompleteWithAccept(EligibleMeasureConfigurations measures);

    /**
     * Called when invitation is completed and user has declined the invitation
     */
    void onInviteCompleteWithDecline(EligibleMeasureConfigurations measures);

    /**
     * Called when invite could not be shown due to a network error
     * @param measures measure configurations related to this invite
     */
    void onInviteNotShownWithNetworkError(EligibleMeasureConfigurations measures);

    /**
     * Called when invite could not be shown due to a eligibility check failure
     * @param measures measure configurations related to this invite
     */
    void onInviteNotShownWithEligibilityFailed(EligibleMeasureConfigurations measures);

    /**
     * Called when invite could not be shown due to a sampling check failure
     * @param measures measure configurations related to this invite
     */
    void onInviteNotShownWithSamplingFailed(EligibleMeasureConfigurations measures);
}
