/*
 * Decompiled with CFR 0.152.
 */
package com.fooock.lib.phone.tracker;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import com.fooock.lib.phone.tracker.Configuration;
import com.fooock.lib.phone.tracker.EnvironmentReceiver;
import com.fooock.lib.phone.tracker.PhoneTracker;

class GpsReceiver
implements EnvironmentReceiver<Configuration.Gps> {
    private static final String TAG = GpsReceiver.class.getSimpleName();
    private final PhoneTracker.GpsLocationListener gpsLocationListener;
    private final LocationManager locationManager;
    private final CheckLocationProvider checkLocationProvider;
    private Configuration.Gps gpsConfiguration;
    private final LocationListener locationListener = new LocationListener(){

        public void onLocationChanged(Location location) {
            Log.d((String)TAG, (String)("Min distance: " + GpsReceiver.this.gpsConfiguration.getMinDistanceUpdate() + " Min time: " + GpsReceiver.this.gpsConfiguration.getMinTimeUpdate()));
            if (GpsReceiver.this.gpsLocationListener == null) {
                return;
            }
            long timestamp = System.currentTimeMillis();
            GpsReceiver.this.gpsLocationListener.onLocationReceived(timestamp, location);
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
        }
    };

    GpsReceiver(Context context, Configuration.Gps gpsConfiguration, PhoneTracker.GpsLocationListener gpsLocationListener) {
        this.gpsConfiguration = gpsConfiguration;
        this.gpsLocationListener = gpsLocationListener;
        this.locationManager = (LocationManager)context.getSystemService("location");
        this.checkLocationProvider = new CheckLocationProvider(this.locationManager);
    }

    @Override
    public void register() {
        Log.d((String)TAG, (String)"Registered gps receiver...");
        boolean providerEnabled = this.checkLocationProvider.isEnabled();
        if (providerEnabled) {
            boolean gpsProviderEnabled = this.checkLocationProvider.gpsProviderEnabled();
            this.registerProvider(gpsProviderEnabled ? "gps" : "network");
        } else {
            Log.w((String)TAG, (String)"No location providers enabled");
        }
    }

    private void registerProvider(String provider) {
        this.locationManager.requestLocationUpdates(provider, this.gpsConfiguration.getMinTimeUpdate(), this.gpsConfiguration.getMinDistanceUpdate(), this.locationListener);
    }

    @Override
    public void unregister() {
        Log.d((String)TAG, (String)"Unregistered gps receiver...");
        this.locationManager.removeUpdates(this.locationListener);
    }

    @Override
    public void reloadConfiguration(Configuration.Gps config) {
        if (this.gpsConfiguration.equals(config)) {
            Log.i((String)TAG, (String)"Gps config is the same, not reload...");
            return;
        }
        Log.d((String)TAG, (String)"Reloading gps configuration");
        this.gpsConfiguration = config;
        this.unregister();
        this.register();
    }

    private static class CheckLocationProvider {
        private final LocationManager locationManager;

        CheckLocationProvider(LocationManager locationManager) {
            this.locationManager = locationManager;
        }

        private boolean isEnabled() {
            return this.gpsProviderEnabled() || this.networkProviderEnabled();
        }

        private boolean gpsProviderEnabled() {
            return this.locationManager.isProviderEnabled("gps");
        }

        private boolean networkProviderEnabled() {
            return this.locationManager.isProviderEnabled("network");
        }
    }
}

