/*
 * Decompiled with CFR 0.152.
 */
package com.fooock.lib.phone.tracker;

import android.content.Context;
import android.os.Handler;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.fooock.lib.phone.tracker.CheckPermission;
import com.fooock.lib.phone.tracker.CheckVersion;
import com.fooock.lib.phone.tracker.Configuration;
import com.fooock.lib.phone.tracker.EnvironmentReceiver;
import com.fooock.lib.phone.tracker.PhoneTracker;
import java.util.Collections;
import java.util.List;

class CellReceiver
implements EnvironmentReceiver<Configuration.Cell> {
    private static final String TAG = CellReceiver.class.getSimpleName();
    private final TelephonyManager telephonyManager;
    private final CheckVersion checkVersion = new CheckVersion();
    private final CheckPermission checkPermission;
    private final Handler handler = new Handler();
    private final PhoneTracker.CellScanListener cellScanListener;
    private Configuration.Cell cellConfiguration;

    CellReceiver(Context context, Configuration.Cell cellConfiguration, PhoneTracker.CellScanListener cellScanListener) {
        this.telephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.cellConfiguration = cellConfiguration;
        this.checkPermission = new CheckPermission(context);
        this.cellScanListener = cellScanListener;
    }

    @Override
    public void register() {
        Log.d((String)TAG, (String)"Registered cell receiver...");
        boolean equalOrGreater17 = this.checkVersion.isEqualOrGreater(17);
        if (equalOrGreater17) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    boolean permEnabled = CellReceiver.this.checkPermission.hasAnyPermission(PhoneTracker.LOCATION_PERMISSIONS);
                    int scanDelay = CellReceiver.this.cellConfiguration.getScanDelay();
                    if (!permEnabled) {
                        Log.w((String)TAG, (String)("Location permissions not granted to cell scan, trying again in " + scanDelay + "ms"));
                        CellReceiver.this.handler.postDelayed((Runnable)this, (long)scanDelay);
                        return;
                    }
                    List cellInfo = CellReceiver.this.telephonyManager.getAllCellInfo();
                    long timestamp = System.currentTimeMillis();
                    if (cellInfo == null || cellInfo.isEmpty()) {
                        if (CellReceiver.this.cellScanListener != null) {
                            CellReceiver.this.cellScanListener.onCellInfoReceived(timestamp, Collections.emptyList());
                        }
                    } else if (CellReceiver.this.cellScanListener != null) {
                        CellReceiver.this.cellScanListener.onCellInfoReceived(timestamp, cellInfo);
                    }
                    Log.d((String)TAG, (String)("Scanning cell every " + scanDelay + "ms"));
                    CellReceiver.this.handler.postDelayed((Runnable)this, (long)scanDelay);
                }
            });
        } else {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    boolean permEnabled = CellReceiver.this.checkPermission.hasAnyPermission(PhoneTracker.LOCATION_PERMISSIONS);
                    int scanDelay = CellReceiver.this.cellConfiguration.getScanDelay();
                    if (!permEnabled) {
                        Log.w((String)TAG, (String)("Location permissions not granted to cell scan, trying again in " + scanDelay + "ms"));
                        CellReceiver.this.handler.postDelayed((Runnable)this, (long)scanDelay);
                        return;
                    }
                    List cellInfo = CellReceiver.this.telephonyManager.getNeighboringCellInfo();
                    long timestamp = System.currentTimeMillis();
                    if (cellInfo == null || cellInfo.isEmpty()) {
                        CellReceiver.this.cellScanListener.onNeighborCellReceived(timestamp, Collections.emptyList());
                    } else {
                        CellReceiver.this.cellScanListener.onNeighborCellReceived(timestamp, cellInfo);
                    }
                    Log.d((String)TAG, (String)("Scanning cell every " + scanDelay + "ms"));
                    CellReceiver.this.handler.postDelayed((Runnable)this, (long)scanDelay);
                }
            });
        }
    }

    @Override
    public void unregister() {
        Log.d((String)TAG, (String)"Unregistered cell receiver...");
        this.handler.removeCallbacksAndMessages(null);
    }

    @Override
    public void reloadConfiguration(Configuration.Cell config) {
        if (this.cellConfiguration.equals(config)) {
            Log.i((String)TAG, (String)"Cell config is the same, not reload...");
            return;
        }
        Log.d((String)TAG, (String)"Reloading cell configuration");
        this.cellConfiguration = config;
    }
}

