/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify.unit;

import com.fitbur.guava.common.base.Preconditions;
import com.fitbur.testify.Real;
import com.fitbur.testify.TestContext;
import com.fitbur.testify.TestVerifier;
import com.fitbur.testify.descriptor.CutDescriptor;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import javax.inject.Inject;
import org.slf4j.Logger;

public class UnitTestVerifier
implements TestVerifier {
    private final TestContext testContext;
    private final Logger logger;

    public UnitTestVerifier(TestContext testContext, Logger logger) {
        this.testContext = testContext;
        this.logger = logger;
    }

    public void dependency() {
        HashMap<String, String> hashMap = new HashMap<String, String>(){
            {
                this.put("org.mockito.Mockito", "Mockito");
            }
        };
        hashMap.entrySet().parallelStream().forEach(entry -> {
            try {
                Class.forName((String)entry.getKey());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Preconditions.checkState((boolean)false, (String)"'%s' not found. Please insure '%s' dependency is in the classpath.", (Object[])new Object[]{entry.getKey(), entry.getValue()});
            }
        });
    }

    public void configuration() {
        String string = this.testContext.getTestClassName();
        Collection collection = this.testContext.getFieldDescriptors().values();
        CutDescriptor cutDescriptor = this.testContext.getCutDescriptor();
        Preconditions.checkState((cutDescriptor != null ? 1 : 0) != 0, (String)"Test class '%s' does not define a field annotated with @Cut class.", (Object[])new Object[]{string});
        Preconditions.checkState((this.testContext.getConstructorCount() == 1 ? 1 : 0) != 0, (String)"Class under test '%s' defined in test class '%s' has %s constructors. Please insure that the class under test has one and only one constructor.", (Object[])new Object[]{cutDescriptor.getTypeName(), string, this.testContext.getConstructorCount()});
        collection.parallelStream().forEach(fieldDescriptor -> {
            Class clazz = fieldDescriptor.getType();
            String string2 = fieldDescriptor.getName();
            String string3 = fieldDescriptor.getTypeName();
            Preconditions.checkState((!Modifier.isFinal(clazz.getModifiers()) ? 1 : 0) != 0, (String)"Field '%s' in test class '%s' can not be faked because '%s' is a final class.", (Object[])new Object[]{string2, string, string3});
            Preconditions.checkState((!fieldDescriptor.hasAnyAnnotation(new Class[]{Real.class, Inject.class}) ? 1 : 0) != 0, (String)"Field '%s' in test class '%s' is annotated with @Real or @Inject. @Real and @Inject annotations are not supported for unit tests. Please use @Fake instead.", (Object[])new Object[]{string2, string});
        });
    }

    public void wiring() {
        CutDescriptor cutDescriptor = this.testContext.getCutDescriptor();
        String string = this.testContext.getTestClassName();
        String string2 = cutDescriptor.getTypeName();
        Collection collection = this.testContext.getParamaterDescriptors().values();
        collection.parallelStream().forEach(parameterDescriptor -> {
            Optional optional = parameterDescriptor.getInstance();
            if (!optional.isPresent()) {
                String string3 = parameterDescriptor.getTypeName();
                this.logger.warn("Class under test '{}' defined in '{}' has a collaborator type '{}' but test class '{}' does not define a field of type '{}' annotated with @Fake. Null values will be used.", new Object[]{string2, string, string3, string, string3});
            }
        });
    }
}

