/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ResultReceiver;
import android.text.TextUtils;
import android.view.View;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import com.fillr.browsersdk.EmbeddedBrowser;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.FillrToolbarManager;
import com.fillr.browsersdk.analytics.FillrAnalyticsEvents;
import com.fillr.browsersdk.apiclient.FillrMappingServiceClient;
import com.fillr.browsersdk.model.FillrBasePrompt;
import com.fillr.browsersdk.model.FillrPageEventPayloadBuilder;
import com.fillr.browsersdk.model.FillrWebView;
import com.fillr.browsersdk.model.FillrWebViewMapper;
import com.fillr.browsersdk.model.FillrWidget;
import com.fillr.browsersdk.model.FillrWidgetPageEvent;
import com.fillr.browsersdk.model.JSNativeInterface;
import com.fillr.browsersdk.utilities.FillrUtils;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.json.JSONException;
import org.json.JSONObject;
import timber.log.Timber;

public class ToolbarAutofillPrompt
extends FillrBasePrompt {
    private static final String SUPPRESS_FILL_VIEW = "suppressFillView";
    private FillrToolbarManager mFillrToolbarManager;
    private FillrMappingServiceClient mClient;
    private Map<JSNativeInterface, FillrWebView> viewCache;
    private Map<View, String> clickCache;
    private Map<View, String> urlCache;

    public ToolbarAutofillPrompt(Fillr fillr, FillrToolbarManager fillrToolbarManager, FillrWebViewMapper webViewMapper) {
        super(webViewMapper);
        this.mFillr = fillr;
        this.mFillrToolbarManager = fillrToolbarManager;
        this.mClient = new FillrMappingServiceClient(this.mFillr);
        this.viewCache = new WeakHashMap<JSNativeInterface, FillrWebView>();
        this.clickCache = Collections.synchronizedMap(new WeakHashMap());
        this.urlCache = Collections.synchronizedMap(new WeakHashMap());
    }

    @Override
    public void onTrackWebView(FillrWebView trackedWebview) {
        FillrWidget widget = this.mFillr.getFillrWidget();
        if (widget != null) {
            widget.setWidgetListenerPrompt(new FillrWidget.FillrWidgetListener(){

                @Override
                public void onWidgetDownloaded(String widgetJavaScript) {
                }

                @Override
                public void onWidgetInjected(FillrWebView webView) {
                    ToolbarAutofillPrompt.this.initializeWidget(webView);
                }
            });
            widget.download();
        }
        JSNativeInterface iface = new JSNativeInterface(this);
        trackedWebview.setJSInterface(iface);
        this.viewCache.put(iface, trackedWebview);
    }

    @Override
    public void onInjectJSInterface(FillrWebView webView) {
        webView.setJSInterface(new JSNativeInterface(this));
    }

    @Override
    public void onPageFinished(FillrWebView webView) {
        if (!Fillr.getInstance().isEnabled(webView)) {
            return;
        }
        webView.setFillrJSClient();
        this.mFillr.getFillrWidget().inject(webView);
        this.isNewPage = true;
    }

    @Override
    public void onUrlChanged(String newDomain) {
        if (this.mFillrToolbarManager != null) {
            this.mFillrToolbarManager.urlChanged(newDomain);
        }
    }

    @Override
    public void setEnabled(boolean enabled, boolean previousEnabledValue) {
        if (enabled) {
            this.mFillr.setToolbarVisibility(Fillr.ToolbarViewVisibility.VISIBLE);
            if (!previousEnabledValue) {
                this.mFillr.trackEvent(FillrAnalyticsEvents.FillrToolbarEnabled, new String[0]);
            }
        } else {
            this.mFillr.setToolbarVisibility(Fillr.ToolbarViewVisibility.INVISIBLE);
            if (previousEnabledValue) {
                this.mFillr.trackEvent(FillrAnalyticsEvents.FillrToolbarDisabled, new String[0]);
            }
        }
    }

    @Override
    public void setVisibility(Fillr.ToolbarViewVisibility visibility) {
        this.mFillrToolbarManager.setToolbarVisible(visibility == Fillr.ToolbarViewVisibility.VISIBLE);
    }

    @Override
    public Fillr.FillrAutofillPromptMode getMode() {
        return Fillr.FillrAutofillPromptMode.TOOLBAR;
    }

    @Override
    public void onFieldFocused() {
        this.mFillrToolbarManager.fieldFocused();
    }

    @Override
    public void fillrJNISetFields(String json) {
        try {
            JSONObject mappingMeta = new JSONObject(json);
            if (mappingMeta.has("options")) {
                String options = mappingMeta.getString("options");
                if (this.isHeadfull() && options.contains(SUPPRESS_FILL_VIEW)) {
                    return;
                }
            }
            if (mappingMeta.has("view_id")) {
                String viewId = this.safelyGetViewId(mappingMeta);
                FillrWebView currWebview = this.mWebViewMapper.getWebViewForId(viewId);
                this.mFillr.startProcess(json, currWebview);
            } else {
                this.mFillr.startProcess(json);
            }
        }
        catch (Exception e) {
            Timber.e((Throwable)e);
        }
    }

    @Override
    public void fillrJNISetFillResult(String jsonFillResult) {
        this.mFillr.trackEvent(FillrAnalyticsEvents.FillrFillResult, jsonFillResult);
    }

    @Override
    public void fillrJNIFieldFocused(String json) {
    }

    @Override
    public void fillrJNISetWidgetVersion(String version) {
        this.mFillr.setWidgetVersion(version);
    }

    @Override
    public void fillrJNIFormMutation(String json) {
        try {
            JSONObject jsonObject = new JSONObject(json);
            final String viewId = this.safelyGetViewId(jsonObject);
            Activity activity = this.mFillr.getParentActivity();
            if (activity != null) {
                activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FillrWebView fillrWebView = ToolbarAutofillPrompt.this.mWebViewMapper.getByUUID(UUID.fromString(viewId));
                            if (fillrWebView != null) {
                                String opts = ToolbarAutofillPrompt.this.isHeadfull() ? "'options=suppressFillView'" : "";
                                fillrWebView.loadJavascript("PopWidgetInterface.getFields(" + opts + ");");
                            }
                        }
                        catch (Exception e) {
                            Timber.e((String)e.getMessage(), (Object[])new Object[0]);
                        }
                    }
                });
            }
        }
        catch (JSONException e) {
            Timber.e((String)e.getMessage(), (Object[])new Object[0]);
        }
    }

    @Override
    public void fillrJNIFieldBlurred(String json) {
        this.triggerCheckFields();
    }

    @Override
    public void showPrompt() {
    }

    @Override
    public void fillrJNICheckFields(String json) {
        this.sendRequestForToolbarDisplay(json);
    }

    private void sendRequestForToolbarDisplay(final String json) {
        if (this.isHeadfull()) {
            Handler mainHandler = new Handler(Looper.getMainLooper());
            mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        ResultReceiver toolbarMappingReceiver = new ResultReceiver(new Handler()){

                            protected void onReceiveResult(int resultCode, Bundle resultData) {
                                try {
                                    if (resultData != null) {
                                        JSONObject mappingResult = new JSONObject(resultData.getString("raw_response"));
                                        if (ToolbarAutofillPrompt.this.mFillrToolbarManager != null) {
                                            ToolbarAutofillPrompt.this.mFillrToolbarManager.setFillableFieldsFlag(ToolbarAutofillPrompt.this.hasFields(mappingResult));
                                        }
                                    }
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                            }
                        };
                        ToolbarAutofillPrompt.this.getClient().getMappingsForToolBarDisplay(json, toolbarMappingReceiver);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    @Override
    public String getLastUrlForWebview(WebView view) {
        return this.urlCache.get(view);
    }

    @Override
    public String getLastClickForWebview(WebView view) {
        return this.clickCache.get(view);
    }

    @Override
    public void handlePageEventForView(WebView view, WebResourceResponse response) {
        if (view == null || response == null || !"fillr/json".equalsIgnoreCase(response.getMimeType())) {
            return;
        }
        try {
            String json = FillrUtils.streamToString(response.getData());
            JSONObject payload = FillrUtils.parsedJsonOrNull(json);
            if (payload != null) {
                this.dispatchPageEvent(payload);
                this.clearCachedDataForView(view);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void fillrJNIPageEvent(String viewIdentifier, String eventType, String url, String clickJson, JSNativeInterface source) {
        Fillr fillr = Fillr.getInstance();
        if (fillr != null && fillr.getEmbeddedBrowser() == EmbeddedBrowser.EBATES) {
            View webView;
            JSONObject parsedJson = FillrUtils.parsedJsonOrNull(clickJson);
            FillrWidgetPageEvent event = FillrWidgetPageEvent.eventForName(eventType);
            FillrWebView fillrWebView = this.viewCache.get(source);
            View view = webView = fillrWebView != null && fillrWebView.getWebView() instanceof View ? (View)fillrWebView.getWebView() : null;
            if (webView != null && event != null && event.isValidWithJson(parsedJson) && !TextUtils.isEmpty((CharSequence)url)) {
                if (event == FillrWidgetPageEvent.CLICK) {
                    this.clickCache.put(webView, clickJson);
                    return;
                }
                try {
                    JSONObject payload;
                    if (event == FillrWidgetPageEvent.LOAD) {
                        this.urlCache.put(webView, url);
                    }
                    if ((payload = FillrPageEventPayloadBuilder.create(url, event).setExtraInfo(parsedJson).buildJson()) != null) {
                        this.dispatchPageEvent(payload);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String safelyGetViewId(JSONObject json) throws JSONException {
        if (json == null || !json.has("view_id")) {
            return null;
        }
        return json.getString("view_id").replaceAll("[^0-9a-fA-F\\-]", "");
    }

    private void dispatchPageEvent(JSONObject payload) {
        ResultReceiver resultReceiver = new ResultReceiver(new Handler(Looper.getMainLooper())){

            protected void onReceiveResult(int resultCode, Bundle resultData) {
            }
        };
        this.getClient().sendPageEvent(payload, resultReceiver);
    }

    private void clearCachedDataForView(WebView view) {
        this.urlCache.remove(view);
        this.clickCache.remove(view);
    }

    private FillrMappingServiceClient getClient() {
        if (this.mClient == null) {
            this.mClient = new FillrMappingServiceClient(this.mFillr);
        }
        return this.mClient;
    }

    private boolean isHeadfull() {
        return this.mFillr != null && this.mFillr.getParentActivity() != null && this.mFillr.getFillMode() != Fillr.FillMode.HEADLESS;
    }

    @Override
    void initializeWidget(FillrWebView trackedWebview) {
        super.initializeWidget(trackedWebview);
        this.triggerCheckFields();
    }

    private void triggerCheckFields() {
        if (this.isHeadfull()) {
            Handler mainHandler = new Handler(Looper.getMainLooper());
            mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (ToolbarAutofillPrompt.this.mFillr != null && ToolbarAutofillPrompt.this.mFillr.getFillrWebView() != null) {
                        ToolbarAutofillPrompt.this.mFillr.getFillrWebView().loadJavascript("try { PopWidgetInterface.checkFields(); } catch (e) { console.log('Cannot check fields until widget is injected'); }");
                    }
                }
            });
        }
    }
}

