/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import com.fillr.browsersdk.model.FillrWidget;
import com.fillr.browsersdk.model.FillrWidgetAuth;

public class FillrWidgetParams {
    private String localAssetName;
    private String remoteAssetUrl;
    private FillrWidget.WidgetType type;
    private FillrWidgetAuth widgetAuth;

    String getLocalAssetName() {
        return this.localAssetName;
    }

    String getRemoteAssetUrl() {
        return this.remoteAssetUrl;
    }

    void setLocalAssetName(String localAssetName) {
        if (localAssetName == null) {
            throw new IllegalArgumentException("Invalid Local Asset");
        }
        this.localAssetName = localAssetName;
    }

    void setRemoteAssetUrl(String remoteAssetUrl) {
        if (remoteAssetUrl == null) {
            throw new IllegalArgumentException("Invalid Remote Asset");
        }
        this.remoteAssetUrl = remoteAssetUrl;
    }

    public boolean isUseAuth() {
        return this.type != null && this.type.reqAuth;
    }

    FillrWidget.WidgetType getType() {
        return this.type;
    }

    void setType(FillrWidget.WidgetType type) {
        if (type == null) {
            throw new IllegalArgumentException("Widget Type cannot be null");
        }
        this.type = type;
    }

    public FillrWidgetAuth getWidgetAuth() {
        return this.widgetAuth;
    }

    void setWidgetAuth(FillrWidgetAuth widgetAuth) {
        if (widgetAuth == null || !widgetAuth.isValid()) {
            throw new IllegalArgumentException("Widget auth invalid");
        }
        this.widgetAuth = widgetAuth;
    }

    boolean isValid() {
        return this.localAssetName != null && this.remoteAssetUrl != null && this.type != null && (!this.isUseAuth() || this.widgetAuth != null);
    }
}

