/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.apiclient;

import android.util.Base64;
import com.fillr.browsersdk.model.FillrWidgetAuth;
import com.fillr.browsersdk.model.FillrWidgetParams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPInputStream;

public class FillrWidgetDownloader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(String contentURL, FillrWidgetParams fillrWidgetParams) {
        InputStream is = null;
        HttpURLConnection conn = null;
        try {
            URL url = new URL(contentURL);
            conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(10000);
            conn.setConnectTimeout(15000);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept-Encoding", "gzip");
            if (fillrWidgetParams != null && fillrWidgetParams.isUseAuth()) {
                if (!contentURL.toLowerCase().startsWith("https")) {
                    throw new Exception("Please use a secure content URL");
                }
                FillrWidgetAuth widgetAuth = fillrWidgetParams.getWidgetAuth();
                String auth = widgetAuth.getUsername() + ":" + widgetAuth.getPassword();
                conn.setRequestProperty("Authorization", "Basic " + Base64.encodeToString((byte[])auth.getBytes(), (int)0));
            }
            conn.connect();
            int response = conn.getResponseCode();
            if (response == 200) {
                String contentAsString;
                is = conn.getInputStream();
                String contentEncoding = conn.getHeaderField("Content-Encoding");
                if (contentEncoding != null && "gzip".equalsIgnoreCase(contentEncoding)) {
                    is = new GZIPInputStream(is);
                }
                if ((contentAsString = FillrWidgetDownloader.readInputString(is)).length() > 0) {
                    String string2 = contentAsString;
                    return string2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    private static String readInputString(InputStream in) {
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String nextLine = "";
            while ((nextLine = reader.readLine()) != null) {
                sb.append(nextLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

