/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.utilities;

import android.app.AlertDialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import com.fillr.browsersdk.EmbeddedBrowser;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.R;
import com.fillr.browsersdk.model.FillrBrowserProperties;
import com.fillr.browsersdk.tooltip.SimpleTooltip;

public class FillrDialogHelper {
    public static void showSaveToProfilePrompt(Context context) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle((CharSequence)"Save Password?");
        builder.setIcon(R.drawable.com_fillr_icon_toolbar_sdk);
        builder.setMessage((CharSequence)"Do you want Fillr Secure Autofill to remember this password");
        builder.setPositiveButton((CharSequence)"Save", null);
        builder.setNegativeButton((CharSequence)"No thanks", null);
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    public static SimpleTooltip showToolbarToolTip(final Context context, View parent, View.OnClickListener onClickListener, FillrBrowserProperties browserProperties) {
        EmbeddedBrowser embeddedBrowser = Fillr.getInstance().getEmbeddedBrowser();
        String toolTipText = FillrDialogHelper.getToolTipText(context, browserProperties);
        int backgroundColor = FillrDialogHelper.getTooltipBgColor(embeddedBrowser);
        int arrowDownBg = FillrDialogHelper.getArrowDownBg(embeddedBrowser);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View view = inflater.inflate(R.layout.com_fillr_autofill_ebates_helper_bubble, null);
        View closeButton = view.findViewById(R.id.com_fillr_ebates_btn_close);
        View toolTipButton = view.findViewById(R.id.com_fillr_ebates_button);
        ImageView btnArrowDown = (ImageView)view.findViewById(R.id.btnArrowDown);
        toolTipButton.setBackgroundResource(backgroundColor);
        btnArrowDown.setImageResource(arrowDownBg);
        final SimpleTooltip tooltip = new SimpleTooltip.Builder(context).contentView(view, R.id.txt_try_ebates).anchorView(parent).text(toolTipText).gravity(48).animated(false).showArrow(false).margin(0.0f).transparentOverlay(true).dismissOnInsideTouch(false).dismissOnOutsideTouch(true).onDismissListener(new SimpleTooltip.OnDismissListener(){

            @Override
            public void onDismiss(SimpleTooltip tooltip) {
                EmbeddedBrowser.markTooltipAsCompleted(context);
            }
        }).build();
        closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                tooltip.dismiss();
            }
        });
        toolTipButton.setOnClickListener(onClickListener);
        tooltip.show();
        return tooltip;
    }

    private static int getArrowDownBg(EmbeddedBrowser embeddedBrowser) {
        if (embeddedBrowser == EmbeddedBrowser.EBATES) {
            return R.drawable.icn_arrow_down;
        }
        return R.drawable.icn_arrow_down_generic;
    }

    private static int getTooltipBgColor(EmbeddedBrowser embeddedBrowser) {
        if (embeddedBrowser == EmbeddedBrowser.EBATES) {
            return R.drawable.com_fillr_ebates_helper_tutorial_bg;
        }
        return R.drawable.com_fillr_generic_helper_tutorial_bg;
    }

    private static String getToolTipText(Context context, FillrBrowserProperties embeddedBrowser) {
        String integrator;
        String retVal = "Try Autofill";
        if (context != null && embeddedBrowser != null && (integrator = embeddedBrowser.getToolbarName()) != null && !integrator.isEmpty()) {
            retVal = context.getString(R.string.com_fillr_try_new_tooltip, new Object[]{integrator});
        }
        return retVal;
    }
}

