/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.utilities;

import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.R;

public class FillrCaptureSensitiveDataDialogManager {
    private static final String EXTRA_KEY_IS_PASSWORD = "is_password";
    private static final String EXTRA_KEY_DO_NOT_ASK_AGAIN = "do_not_ask_again";
    private static final String EXTRA_KEY_SAVE_TO_PROFILE = "save_to_profile";
    private Fillr mFillr;
    private boolean isShowingAlert = false;
    private boolean donotAskAgain = false;

    public FillrCaptureSensitiveDataDialogManager(Fillr fillr) {
        this.mFillr = fillr;
        if (this.mFillr != null) {
            BoardResponseReceiver mUploadStateReceiver = new BoardResponseReceiver();
            IntentFilter mStatusIntentFilter = new IntentFilter("com.fillr.service.CaptureFieldsMappingService.SensitiveData");
            LocalBroadcastManager.getInstance((Context)this.mFillr.getParentActivity()).registerReceiver((BroadcastReceiver)mUploadStateReceiver, mStatusIntentFilter);
        }
    }

    private class BoardResponseReceiver
    extends BroadcastReceiver {
        private BoardResponseReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (FillrCaptureSensitiveDataDialogManager.this.isShowingAlert) {
                return;
            }
            FillrCaptureSensitiveDataDialogManager.this.isShowingAlert = true;
            LayoutInflater inflater = (LayoutInflater)FillrCaptureSensitiveDataDialogManager.this.mFillr.getParentActivity().getSystemService("layout_inflater");
            View viewCreated = inflater.inflate(R.layout.f_dialog_capture_password, null);
            ContextThemeWrapper ctw = new ContextThemeWrapper((Context)FillrCaptureSensitiveDataDialogManager.this.mFillr.getParentActivity(), R.style.com_fillr_browser_sdk_transparent_dialog);
            final Dialog dialog = new Dialog((Context)ctw, R.style.f_dialog);
            dialog.setContentView(viewCreated);
            Bundle extras = intent.getExtras();
            final boolean isPassword = extras != null && extras.getBoolean(FillrCaptureSensitiveDataDialogManager.EXTRA_KEY_IS_PASSWORD);
            TextView titleTextView = (TextView)viewCreated.findViewById(R.id.title_textview);
            titleTextView.setText((CharSequence)FillrCaptureSensitiveDataDialogManager.this.mFillr.getParentActivity().getResources().getString(isPassword ? R.string.capture_value_prompt_save_password : R.string.capture_value_prompt_save_credit_card));
            TextView detailsTextView = (TextView)viewCreated.findViewById(R.id.details_textview);
            detailsTextView.setText((CharSequence)FillrCaptureSensitiveDataDialogManager.this.mFillr.getParentActivity().getResources().getString(isPassword ? R.string.capture_value_prompt_save_password_details : R.string.capture_value_prompt_save_credit_card_details));
            View closeButton = viewCreated.findViewById(R.id.crose_button);
            closeButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    dialog.dismiss();
                }
            });
            View dontAskAgainView = viewCreated.findViewById(R.id.dont_ask_again_view);
            final ImageView dontAskAgainCheckbox = (ImageView)viewCreated.findViewById(R.id.dont_ask_again_checkbox);
            dontAskAgainView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FillrCaptureSensitiveDataDialogManager.this.donotAskAgain = !FillrCaptureSensitiveDataDialogManager.this.donotAskAgain;
                    if (FillrCaptureSensitiveDataDialogManager.this.donotAskAgain) {
                        dontAskAgainCheckbox.setImageResource(R.drawable.icon_fillr_checkbox_on);
                    } else {
                        dontAskAgainCheckbox.setImageResource(R.drawable.icon_fillr_checkbox_off);
                    }
                }
            });
            Button noThanksButton = (Button)viewCreated.findViewById(R.id.no_thanks_button);
            noThanksButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent localIntent = new Intent("com.fillr.service.CaptureFieldsMappingService.SensitiveDataSave");
                    Bundle extras = new Bundle();
                    extras.putBoolean(FillrCaptureSensitiveDataDialogManager.EXTRA_KEY_IS_PASSWORD, isPassword);
                    extras.putBoolean(FillrCaptureSensitiveDataDialogManager.EXTRA_KEY_DO_NOT_ASK_AGAIN, FillrCaptureSensitiveDataDialogManager.this.donotAskAgain);
                    extras.putBoolean(FillrCaptureSensitiveDataDialogManager.EXTRA_KEY_SAVE_TO_PROFILE, false);
                    localIntent.putExtras(extras);
                    LocalBroadcastManager.getInstance((Context)FillrCaptureSensitiveDataDialogManager.this.mFillr.getParentActivity()).sendBroadcast(localIntent);
                    dialog.dismiss();
                }
            });
            Button saveButton = (Button)viewCreated.findViewById(R.id.save_button);
            saveButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    dialog.dismiss();
                    Intent localIntent = new Intent("com.fillr.service.CaptureFieldsMappingService.SensitiveDataSave");
                    Bundle extras = new Bundle();
                    extras.putBoolean(FillrCaptureSensitiveDataDialogManager.EXTRA_KEY_IS_PASSWORD, isPassword);
                    extras.putBoolean(FillrCaptureSensitiveDataDialogManager.EXTRA_KEY_DO_NOT_ASK_AGAIN, FillrCaptureSensitiveDataDialogManager.this.donotAskAgain);
                    extras.putBoolean(FillrCaptureSensitiveDataDialogManager.EXTRA_KEY_SAVE_TO_PROFILE, true);
                    localIntent.putExtras(extras);
                    LocalBroadcastManager.getInstance((Context)FillrCaptureSensitiveDataDialogManager.this.mFillr.getParentActivity()).sendBroadcast(localIntent);
                }
            });
            dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialogInterface) {
                    FillrCaptureSensitiveDataDialogManager.this.isShowingAlert = false;
                    FillrCaptureSensitiveDataDialogManager.this.donotAskAgain = false;
                }
            });
            dialog.show();
        }
    }
}

