/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.os.ResultReceiver;
import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.analytics.FillrAnalyticsEvents;
import com.fillr.browsersdk.analytics.FillrAnalyticsManager;
import com.fillr.browsersdk.model.FillrBasePrompt;
import com.fillr.browsersdk.model.FillrIntentBuilder;
import com.fillr.browsersdk.model.FillrWebView;
import com.fillr.browsersdk.model.FillrWebViewMapper;
import com.fillr.browsersdk.model.FillrWidget;
import com.fillr.browsersdk.model.JSNativeInterface;
import org.json.JSONException;
import org.json.JSONObject;

public class InFieldAutofillPrompt
extends FillrBasePrompt {
    public InFieldAutofillPrompt(Fillr fillr, FillrAnalyticsManager fillrAnalyticsManager, FillrWebViewMapper webViewMapper) {
        super(webViewMapper);
        this.mFillr = fillr;
    }

    @Override
    public void onTrackWebView(FillrWebView webView) {
        FillrWidget widget = this.mFillr.getFillrWidget();
        if (widget != null) {
            widget.setWidgetListener(new FillrWidget.FillrWidgetListener(){

                @Override
                public void onWidgetDownloaded(String widgetJavaScript) {
                }

                @Override
                public void onWidgetInjected(FillrWebView webView) {
                    InFieldAutofillPrompt.this.initializeWidget(webView);
                }
            });
            widget.download();
        }
        webView.setJSInterface(new JSNativeInterface(this));
    }

    @Override
    public void onInjectJSInterface(FillrWebView webView) {
        webView.setJSInterface(new JSNativeInterface(this));
    }

    @Override
    public void onPageFinished(FillrWebView webView) {
        this.mFillr.getFillrWidget().inject(webView);
        this.isNewPage = true;
    }

    @Override
    public void onUrlChanged(String newDomain) {
    }

    @Override
    public void setEnabled(boolean enabled, boolean previousEnabledValue) {
    }

    @Override
    public void setVisibility(Fillr.ToolbarViewVisibility visibility) {
    }

    @Override
    public Fillr.FillrAutofillPromptMode getMode() {
        return null;
    }

    @Override
    public void onFieldFocused() {
    }

    @Override
    public void showPrompt() {
        this.mFillr.getFillrWebView().loadJavascript("PopWidgetInterface.showPrompt();");
    }

    @Override
    public void fillrJNISetFields(String json) {
        this.mFillr.startProcess(json, this.mFillr.getFillrWebView());
    }

    @Override
    public void fillrJNISetFillResult(String jsonFillResult) {
    }

    @Override
    public void fillrJNISetValues(String fieldsJson, String valuesJson) {
        super.fillrJNISetValues(fieldsJson, valuesJson);
    }

    @Override
    public void fillrJNIFieldFocused(String json) {
        this.mFillr.getParentActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                InFieldAutofillPrompt.this.mFillr.getFillrWebView().loadJavascript("try { PopWidgetInterface.checkFields(); } catch (e) { console.log('Cannot check fields until widget is injected'); }");
                InFieldAutofillPrompt.this.mFillr.trackEvent(FillrAnalyticsEvents.FillrInFieldButtonShown, new String[0]);
            }
        });
    }

    @Override
    public void fillrJNIFieldBlurred(String json) {
    }

    @Override
    public void fillrJNICheckFields(final String json) {
        this.mFillr.getParentActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ResultReceiver receiver = new ResultReceiver(new Handler()){

                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        try {
                            JSONObject mappingResult = new JSONObject(resultData.getString("mappings"));
                            if (InFieldAutofillPrompt.this.hasFields(mappingResult)) {
                                InFieldAutofillPrompt.this.showPrompt();
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                };
                Intent newIntent = new Intent("com.fillr.service.MappingRequestService");
                FillrIntentBuilder intentBuilder = InFieldAutofillPrompt.this.mFillr.getIntentBuilder();
                if (intentBuilder != null) {
                    newIntent.setPackage(intentBuilder.getFillrCorePackageName());
                    newIntent.putExtra("receiver", (Parcelable)receiver);
                    intentBuilder.setIntentExtras(newIntent);
                    newIntent.putExtra("com.fillr.jsonfields", json);
                    newIntent.putExtra("com.fillr.isnewpage", InFieldAutofillPrompt.this.isNewPage);
                    InFieldAutofillPrompt.this.mFillr.getParentActivity().startService(newIntent);
                    InFieldAutofillPrompt.this.mFillr.trackEvent(FillrAnalyticsEvents.FillrInFieldButtonTapped, new String[0]);
                }
            }
        });
    }

    @Override
    public void fillrJNISetWidgetVersion(String version) {
        this.mFillr.setWidgetVersion(version);
    }

    @Override
    public void fillrJNIFormMutation(String mutation) {
    }

    @Override
    protected void fillrJNIPageEvent(String viewIdentifier, String eventType, String url, String clickJson, JSNativeInterface source) {
    }
}

