/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import com.fillr.browsersdk.Fillr;
import com.fillr.browsersdk.model.FillrWidget;
import com.fillr.browsersdk.model.FillrWidgetAuth;
import com.fillr.browsersdk.model.FillrWidgetParams;

public class FillrWidgetFactory {
    public FillrWidget getWidget(Fillr fillr, FillrWidget.WidgetType widgetType) {
        return this.getWidget(fillr, widgetType, null);
    }

    public FillrWidget getWidget(Fillr fillr, FillrWidget.WidgetType widgetType, FillrWidgetAuth widgetAuth) {
        if (widgetType != null && widgetType.reqAuth && (widgetAuth == null || !widgetAuth.isValid())) {
            throw new IllegalArgumentException("Please provide auth details");
        }
        switch (widgetType) {
            case MOBILE: {
                return this.getMobileWidget(fillr);
            }
            case CART_SCRAPER: {
                return this.getCartScraperWidget(fillr, widgetAuth);
            }
        }
        return null;
    }

    private FillrWidget getCartScraperWidget(Fillr fillr, FillrWidgetAuth widgetAuth) {
        FillrWidgetParams widgetParams = new FillrWidgetParams();
        widgetParams.setLocalAssetName("Widget1.js");
        widgetParams.setRemoteAssetUrl("https://cart-scraper.fillr.com/widget/cart-information-extraction/FillrCartScraperWidget.js.gz");
        widgetParams.setWidgetAuth(widgetAuth);
        widgetParams.setType(FillrWidget.WidgetType.CART_SCRAPER);
        return new FillrWidget(fillr, widgetParams);
    }

    private FillrWidget getMobileWidget(Fillr fillr) {
        FillrWidgetParams widgetParams = new FillrWidgetParams();
        widgetParams.setLocalAssetName("FillrWidget-Android.js");
        widgetParams.setRemoteAssetUrl("https://d2o8n2jotd2j7i.cloudfront.net/widget/android/sdk/FillrWidget-Android.js.gz");
        widgetParams.setType(FillrWidget.WidgetType.MOBILE);
        return new FillrWidget(fillr, widgetParams);
    }
}

