/*
 * Decompiled with CFR 0.152.
 */
package com.fillr.browsersdk.model;

import com.fillr.browsersdk.model.FillrWidgetPageEvent;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class FillrPageEventPayloadBuilder {
    private String url;
    private FillrWidgetPageEvent eventType;
    private long timestamp = new Date().getTime();
    private JSONObject clickInfo;

    public FillrPageEventPayloadBuilder() {
    }

    public FillrPageEventPayloadBuilder(String url) {
        this();
        this.url = url;
    }

    public FillrPageEventPayloadBuilder(String url, FillrWidgetPageEvent type) {
        this(url);
        this.eventType = type;
    }

    public static FillrPageEventPayloadBuilder create() {
        return new FillrPageEventPayloadBuilder();
    }

    public static FillrPageEventPayloadBuilder create(String url) {
        return new FillrPageEventPayloadBuilder(url);
    }

    public static FillrPageEventPayloadBuilder create(String url, FillrWidgetPageEvent type) {
        return new FillrPageEventPayloadBuilder(url, type);
    }

    public FillrPageEventPayloadBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public FillrPageEventPayloadBuilder setEventType(FillrWidgetPageEvent type) {
        this.eventType = type;
        return this;
    }

    public FillrPageEventPayloadBuilder setEventType(String typeName) {
        this.eventType = FillrWidgetPageEvent.eventForName(typeName);
        return this;
    }

    public FillrPageEventPayloadBuilder setTimestamp() {
        this.timestamp = new Date().getTime();
        return this;
    }

    public FillrPageEventPayloadBuilder setTimestamp(long millisUtc) {
        this.timestamp = millisUtc;
        return this;
    }

    public FillrPageEventPayloadBuilder setTimestamp(Date date) {
        this.timestamp = date.getTime();
        return this;
    }

    public FillrPageEventPayloadBuilder setExtraInfo(JSONObject info) {
        this.clickInfo = info;
        return this;
    }

    public JSONObject buildJson() {
        JSONObject result = null;
        try {
            if (this.validate()) {
                result = new JSONObject();
                result.put("url", (Object)this.url);
                result.put("type", (Object)this.eventType.getFullName());
                result.put("timestamp", this.timestamp);
                if (this.clickInfo != null && this.eventType != FillrWidgetPageEvent.LOAD) {
                    result.put("info", (Object)this.clickInfo);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    private boolean validate() {
        return this.url != null && this.url.length() > 0 && this.eventType != null && this.eventType.isValidWithJson(this.clickInfo);
    }
}

